/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.LiveConnectProtectionDomain;
import com.opera.OriginNotAllowedException;
import com.opera.PluginClassLoader;
import com.opera.PluginContextManager;
import com.opera.PrivilegedFindClass;
import com.opera.PrivilegedGetField;
import com.opera.PrivilegedInvoke;
import com.opera.PrivilegedNewObject;
import com.opera.PrivilegedSetField;
import com.opera.PrivilegedThread;
import java.io.FilePermission;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import netscape.plugin.Plugin;

class LiveConnectPrivilegedActions {
    LiveConnectPrivilegedActions() {
    }

    public static Object newObject(Constructor constructor, Object[] objectArray, String string, int n) throws Exception {
        LiveConnectPrivilegedActions.originCheck(string, constructor.getDeclaringClass());
        return LiveConnectPrivilegedActions.doPrivileged(new PrivilegedNewObject(constructor, objectArray), string, n, false);
    }

    public static Object invoke(Object object, Method method, Object[] objectArray, String string, int n) throws Exception {
        LiveConnectPrivilegedActions.originCheck(string, method.getDeclaringClass());
        boolean bl = false;
        if (object != null) {
            bl = object instanceof Plugin;
        }
        return LiveConnectPrivilegedActions.doPrivileged(new PrivilegedInvoke(object, method, objectArray), string, n, bl);
    }

    public static Object getField(Field field, Object object, String string, int n) throws Exception {
        LiveConnectPrivilegedActions.originCheck(string, field.getDeclaringClass());
        return LiveConnectPrivilegedActions.doPrivileged(new PrivilegedGetField(field, object), string, n, false);
    }

    public static void setField(Field field, Object object, Object object2, String string, int n) throws Exception {
        LiveConnectPrivilegedActions.originCheck(string, field.getDeclaringClass());
        LiveConnectPrivilegedActions.doPrivileged(new PrivilegedSetField(field, object, object2), string, n, false);
    }

    public static Class findClass(String string, String string2, int n) throws Exception {
        return (Class)LiveConnectPrivilegedActions.doPrivileged(new PrivilegedFindClass(string), string2, n, false);
    }

    private static void originCheck(String string, Class clazz) throws OriginNotAllowedException {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null || clazz.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            return;
        }
        URL uRL = codeSource.getLocation();
        URL uRL2 = null;
        if (string != null) {
            try {
                uRL2 = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return;
            }
        }
        if (uRL != null && uRL2 != null) {
            InetAddress inetAddress = null;
            InetAddress inetAddress2 = null;
            try {
                inetAddress = InetAddress.getByName(uRL.getHost());
                inetAddress2 = InetAddress.getByName(uRL2.getHost());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (uRL.getProtocol().equalsIgnoreCase(uRL2.getProtocol()) && (inetAddress != null && inetAddress.equals(inetAddress2) || uRL.getHost().equalsIgnoreCase(uRL2.getHost())) && uRL.getPort() == uRL2.getPort()) {
                return;
            }
        }
        throw new OriginNotAllowedException("LiveConnect origin check failed for JavaScript trying to access Java object, caller=" + uRL2 + ", callee=" + uRL);
    }

    private static ProtectionDomain getProtectionDomain(String string) {
        URL uRL = null;
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        Policy policy = Policy.getPolicy();
        CodeSource codeSource = new CodeSource(uRL, null);
        final PermissionCollection permissionCollection = policy.getPermissions(codeSource);
        if (uRL != null) {
            if (uRL.getProtocol().equals("file")) {
                permissionCollection.add(new FilePermission("<<ALL FILES>>", "read"));
                permissionCollection.add(new SocketPermission("localhost", "connect,accept"));
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            String string = InetAddress.getLocalHost().getHostName();
                            permissionCollection.add(new SocketPermission(string, "connect,accept"));
                        }
                        catch (UnknownHostException unknownHostException) {}
                        return null;
                    }
                });
            } else {
                String string2 = uRL.getHost();
                if (string2 == null) {
                    string2 = "localhost";
                }
                permissionCollection.add(new SocketPermission(string2, "connect,accept"));
            }
        }
        return new LiveConnectProtectionDomain(permissionCollection);
    }

    private static AccessControlContext createAccessControllerContext(String string) throws Exception {
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{LiveConnectPrivilegedActions.getProtectionDomain(string)};
        return new AccessControlContext(protectionDomainArray);
    }

    private static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction, String string, int n, boolean bl) throws Exception {
        PluginClassLoader pluginClassLoader = null;
        PrivilegedThread privilegedThread = null;
        try {
            URL uRL = new URL(string);
            pluginClassLoader = PluginContextManager.getContext(n).getLCClassLoader(uRL);
            privilegedThread = new PrivilegedThread(privilegedExceptionAction, LiveConnectPrivilegedActions.createAccessControllerContext(string));
            if (bl) {
                privilegedThread.run();
            } else {
                Thread thread = new Thread(pluginClassLoader.getThreadGroup(), privilegedThread);
                thread.setContextClassLoader(pluginClassLoader);
                thread.start();
                thread.join();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        if (privilegedThread.isException()) {
            throw (Exception)privilegedThread.getResult();
        }
        return privilegedThread.getResult();
    }
}

