/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.AppContextAdapter;
import com.opera.AppContextCreator;
import com.opera.AppletContextManager;
import com.opera.AppletPanel;
import com.opera.CertificateHandler;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.PropertyPermission;

public class AppletClassLoader
extends URLClassLoader {
    private static RuntimePermission usePolicyPermission = new RuntimePermission("usePolicy");
    private static PropertyPermission browserReadPerm = new PropertyPermission("browser", "read");
    private static PropertyPermission browserVerReadPerm = new PropertyPermission("browser.version", "read");
    private URL codeBase;
    private CodeSource codeSource;
    private String key;
    private AppContextAdapter appContext = null;
    private ThreadGroup threadGroup = null;
    private int usageCount = 0;
    private Object usageCountSync = new Object();

    URL getCodeBase() {
        return this.codeBase;
    }

    String getKey() {
        return this.key;
    }

    public AppletClassLoader(URL base, String key) {
        super(new URL[0]);
        this.codeBase = base;
        this.codeSource = new CodeSource(base, (Certificate[])null);
        this.key = key;
    }

    public void addJar(URL jar) {
        this.addURL(jar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadGroup getThreadGroup() {
        block7: {
            try {
                if (this.threadGroup != null && !this.threadGroup.isDestroyed()) break block7;
                this.threadGroup = new ThreadGroup(this.codeBase + "-threadGroup");
                this.threadGroup.setMaxPriority(4);
                AppContextCreator creatorThread = new AppContextCreator(this.threadGroup);
                creatorThread.setContextClassLoader(this);
                Object object = creatorThread.syncObject;
                synchronized (object) {
                    creatorThread.start();
                    try {
                        creatorThread.syncObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.appContext = creatorThread.appContext;
                }
                creatorThread = null;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        return this.threadGroup;
    }

    protected int getUsageCount() {
        return this.usageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void grab() {
        Object object = this.usageCountSync;
        synchronized (object) {
            ++this.usageCount;
            this.getThreadGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        Object object = this.usageCountSync;
        synchronized (object) {
            if (this.usageCount > 1) {
                --this.usageCount;
            } else {
                if (this.appContext != null) {
                    try {
                        this.appContext.dispose();
                    }
                    catch (IllegalThreadStateException ex) {
                        ex.printStackTrace(System.err);
                    }
                }
                this.usageCount = 0;
                this.appContext = null;
                this.threadGroup = null;
                AppletPanel.cacheClassLoader(this);
            }
        }
    }

    public AppContextAdapter getAppContext() {
        return this.appContext;
    }

    private String replaceEscapes(String inStr) throws NumberFormatException {
        StringBuffer unescaped = new StringBuffer();
        int i = 0;
        while (i < inStr.length()) {
            char c = inStr.charAt(i);
            if (c == '%') {
                c = (char)Integer.parseInt(inStr.substring(i + 1, i + 3), 16);
                i += 3;
            } else {
                ++i;
            }
            unescaped.append(c);
        }
        return unescaped.toString();
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        URL url = codeSource.getLocation();
        if (url == null) {
            Permissions permColl = new Permissions();
            ((PermissionCollection)permColl).add(new AllPermission());
            return permColl;
        }
        final PermissionCollection permColl = super.getPermissions(codeSource);
        if (url.getProtocol().equals("file")) {
            int endIndex;
            String path = url.getFile().replace('/', File.separatorChar);
            if (!path.endsWith(File.separator) && (endIndex = path.lastIndexOf(File.separatorChar)) != -1) {
                path = path.substring(0, endIndex + 1) + "-";
                path = this.replaceEscapes(path);
                permColl.add(new FilePermission(path, "read"));
            }
            permColl.add(new SocketPermission("localhost", "connect,accept"));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String host = InetAddress.getLocalHost().getHostName();
                        permColl.add(new SocketPermission(host, "connect,accept"));
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    return null;
                }
            });
            if (this.codeBase.getProtocol().equals("file")) {
                String bpath = this.codeBase.getFile().replace('/', File.separatorChar);
                if (bpath.endsWith(File.separator)) {
                    bpath = bpath + "-";
                }
                bpath = this.replaceEscapes(bpath);
                permColl.add(new FilePermission(bpath, "read"));
            }
        }
        permColl.add(browserReadPerm);
        permColl.add(browserVerReadPerm);
        if (codeSource.getCertificates() != null && !permColl.implies(usePolicyPermission) && this.allPermissionsGranted(codeSource)) {
            permColl.add(new AllPermission());
        }
        return permColl;
    }

    private boolean allPermissionsGranted(CodeSource codeSource) {
        if (System.getProperty("browser.opera.useCertificateHandler").equals("true")) {
            return CertificateHandler.checkCertificates(codeSource, AppletContextManager.getDocumentPtrFromClassLoader(this));
        }
        return false;
    }

    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url == null) {
            try {
                url = new URL(this.codeBase, name);
                if (!this.resourceExists(url)) {
                    url = null;
                }
            }
            catch (Exception e) {
                url = null;
            }
        }
        return url;
    }

    private boolean resourceExists(URL url) {
        boolean ok = true;
        try {
            URLConnection conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection hconn = (HttpURLConnection)conn;
                int code = hconn.getResponseCode();
                if (code == 200) {
                    return true;
                }
                if (code >= 400) {
                    return false;
                }
            } else {
                InputStream is = conn.getInputStream();
                is.close();
            }
        }
        catch (Exception ex) {
            ok = false;
        }
        return ok;
    }

    public Enumeration findResources(String name) throws IOException {
        if (name != null && name.indexOf("META-INF/services/javax.sound") != -1) {
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
        URL u = new URL(this.codeBase, name);
        if (!this.resourceExists(u)) {
            u = null;
        }
        final Enumeration<URL> e = super.findResources(name);
        final URL url = u;
        return new Enumeration(){
            private boolean done;

            public Object nextElement() {
                if (!this.done) {
                    if (e.hasMoreElements()) {
                        return e.nextElement();
                    }
                    this.done = true;
                    if (url != null) {
                        return url;
                    }
                }
                throw new NoSuchElementException();
            }

            public boolean hasMoreElements() {
                return !this.done && (e.hasMoreElements() || url != null);
            }
        };
    }

    public Class findClass(String name) throws ClassNotFoundException {
        if (name.equals("com.opera.LCInvoke")) {
            URL url = this.getResource(name.replace('.', '/').concat(".class"));
            if (url != null) {
                try {
                    URLConnection conn = url.openConnection();
                    if (conn != null) {
                        int size = conn.getContentLength();
                        byte[] classBuf = new byte[size];
                        conn.getInputStream().read(classBuf, 0, size);
                        return this.defineClass(name, classBuf, 0, size, new CodeSource(null, (Certificate[])null));
                    }
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException(name, ex);
                }
            }
            throw new ClassNotFoundException(name);
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                final String subpath = name.replace('.', '/').concat(".class");
                byte[] classFile = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return AppletClassLoader.this.readClassFile(new URL(AppletClassLoader.this.codeBase, subpath));
                    }
                });
                if (classFile == null) {
                    throw new ClassNotFoundException(name);
                }
                return this.defineClass(name, classFile, 0, classFile.length, this.codeSource);
            }
            catch (PrivilegedActionException e2) {
                throw new ClassNotFoundException(name, e2.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readClassFile(URL url) throws IOException {
        byte[] bytes;
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection && ((HttpURLConnection)conn).getResponseCode() >= 400) {
            throw new IOException("HTTP Connection failed.");
        }
        InputStream istream = conn.getInputStream();
        try {
            int size;
            if (size != -1) {
                int readBytes;
                bytes = new byte[size];
                for (size = conn.getContentLength(); size > 0; size -= readBytes) {
                    readBytes = istream.read(bytes, bytes.length - size, size);
                    if (readBytes != -1) continue;
                    throw new IOException("Unexpected EOF");
                }
            } else {
                byte[] newBytes;
                bytes = new byte[1024];
                int totalRead = 0;
                while ((size = istream.read(bytes, totalRead, bytes.length - totalRead)) != -1) {
                    if ((totalRead += size) < bytes.length) continue;
                    newBytes = new byte[totalRead * 2];
                    System.arraycopy(bytes, 0, newBytes, 0, totalRead);
                    bytes = newBytes;
                }
                if (totalRead != bytes.length) {
                    newBytes = new byte[totalRead];
                    System.arraycopy(bytes, 0, newBytes, 0, totalRead);
                    bytes = newBytes;
                }
            }
        }
        finally {
            istream.close();
        }
        return bytes;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int j;
        int i;
        String packageName = name.replace('/', '.');
        if (packageName.startsWith("[") && (i = packageName.lastIndexOf(91)) != -1 && i + 2 < packageName.length()) {
            packageName = packageName.substring(i + 2);
        }
        if ((j = packageName.lastIndexOf(46)) != -1) {
            System.getSecurityManager().checkPackageAccess(packageName.substring(0, j));
        }
        if (name.equals("com.opera.LCInvoke")) {
            return this.findClass(name);
        }
        return super.loadClass(name, resolve);
    }

    public URL[] getURLs() {
        URL[] urls = super.getURLs();
        URL[] ret_urls = new URL[urls.length + 1];
        System.arraycopy(urls, 0, ret_urls, 0, urls.length);
        ret_urls[ret_urls.length - 1] = this.codeBase;
        return ret_urls;
    }
}

