/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.AppletClassLoader;
import com.opera.AppletContextManager;
import com.opera.AppletManager;
import com.opera.AppletPanel;
import com.opera.CPointer;
import com.opera.JSObject;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class AppletContext
implements java.applet.AppletContext {
    private HashSet panels = new HashSet();
    private static boolean useAudioCache;
    private Hashtable audioCache = new Hashtable();
    private static boolean useImageCache;
    private Hashtable imageCache = new Hashtable();
    private AppletClassLoader lcClassLoader = null;
    private CPointer documentPtr;
    private int refMac = 0;

    protected static void setCachePolicy(boolean useImageCache, boolean useAudioCache) {
        AppletContext.useImageCache = useImageCache;
        AppletContext.useAudioCache = useAudioCache;
    }

    AppletClassLoader getLCClassLoader(URL docUrl) {
        try {
            if (this.lcClassLoader == null) {
                this.lcClassLoader = AppletPanel.getClassLoader(docUrl, docUrl, null, null);
                this.lcClassLoader.grab();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return this.lcClassLoader;
    }

    CPointer getDocumentPtr() {
        return this.documentPtr;
    }

    void documentDeleted() {
        this.documentPtr = null;
        if (this.lcClassLoader != null) {
            this.lcClassLoader.release();
            this.lcClassLoader = null;
        }
    }

    protected AppletContext(CPointer docPtr) {
        this.documentPtr = docPtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPanel(AppletPanel panel) {
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            this.panels.add(panel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePanel(AppletPanel panel) {
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            if (panel != null) {
                this.panels.remove(panel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean usesLoader(AppletClassLoader loader) {
        if (this.lcClassLoader == loader) {
            return true;
        }
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            Iterator elms = this.panels.iterator();
            while (elms.hasNext()) {
                AppletPanel panel = (AppletPanel)elms.next();
                if (!panel.usesLoader(loader)) continue;
                return true;
            }
            return false;
        }
    }

    private static void checkConnect(URL url) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                Permission perm = url.openConnection().getPermission();
                if (perm != null) {
                    security.checkPermission(perm);
                } else {
                    security.checkConnect(url.getHost(), url.getPort());
                }
            }
            catch (IOException ioe) {
                security.checkConnect(url.getHost(), url.getPort());
            }
        }
    }

    protected void setLoadingFinished(CPointer inlinePtr) {
        if (this.documentPtr != null && inlinePtr != null) {
            this.nativeSetLoadingFinished(this.documentPtr, inlinePtr);
        }
    }

    private native void nativeSetLoadingFinished(CPointer var1, CPointer var2);

    JSObject getJSWindow() {
        return this.getJSWindow(this.documentPtr);
    }

    private native JSObject getJSWindow(CPointer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Applet getApplet(String name) {
        name = name.toLowerCase();
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            Iterator elms = this.panels.iterator();
            while (elms.hasNext()) {
                AppletPanel panel = (AppletPanel)elms.next();
                String appname = panel.getParameter("name");
                if (appname == null || !name.equals(appname = appname.toLowerCase())) continue;
                return panel.getApplet();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getApplets() {
        Vector<Applet> applets = new Vector<Applet>();
        HashSet hashSet = this.panels;
        synchronized (hashSet) {
            Iterator e = this.panels.iterator();
            while (e.hasNext()) {
                applets.addElement(((AppletPanel)e.next()).getApplet());
            }
        }
        return applets.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioClip getAudioClip(final URL url) {
        AppletContext.checkConnect(url);
        Hashtable hashtable = this.audioCache;
        synchronized (hashtable) {
            SoftReference ref;
            AudioClip clip = null;
            if (useAudioCache && (ref = (SoftReference)this.audioCache.get(url)) != null) {
                clip = (AudioClip)ref.get();
            }
            if (clip == null) {
                clip = (AudioClip)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Class<?> clipImpl = Class.forName(AppletManager.getInstance().getAudioClipClassName());
                            Class[] argTypes = new Class[]{Class.forName("java.net.URL")};
                            Object[] consArgs = new Object[]{url};
                            Constructor<?> cons = clipImpl.getConstructor(argTypes);
                            AudioClip clip = (AudioClip)cons.newInstance(consArgs);
                            if (useAudioCache && clip != null) {
                                AppletContext.this.audioCache.put(url, new SoftReference<AudioClip>(clip));
                            }
                            return clip;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace(System.err);
                            return null;
                        }
                    }
                });
            }
            return clip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(URL url) {
        AppletClassLoader loader = (AppletClassLoader)Thread.currentThread().getContextClassLoader();
        AppletContext.checkConnect(url);
        Hashtable hashtable = this.imageCache;
        synchronized (hashtable) {
            SoftReference ref;
            Image image = null;
            if (useImageCache && (ref = (SoftReference)this.imageCache.get(url)) != null) {
                image = (Image)ref.get();
            }
            if (image == null) {
                try {
                    String s2;
                    InputStream inputstream;
                    String s = loader.getCodeBase().toString();
                    String s1 = url.toString();
                    int i = s1.indexOf(s);
                    if (i == 0 && (inputstream = loader.getResourceAsStream(s2 = s1.charAt(s.length()) == '/' ? s1.substring(s.length() + 1) : s1.substring(s.length()))) != null) {
                        BufferedInputStream bufferedinputstream = new BufferedInputStream(inputstream);
                        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                        byte[] abyte0 = new byte[8192];
                        int j = 0;
                        while ((j = bufferedinputstream.read(abyte0, 0, 8192)) != -1) {
                            bytearrayoutputstream.write(abyte0, 0, j);
                        }
                        bufferedinputstream.close();
                        byte[] abyte1 = bytearrayoutputstream.toByteArray();
                        if (abyte1 != null && abyte1.length > 0) {
                            image = Toolkit.getDefaultToolkit().createImage(abyte1);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                if (image == null) {
                    image = Toolkit.getDefaultToolkit().createImage(url);
                }
                if (useImageCache && image != null) {
                    this.imageCache.put(url, new SoftReference<Image>(image));
                }
            }
            return image;
        }
    }

    public void showDocument(URL url) {
        this.showDocument(url, "_top");
    }

    public void showDocument(URL url, String target) {
        String urlString = url.toString();
        this.showDocument(this.documentPtr, urlString, target);
    }

    private native void showDocument(CPointer var1, String var2, String var3);

    public void showStatus(String status) {
        if (this.documentPtr != null) {
            this.showStatus(this.documentPtr, status);
        }
    }

    private native void showStatus(CPointer var1, String var2);

    public void setStream(String key, InputStream stream) throws IOException {
    }

    public InputStream getStream(String key) {
        return null;
    }

    public Iterator getStreamKeys() {
        return null;
    }

    void incRefMac() {
        ++this.refMac;
    }

    void decRefMac() {
        if (--this.refMac == 0) {
            AppletContextManager.deleteContext(this);
        }
    }
}

