/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.CPointer;
import java.security.CodeSource;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

class CertificateHandler {
    CertificateHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean checkCertificates(CodeSource codeSource, CPointer docPtr) {
        try {
            Certificate[] certs = codeSource.getCertificates();
            if (certs.length == 0) {
                return false;
            }
            int start = 0;
            int i = 0;
            while (i < certs.length) {
                int j = start;
                while (j + 1 < certs.length && certs[j] instanceof X509Certificate && certs[j + 1] instanceof X509Certificate && CertificateHandler.isIssuerOf((X509Certificate)certs[j], (X509Certificate)certs[j + 1])) {
                    ++j;
                }
                i = j + 1;
                byte[][] encCerts = CertificateHandler.makeChain(certs, start, i);
                if (encCerts != null) {
                    SyncObject syncObj;
                    String host = codeSource.getLocation() != null ? codeSource.getLocation().getHost() : null;
                    SyncObject syncObject = syncObj = new SyncObject();
                    synchronized (syncObject) {
                        CertificateHandler.acceptCertificateChain(encCerts, syncObj, docPtr, host);
                        try {
                            syncObj.wait();
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                    return syncObj.accept;
                }
                start = i;
            }
            return false;
        }
        catch (CertificateEncodingException ex) {
            return false;
        }
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate1, X509Certificate x509Certificate2) {
        Principal principal2;
        Principal principal1 = x509Certificate1.getIssuerDN();
        return ((Object)principal1).equals(principal2 = x509Certificate2.getSubjectDN());
    }

    private static byte[][] makeChain(Certificate[] certs, int i, int j) throws CertificateEncodingException {
        if (i == j) {
            return null;
        }
        byte[][] encCert = new byte[j - i][];
        for (int k = i; k < j; ++k) {
            encCert[k - i] = certs[k].getEncoded();
        }
        return encCert;
    }

    private static native void acceptCertificateChain(byte[][] var0, SyncObject var1, CPointer var2, String var3);

    private static class SyncObject {
        boolean accept;

        private SyncObject() {
        }
    }
}

