/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;

class LC3Resolver {
    static Class jsobjectClass;
    static Class objectClass;
    static Class stringClass;
    static Class classClass;
    static Class doubleClass;
    static Class booleanClass;

    LC3Resolver() {
    }

    static Method resolveMethod(Class javaClass, String methodName, String jsSignature, Object[] unwrappedParams, boolean staticCall) {
        HashSet preferred = new HashSet();
        Method[] meths = javaClass.getMethods();
        for (int i = 0; i < meths.length; ++i) {
            if (!methodName.equals(meths[i].getName()) || staticCall && !Modifier.isStatic(meths[i].getModifiers()) || !LC3Resolver.isApplicable(meths[i].getParameterTypes(), jsSignature, unwrappedParams)) continue;
            LC3Resolver.addMethod(preferred, meths[i], jsSignature, unwrappedParams);
        }
        if (preferred.size() == 1) {
            return (Method)preferred.iterator().next();
        }
        return null;
    }

    static Constructor resolveConstructor(Class javaClass, String jsSignature, Object[] unwrappedParams, boolean staticCall) {
        HashSet preferred = new HashSet();
        Constructor<?>[] cons = javaClass.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            if (staticCall && !Modifier.isStatic(cons[i].getModifiers()) || !LC3Resolver.isApplicable(cons[i].getParameterTypes(), jsSignature, unwrappedParams)) continue;
            LC3Resolver.addConstructor(preferred, cons[i], jsSignature, unwrappedParams);
        }
        if (preferred.size() == 1) {
            return (Constructor)preferred.iterator().next();
        }
        return null;
    }

    private static void addMethod(HashSet preferred, Method method, String jsSignature, Object[] unwrappedParams) {
        Class[] m1Args = method.getParameterTypes();
        Iterator it = preferred.iterator();
        while (it.hasNext()) {
            Method method2 = (Method)it.next();
            Class[] m2Args = method2.getParameterTypes();
            int pref = LC3Resolver.computePreferred(m1Args, m2Args, jsSignature, unwrappedParams);
            if (pref < 0) {
                it.remove();
                continue;
            }
            if (pref <= 0) continue;
            return;
        }
        preferred.add(method);
    }

    private static void addConstructor(HashSet preferred, Constructor constructor, String jsSignature, Object[] unwrappedParams) {
        Class[] c1Args = constructor.getParameterTypes();
        Iterator it = preferred.iterator();
        while (it.hasNext()) {
            Constructor constructor2 = (Constructor)it.next();
            Class[] c2Args = constructor2.getParameterTypes();
            int pref = LC3Resolver.computePreferred(c1Args, c2Args, jsSignature, unwrappedParams);
            if (pref < 0) {
                it.remove();
                continue;
            }
            if (pref <= 0) continue;
            return;
        }
        preferred.add(constructor);
    }

    private static boolean isApplicable(Class[] javaParams, String jsSignature, Object[] unwrappedParams) {
        if (javaParams.length != jsSignature.length()) {
            return false;
        }
        block12: for (int i = 0; i < javaParams.length; ++i) {
            switch (jsSignature.charAt(i)) {
                case 'u': {
                    if (javaParams[i].equals(objectClass) || javaParams[i].equals(stringClass)) continue block12;
                    return false;
                }
                case 'b': {
                    if (javaParams[i].equals(Boolean.TYPE) || javaParams[i].equals(booleanClass) || javaParams[i].equals(objectClass) || javaParams[i].equals(stringClass)) continue block12;
                    return false;
                }
                case 'n': {
                    if (javaParams[i].equals(Double.TYPE) || javaParams[i].equals(doubleClass) || javaParams[i].equals(objectClass) || javaParams[i].equals(Float.TYPE) || javaParams[i].equals(Long.TYPE) || javaParams[i].equals(Integer.TYPE) || javaParams[i].equals(Short.TYPE) || javaParams[i].equals(Byte.TYPE) || javaParams[i].equals(Character.TYPE) || javaParams[i].equals(stringClass)) continue block12;
                    return false;
                }
                case 's': {
                    if (javaParams[i].equals(stringClass) || javaParams[i].equals(objectClass) || javaParams[i].equals(Double.TYPE) || javaParams[i].equals(Float.TYPE) || javaParams[i].equals(Long.TYPE) || javaParams[i].equals(Integer.TYPE) || javaParams[i].equals(Short.TYPE) || javaParams[i].equals(Byte.TYPE) || javaParams[i].equals(Character.TYPE)) continue block12;
                    return false;
                }
                case 'z': {
                    if (!javaParams[i].isPrimitive()) continue block12;
                    return false;
                }
                case 'j': {
                    if (unwrappedParams == null || javaParams[i].isInstance(unwrappedParams[i]) || javaParams[i].equals(stringClass) || javaParams[i].equals(Double.TYPE) || javaParams[i].equals(Float.TYPE) || javaParams[i].equals(Long.TYPE) || javaParams[i].equals(Integer.TYPE) || javaParams[i].equals(Short.TYPE) || javaParams[i].equals(Byte.TYPE) || javaParams[i].equals(Character.TYPE)) continue block12;
                    return false;
                }
                case 'a': {
                    if (unwrappedParams == null || javaParams[i].isInstance(unwrappedParams[i]) || javaParams[i].equals(stringClass)) continue block12;
                    return false;
                }
                case 'c': {
                    if (javaParams[i].equals(classClass) || javaParams[i].equals(jsobjectClass) || javaParams[i].equals(objectClass) || javaParams[i].equals(stringClass)) continue block12;
                    return false;
                }
                case 'A': {
                    if (javaParams[i].equals(jsobjectClass) || javaParams[i].equals(objectClass) || javaParams[i].equals(stringClass) || javaParams[i].isArray()) continue block12;
                    return false;
                }
                case 'o': {
                    if (javaParams[i].equals(jsobjectClass) || javaParams[i].equals(objectClass) || javaParams[i].equals(stringClass) || javaParams[i].equals(Double.TYPE) || javaParams[i].equals(Float.TYPE) || javaParams[i].equals(Long.TYPE) || javaParams[i].equals(Integer.TYPE) || javaParams[i].equals(Short.TYPE) || javaParams[i].equals(Byte.TYPE) || javaParams[i].equals(Character.TYPE)) continue block12;
                    return false;
                }
            }
        }
        return true;
    }

    private static int computePreferred(Class[] javaParams1, Class[] javaParams2, String jsSignature, Object[] unwrappedParams) {
        int[] w1 = LC3Resolver.computeWeightArray(javaParams1, jsSignature, unwrappedParams);
        int[] w2 = LC3Resolver.computeWeightArray(javaParams2, jsSignature, unwrappedParams);
        boolean pref1 = false;
        boolean pref2 = false;
        for (int i = 0; i < w1.length; ++i) {
            if (w1[i] > w2[i]) {
                pref1 = true;
                continue;
            }
            if (w1[i] < w2[i]) {
                pref2 = true;
                continue;
            }
            if (jsSignature.charAt(i) != 'a' && jsSignature.charAt(i) != 'j' || w1[i] != 9 || w2[i] != 9 || javaParams1[i].equals(javaParams2[i])) continue;
            if (javaParams2[i].isAssignableFrom(javaParams1[i])) {
                pref1 = true;
                continue;
            }
            if (!javaParams1[i].isAssignableFrom(javaParams2[i])) continue;
            pref2 = true;
        }
        if (pref1 && !pref2) {
            return -1;
        }
        if (!pref1 && pref2) {
            return 1;
        }
        return 0;
    }

    private static int[] computeWeightArray(Class[] javaParams, String jsSignature, Object[] unwrappedParams) {
        int len = javaParams.length;
        int[] weights = new int[len];
        for (int i = 0; i < len; ++i) {
            weights[i] = LC3Resolver.getWeight(javaParams[i], jsSignature.charAt(i), unwrappedParams[i]);
        }
        return weights;
    }

    private static int getWeight(Class javaType, char jsType, Object actualParam) {
        switch (jsType) {
            case 'u': {
                return 1;
            }
            case 'b': {
                if (javaType.equals(Boolean.TYPE)) {
                    return 4;
                }
                if (javaType.equals(booleanClass)) {
                    return 3;
                }
                if (javaType.equals(objectClass)) {
                    return 2;
                }
                return 1;
            }
            case 'n': {
                if (javaType.equals(Double.TYPE)) {
                    return 10;
                }
                if (javaType.equals(doubleClass)) {
                    return 9;
                }
                if (javaType.equals(Float.TYPE)) {
                    return 8;
                }
                if (javaType.equals(Long.TYPE)) {
                    return 7;
                }
                if (javaType.equals(Integer.TYPE)) {
                    return 6;
                }
                if (javaType.equals(Short.TYPE)) {
                    return 5;
                }
                if (javaType.equals(Character.TYPE)) {
                    return 4;
                }
                if (javaType.equals(Byte.TYPE)) {
                    return 3;
                }
                if (javaType.equals(stringClass)) {
                    return 2;
                }
                return 1;
            }
            case 's': {
                if (javaType.equals(stringClass)) {
                    return 4;
                }
                if (javaType.equals(objectClass)) {
                    return 3;
                }
                if (javaType.equals(Character.TYPE)) {
                    return 2;
                }
                return 1;
            }
            case 'z': {
                return 1;
            }
            case 'j': {
                if (javaType.equals(stringClass) && !(actualParam instanceof String)) {
                    return 8;
                }
                if (javaType.equals(Double.TYPE)) {
                    return 7;
                }
                if (javaType.equals(Float.TYPE)) {
                    return 6;
                }
                if (javaType.equals(Long.TYPE)) {
                    return 5;
                }
                if (javaType.equals(Integer.TYPE)) {
                    return 4;
                }
                if (javaType.equals(Short.TYPE)) {
                    return 3;
                }
                if (javaType.equals(Character.TYPE)) {
                    return 2;
                }
                if (javaType.equals(Byte.TYPE)) {
                    return 1;
                }
                return 9;
            }
            case 'a': {
                if (javaType.equals(stringClass)) {
                    return 1;
                }
                return 9;
            }
            case 'c': {
                if (javaType.equals(classClass)) {
                    return 4;
                }
                if (javaType.equals(jsobjectClass)) {
                    return 3;
                }
                if (javaType.equals(objectClass)) {
                    return 2;
                }
                return 1;
            }
            case 'A': {
                if (javaType.isArray()) {
                    return 4;
                }
                if (javaType.equals(jsobjectClass)) {
                    return 3;
                }
                if (javaType.equals(objectClass)) {
                    return 2;
                }
                return 1;
            }
            case 'o': {
                if (javaType.equals(jsobjectClass)) {
                    return 10;
                }
                if (javaType.equals(objectClass)) {
                    return 9;
                }
                if (javaType.equals(stringClass)) {
                    return 8;
                }
                if (javaType.equals(Double.TYPE)) {
                    return 7;
                }
                if (javaType.equals(Float.TYPE)) {
                    return 6;
                }
                if (javaType.equals(Long.TYPE)) {
                    return 5;
                }
                if (javaType.equals(Integer.TYPE)) {
                    return 4;
                }
                if (javaType.equals(Short.TYPE)) {
                    return 3;
                }
                if (javaType.equals(Character.TYPE)) {
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    static {
        try {
            jsobjectClass = Class.forName("netscape.javascript.JSObject");
            objectClass = Class.forName("java.lang.Object");
            stringClass = Class.forName("java.lang.String");
            classClass = Class.forName("java.lang.Class");
            doubleClass = Class.forName("java.lang.Double");
            booleanClass = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

