/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.AppletClassLoader;
import com.opera.AppletContextManager;
import com.opera.CPointer;
import com.opera.LiveConnectProtectionDomain;
import com.opera.OriginNotAllowedException;
import com.opera.PrivilegedFindClass;
import com.opera.PrivilegedGetField;
import com.opera.PrivilegedInvoke;
import com.opera.PrivilegedNewObject;
import com.opera.PrivilegedSetField;
import com.opera.PrivilegedThread;
import java.io.FilePermission;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import netscape.plugin.Plugin;

class LiveConnectPrivilegedActions {
    LiveConnectPrivilegedActions() {
    }

    static Object newObject(Constructor cons, Object[] params, String origin, CPointer docPtr) throws Exception {
        LiveConnectPrivilegedActions.originCheck(origin, cons.getDeclaringClass());
        return LiveConnectPrivilegedActions.doPrivileged(new PrivilegedNewObject(cons, params), origin, docPtr, false);
    }

    static Object invoke(Object obj, Method meth, Object[] params, String origin, CPointer docPtr) throws Exception {
        LiveConnectPrivilegedActions.originCheck(origin, meth.getDeclaringClass());
        boolean runInMainThread = false;
        if (obj != null) {
            runInMainThread = obj instanceof Plugin;
        }
        return LiveConnectPrivilegedActions.doPrivileged(new PrivilegedInvoke(obj, meth, params), origin, docPtr, runInMainThread);
    }

    static Object getField(Field field, Object obj, String origin, CPointer docPtr) throws Exception {
        LiveConnectPrivilegedActions.originCheck(origin, field.getDeclaringClass());
        return LiveConnectPrivilegedActions.doPrivileged(new PrivilegedGetField(field, obj), origin, docPtr, false);
    }

    static void setField(Field field, Object obj, Object val, String origin, CPointer docPtr) throws Exception {
        LiveConnectPrivilegedActions.originCheck(origin, field.getDeclaringClass());
        LiveConnectPrivilegedActions.doPrivileged(new PrivilegedSetField(field, obj, val), origin, docPtr, false);
    }

    static Class findClass(String name, String origin, CPointer docPtr) throws Exception {
        return (Class)LiveConnectPrivilegedActions.doPrivileged(new PrivilegedFindClass(name), origin, docPtr, false);
    }

    private static void originCheck(String origin, Class clazz) throws OriginNotAllowedException {
        ProtectionDomain pd = clazz.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        if (cs == null || clazz.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            return;
        }
        URL location = cs.getLocation();
        URL callerLocation = null;
        if (origin != null) {
            try {
                callerLocation = new URL(origin);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return;
            }
        }
        if (location != null && callerLocation != null) {
            if (location.getProtocol().equalsIgnoreCase("data")) {
                return;
            }
            InetAddress calleeInet = null;
            InetAddress callerInet = null;
            try {
                calleeInet = InetAddress.getByName(location.getHost());
                callerInet = InetAddress.getByName(callerLocation.getHost());
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
            if (location.getProtocol().equalsIgnoreCase(callerLocation.getProtocol()) && (calleeInet != null && calleeInet.equals(callerInet) || location.getHost().equalsIgnoreCase(callerLocation.getHost())) && location.getPort() == callerLocation.getPort()) {
                return;
            }
        }
        throw new OriginNotAllowedException("LiveConnect origin check failed for JavaScript trying to access Java object, caller=" + callerLocation + ", callee=" + location);
    }

    private static ProtectionDomain getProtectionDomain(String urlString) {
        URL url = null;
        if (urlString != null) {
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        Policy policy = Policy.getPolicy();
        Certificate[] certs = null;
        CodeSource codeSource = new CodeSource(url, certs);
        final PermissionCollection permColl = policy.getPermissions(codeSource);
        if (url != null) {
            if (url.getProtocol().equals("file")) {
                permColl.add(new FilePermission("<<ALL FILES>>", "read"));
                permColl.add(new SocketPermission("localhost", "connect,accept"));
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            String host = InetAddress.getLocalHost().getHostName();
                            permColl.add(new SocketPermission(host, "connect,accept"));
                        }
                        catch (UnknownHostException unknownHostException) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            } else {
                String host = url.getHost();
                if (host == null) {
                    host = "localhost";
                }
                permColl.add(new SocketPermission(host, "connect,accept"));
            }
        }
        return new LiveConnectProtectionDomain(permColl);
    }

    private static AccessControlContext createAccessControllerContext(String origin) throws Exception {
        ProtectionDomain[] domains = new ProtectionDomain[]{LiveConnectPrivilegedActions.getProtectionDomain(origin)};
        return new AccessControlContext(domains);
    }

    private static Object doPrivileged(PrivilegedExceptionAction action, String origin, CPointer docPtr, boolean runInMainThread) throws Exception {
        AppletClassLoader loader = null;
        PrivilegedThread privThread = null;
        try {
            URL originURL = new URL(origin);
            loader = AppletContextManager.getContext(docPtr).getLCClassLoader(originURL);
            privThread = new PrivilegedThread(action, LiveConnectPrivilegedActions.createAccessControllerContext(origin));
            if (runInMainThread) {
                privThread.run();
            } else {
                Thread t = new Thread(loader.getThreadGroup(), privThread);
                t.setContextClassLoader(loader);
                t.start();
                t.join();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        if (privThread.isException()) {
            throw (Exception)privThread.getResult();
        }
        return privThread.getResult();
    }
}

