#!/usr/bin/perl -w 
#
# Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
#
# get_guest_ip.pl
#
# This script returns the value of the guest_info variable 'ip' set by 
# the guest OS in a virtual machine on a given server.
#
# usage: 
#   get_guest_ip.pl <path_to_config_file> [<server> <user> <password>]
#

BEGIN {
   if ($^O eq "MSWin32") {
      @INC = (
         # Set the path to your VmPerl Scripting directory if different
         'C:\Program Files\VMware\VMware VmPerl Scripting API\perl5\site_perl\5.005',
         'C:\Program Files\VMware\VMware VmPerl Scripting API\perl5\site_perl\5.005\MSWin32-x86');
   }
}

use VMware::VmPerl;
use VMware::VmPerl::VM;
use VMware::VmPerl::ConnectParams;
use strict;

if (@ARGV ne 1  &&  @ARGV ne 4) {
   print "Usage $0: <path_to_config_file> [<server> <user> <password>]\n";
   exit(1);
}

# Read in parameters.
my ($cfg_path, $server_name, $user, $passwd) = @ARGV;

# Use the default port of 902.  Change this if your port is different.
my $port = 902;

# If $server_name, $user, and $passwd are missing, connect to localhost as current user.
my $connect_params = VMware::VmPerl::ConnectParams::new($server_name,$port,$user,$passwd);

my $vm = VMware::VmPerl::VM::new();
if (!$vm->connect($connect_params, $cfg_path)) {
   my ($error_number, $error_string) = $vm->get_last_error();
   undef $vm;
   die  "Could not connect to vm: Error $error_number: $error_string\n";
}

# Get the IP address of the virtual machine.
my $ip = $vm->get_guest_info('ip');
if (!defined($ip)) {
   my ($error_number, $error_string) = $vm->get_last_error();
   undef $vm;
   die  "Could not get IP address: Error $error_number: $error_string\n";
}
if (!($ip)) {
   undef $vm;
   die "The guest OS did not set the variable 'ip'.\n";
}
print "The IP address of $cfg_path is:\n$ip\n";

# Destroys the virtual machine object, thus disconnecting from the virtual machine.
undef $vm;




