<?php

/*
+--------------------------------------------------------------------------
|   IPB module UPGRADE FROM 1.1.X to v1.2
|   ========================================
|   by Koudanshi
|   http://www.Koudanshi.net
|   ========================================
|   Email: koudanshi@gmx.net
+---------------------------------------------------------------------------
|
|   > Script written by Koudanshi
|   > Date started: 10th Aug 2003
|
+--------------------------------------------------------------------------
*/

// Root path

$root_path = "./";
 
error_reporting  (E_ERROR | E_WARNING | E_PARSE);
set_magic_quotes_runtime(0);

require $root_path."mainfile.php";

//--------------------------------
// Load the DB driver and such
//--------------------------------

$INFO['sql_driver'] = !$INFO['sql_driver'] ? 'mySQL' : $INFO['sql_driver'];

$to_require = $root_path."modules/ipboard/sources/Drivers/".$INFO['sql_driver'].".php";
require ($to_require);

$DB = new db_driver;

$DB->obj['sql_database']     = XOOPS_DB_NAME;
$DB->obj['sql_user']         = XOOPS_DB_USER;
$DB->obj['sql_pass']         = XOOPS_DB_PASS;
$DB->obj['sql_host']         = XOOPS_DB_HOST;
$DB->obj['sql_tbl_prefix']   = XOOPS_DB_PREFIX."_";

// Get a DB connection

$DB->connect();

if ($_GET['act']=="struct")
{
	$sql=array(
		"DROP TABLE IF EXISTS ibf_admin_logs;",
		"CREATE TABLE ibf_admin_logs (
		  id bigint(20) NOT NULL auto_increment,
		  act varchar(255) NOT NULL default '',
		  code varchar(255) NOT NULL default '',
		  member_id int(10) NOT NULL default '0',
		  ctime int(10) NOT NULL default '0',
		  note text NOT NULL,
		  ip_address varchar(16) NOT NULL default '',
		  PRIMARY KEY  (id)
		) TYPE=MyISAM;",
		"DROP TABLE IF EXISTS ibf_admin_sessions;",
		"CREATE TABLE ibf_admin_sessions (
		  ID varchar(32) NOT NULL default '',
		  IP_ADDRESS varchar(16) NOT NULL default '',
		  MEMBER_NAME varchar(32) NOT NULL default '',
		  MEMBER_ID varchar(32) NOT NULL default '',
		  SESSION_KEY varchar(32) NOT NULL default '',
		  LOCATION varchar(64) default 'index',
		  LOG_IN_TIME int(10) NOT NULL default '0',
		  RUNNING_TIME int(10) NOT NULL default '0',
		  PRIMARY KEY  (ID)
		) TYPE=MyISAM;",
		"DROP TABLE IF EXISTS ibf_attachments;",

		"ALTER TABLE ibf_badwords CHANGE	  swop swop varchar(250) NOT NULL default '';",
		"ALTER TABLE ibf_badwords	CHANGE	  m_exact m_exact tinyint(1) NOT NULL default '0';",
		
		"CREATE TABLE ibf_cache_store (
		  cs_key varchar(255) NOT NULL default '',
		  cs_value text NOT NULL,
		  cs_extra varchar(255) NOT NULL default '',
		  PRIMARY KEY  (cs_key)
		) TYPE=MyISAM;",
		"ALTER TABLE ibf_calendar_events CHANGE  	eventid eventid mediumint(8) NOT NULL auto_increment",
		"ALTER TABLE ibf_calendar_events CHANGE  	userid userid mediumint(8) NOT NULL default '0'",
		"ALTER TABLE ibf_calendar_events CHANGE  	year year int(4) NOT NULL default '2003'",
		"ALTER TABLE ibf_calendar_events ADD 			event_ranged tinyint(1) NOT NULL default '0'",
		"ALTER TABLE ibf_calendar_events ADD  	  event_repeat tinyint(1) NOT NULL default '0'",
		"ALTER TABLE ibf_calendar_events ADD  	  repeat_unit char(2) NOT NULL default ''",
		"ALTER TABLE ibf_calendar_events ADD  	  end_day int(2) NOT NULL default '0'",
		"ALTER TABLE ibf_calendar_events ADD  	  end_month int(2) NOT NULL default '0'",
		"ALTER TABLE ibf_calendar_events ADD  	  end_year int(4) NOT NULL default '0'",
		"ALTER TABLE ibf_calendar_events ADD  	  end_unix_stamp int(10) NOT NULL default '0'",
		"ALTER TABLE ibf_calendar_events ADD  	  event_bgcolor varchar(32) NOT NULL default ''",
		"ALTER TABLE ibf_calendar_events ADD  	  event_color varchar(32) NOT NULL default ''",

		"ALTER TABLE ibf_categories CHANGE  	position position tinyint(3) NOT NULL default '0'",
		"ALTER TABLE ibf_categories CHANGE  	state state varchar(10) NOT NULL default ''",
		"ALTER TABLE ibf_categories CHANGE  	description description text NOT NULL",
		"ALTER TABLE ibf_categories CHANGE  	image image varchar(128) NOT NULL default ''",
		"ALTER TABLE ibf_categories CHANGE  	url url varchar(128) NOT NULL default ''",
 	
		"ALTER TABLE ibf_contacts CHANGE  	id id mediumint(8) NOT NULL auto_increment",
		"ALTER TABLE ibf_contacts CHANGE  	contact_id contact_id mediumint(8) NOT NULL default '0'",
		"ALTER TABLE ibf_contacts CHANGE  	member_id member_id mediumint(8) NOT NULL default '0'",
		"ALTER TABLE ibf_contacts CHANGE  	allow_msg allow_msg tinyint(1) NOT NULL default '0'",
		"ALTER TABLE ibf_contacts CHANGE  	contact_desc contact_desc varchar(50) NOT NULL default ''",

		"DROP TABLE IF EXISTS ibf_css;",
		"CREATE TABLE ibf_css (
		  cssid int(10) NOT NULL auto_increment,
		  css_name varchar(128) NOT NULL default '',
		  css_text text NOT NULL,
		  css_comments text NOT NULL,
		  updated int(10) NOT NULL default '0',
		  PRIMARY KEY  (cssid)
		) TYPE=MyISAM;",
		"CREATE TABLE ibf_email_logs (
		  email_id int(10) NOT NULL auto_increment,
		  email_subject varchar(255) NOT NULL default '',
		  email_content text NOT NULL,
		  email_date int(10) NOT NULL default '0',
		  from_member_id mediumint(8) NOT NULL default '0',
		  from_email_address varchar(250) NOT NULL default '',
		  from_ip_address varchar(16) NOT NULL default '127.0.0.1',
		  to_member_id mediumint(8) NOT NULL default '0',
		  to_email_address varchar(250) NOT NULL default '',
		  topic_id int(10) NOT NULL default '0',
		  PRIMARY KEY  (email_id),
		  KEY from_member_id (from_member_id),
		  KEY email_date (email_date)
		) TYPE=MyISAM;",
		"DROP TABLE IF EXISTS ibf_faq;",
		"CREATE TABLE ibf_faq (
		  id mediumint(8) NOT NULL auto_increment,
		  title varchar(128) NOT NULL default '',
		  text text NOT NULL,
		  description text NOT NULL,
		  PRIMARY KEY  (id)
		) TYPE=MyISAM;",	

		"CREATE TABLE ibf_forum_perms (
		  perm_id int(10) NOT NULL auto_increment,
		  perm_name varchar(250) NOT NULL default '',
		  PRIMARY KEY  (perm_id)
		) TYPE=MyISAM;",			
		"ALTER TABLE ibf_forum_tracker CHANGE  	frid frid mediumint(8) NOT NULL auto_increment",
		"ALTER TABLE ibf_forum_tracker CHANGE  	forum_id forum_id smallint(5) NOT NULL default '0'",
		"ALTER TABLE ibf_forum_tracker CHANGE  	start_date start_date int(10) NOT NULL default '0'",

    "ALTER TABLE ibf_forums CHANGE  topics topics mediumint(6) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  posts posts mediumint(6) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  last_post last_post int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  last_poster_id last_poster_id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  last_poster_name last_poster_name varchar(32) NOT NULL default ''",
    "ALTER TABLE ibf_forums CHANGE  description description text NOT NULL",
    "ALTER TABLE ibf_forums CHANGE  position position tinyint(2) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  use_ibc use_ibc tinyint(1) NOT NULL default '1'",
    "ALTER TABLE ibf_forums CHANGE  use_html use_html tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  status status varchar(10) NOT NULL default ''",
    "ALTER TABLE ibf_forums CHANGE  start_perms start_perms varchar(255) NOT NULL default ''",
    "ALTER TABLE ibf_forums CHANGE  reply_perms reply_perms varchar(255) NOT NULL default ''",
    "ALTER TABLE ibf_forums CHANGE  read_perms read_perms varchar(255) NOT NULL default ''",
    "ALTER TABLE ibf_forums CHANGE  password password varchar(32) NOT NULL default ''",
    "ALTER TABLE ibf_forums CHANGE  category category tinyint(2) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  last_title last_title varchar(128) NOT NULL default ''",
    "ALTER TABLE ibf_forums CHANGE  last_id last_id int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  sort_key sort_key varchar(32) NOT NULL default ''",
    "ALTER TABLE ibf_forums CHANGE  sort_order sort_order varchar(32) NOT NULL default ''",
    "ALTER TABLE ibf_forums CHANGE  prune prune tinyint(3) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  show_rules show_rules tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  upload_perms upload_perms varchar(255) NOT NULL default ''",
    "ALTER TABLE ibf_forums CHANGE  preview_posts preview_posts tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  skin_id skin_id int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  parent_id parent_id mediumint(5) NOT NULL default '-1'",
    "ALTER TABLE ibf_forums CHANGE  subwrap subwrap tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_forums CHANGE  sub_can_post sub_can_post tinyint(1) NOT NULL default '1'",

    "ALTER TABLE ibf_forums ADD  quick_reply tinyint(1) NOT NULL default '1'",
    "ALTER TABLE ibf_forums ADD  redirect_url varchar(250) NOT NULL default ''",
    "ALTER TABLE ibf_forums ADD  redirect_on tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_forums ADD  redirect_hits int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_forums ADD  redirect_loc varchar(250) NOT NULL default ''",
    "ALTER TABLE ibf_forums ADD  rules_title varchar(255) NOT NULL default ''",
    "ALTER TABLE ibf_forums ADD  rules_text text NOT NULL",
    "ALTER TABLE ibf_forums ADD  has_mod_posts tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_forums ADD  topic_mm_id varchar(250) NOT NULL default ''",

    "ALTER TABLE ibf_groups CHANGE  g_view_board g_view_board tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_mem_info g_mem_info tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_other_topics g_other_topics tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_use_search g_use_search tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_email_friend g_email_friend tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_invite_friend g_invite_friend tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_edit_profile g_edit_profile tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_post_new_topics g_post_new_topics tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_reply_own_topics g_reply_own_topics tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_reply_other_topics g_reply_other_topics tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_edit_posts g_edit_posts tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_delete_own_posts g_delete_own_posts tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_open_close_posts g_open_close_posts tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_delete_own_topics g_delete_own_topics tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_post_polls g_post_polls tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_vote_polls g_vote_polls tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_use_pm g_use_pm tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_is_supmod g_is_supmod tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_access_cp g_access_cp tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_can_remove g_can_remove tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_append_edit g_append_edit tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_access_offline g_access_offline tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_avoid_q g_avoid_q tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_avoid_flood g_avoid_flood tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_icon g_icon varchar(64) NOT NULL default ''",
    "ALTER TABLE ibf_groups CHANGE  g_attach_max g_attach_max bigint(20) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_avatar_upload g_avatar_upload tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_calendar_post g_calendar_post tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  prefix prefix varchar(250) NOT NULL default ''",
    "ALTER TABLE ibf_groups CHANGE  suffix suffix varchar(250) NOT NULL default ''",
    "ALTER TABLE ibf_groups CHANGE  g_max_messages g_max_messages int(5) NOT NULL default '50'",
    "ALTER TABLE ibf_groups CHANGE  g_max_mass_pm g_max_mass_pm int(5) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_search_flood g_search_flood mediumint(6) NOT NULL default '20'",
    "ALTER TABLE ibf_groups CHANGE  g_edit_cutoff g_edit_cutoff int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_promotion g_promotion varchar(10) NOT NULL default '-1&-1'",
    "ALTER TABLE ibf_groups CHANGE  g_hide_from_list g_hide_from_list tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups CHANGE  g_post_closed g_post_closed tinyint(1) NOT NULL default '0'",

    "ALTER TABLE ibf_groups ADD  g_perm_id varchar(255) NOT NULL default ''",
    "ALTER TABLE ibf_groups ADD  g_photo_max_vars varchar(200) NOT NULL default ''",
    "ALTER TABLE ibf_groups ADD  g_dohtml tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups ADD  g_edit_topic tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_groups ADD  g_email_limit varchar(15) NOT NULL default '10:15'",

		"DROP TABLE IF EXISTS ibf_languages;",
		"CREATE TABLE ibf_languages (
		  lid mediumint(8) NOT NULL auto_increment,
		  ldir varchar(64) NOT NULL default '',
		  lname varchar(250) NOT NULL default '',
		  lauthor varchar(250) NOT NULL default '',
		  lemail varchar(250) NOT NULL default '',
		  PRIMARY KEY  (lid)
		) TYPE=MyISAM;",
		"DROP TABLE IF EXISTS ibf_macro;",
		"CREATE TABLE ibf_macro (
		  macro_id smallint(3) NOT NULL auto_increment,
		  macro_value varchar(200) NOT NULL default '',
		  macro_replace text NOT NULL,
		  can_remove tinyint(1) NOT NULL default '0',
		  macro_set smallint(3) NOT NULL default '0',
		  PRIMARY KEY  (macro_id),
		  KEY macro_set (macro_set)
		) TYPE=MyISAM;",
		"DROP TABLE IF EXISTS ibf_macro_name;",
		"CREATE TABLE ibf_macro_name (
		  set_id smallint(3) NOT NULL default '0',
		  set_name varchar(200) NOT NULL default '',
		  PRIMARY KEY  (set_id)
		) TYPE=MyISAM;",
			
    "ALTER TABLE ibf_member_extra CHANGE  id id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_member_extra CHANGE  notes notes text NOT NULL",
    "ALTER TABLE ibf_member_extra CHANGE  links links text NOT NULL",
    "ALTER TABLE ibf_member_extra CHANGE  bio bio text NOT NULL",
    "ALTER TABLE ibf_member_extra CHANGE  ta_size ta_size char(3) NOT NULL default ''",
    "ALTER TABLE ibf_member_extra ADD  photo_type varchar(10) NOT NULL default ''",
    "ALTER TABLE ibf_member_extra ADD  photo_location varchar(255) NOT NULL default ''",
    "ALTER TABLE ibf_member_extra ADD  photo_dimensions varchar(200) NOT NULL default ''",

    "ALTER TABLE ibf_messages CHANGE  msg_id msg_id int(10) NOT NULL auto_increment",
    "ALTER TABLE ibf_messages CHANGE  msg_date msg_date int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_messages CHANGE  read_state read_state tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_messages CHANGE  title title varchar(128) NOT NULL default ''",
    "ALTER TABLE ibf_messages CHANGE  message message text NOT NULL",
    "ALTER TABLE ibf_messages CHANGE  from_id from_id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_messages CHANGE  vid vid varchar(32) NOT NULL default ''",
    "ALTER TABLE ibf_messages CHANGE  member_id member_id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_messages CHANGE  recipient_id recipient_id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_messages CHANGE  attach_type attach_type tinyint(128) NOT NULL default '0'",
    "ALTER TABLE ibf_messages CHANGE  attach_file attach_file tinyint(128) NOT NULL default '0'",
    "ALTER TABLE ibf_messages CHANGE  cc_users cc_users text NOT NULL",
    "ALTER TABLE ibf_messages CHANGE  tracking tracking tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_messages CHANGE  read_date read_date int(10) NOT NULL default '0'",

		"DROP TABLE IF EXISTS ibf_moderator_logs;",
		"CREATE TABLE ibf_moderator_logs (
		  id int(10) NOT NULL auto_increment,
		  forum_id int(5) NOT NULL default '0',
		  topic_id int(10) NOT NULL default '0',
		  post_id int(10) NOT NULL default '0',
		  member_id mediumint(8) NOT NULL default '0',
		  member_name varchar(32) NOT NULL default '',
		  ip_address varchar(16) NOT NULL default '0',
		  http_referer varchar(255) NOT NULL default '',
		  ctime int(10) NOT NULL default '0',
		  topic_title varchar(128) NOT NULL default '',
		  action varchar(128) NOT NULL default '',
		  query_string varchar(128) NOT NULL default '',
		  PRIMARY KEY  (id)
		) TYPE=MyISAM;",
    
    "ALTER TABLE ibf_moderators CHANGE  mid mid mediumint(8) NOT NULL auto_increment",
    "ALTER TABLE ibf_moderators CHANGE  member_id member_id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  edit_post edit_post tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  edit_topic edit_topic tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  delete_post delete_post tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  delete_topic delete_topic tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  view_ip view_ip tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  open_topic open_topic tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  close_topic close_topic tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  mass_move mass_move tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  mass_prune mass_prune tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  move_topic move_topic tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  pin_topic pin_topic tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  unpin_topic unpin_topic tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  post_q post_q tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  topic_q topic_q tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  allow_warn allow_warn tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  is_group is_group tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators CHANGE  group_name group_name varchar(200) NOT NULL default ''",
    "ALTER TABLE ibf_moderators CHANGE  split_merge split_merge tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_moderators ADD  can_mm tinyint(1) NOT NULL default '0'",

    "ALTER TABLE ibf_pfields_content CHANGE  member_id member_id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_pfields_content CHANGE  updated updated int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_pfields_content ADD  field_6 text NOT NULL",
    "ALTER TABLE ibf_pfields_content ADD  field_7 text NOT NULL",
    
    "ALTER TABLE ibf_pfields_data CHANGE  fdesc fdesc varchar(250) NOT NULL default ''",
    "ALTER TABLE ibf_pfields_data CHANGE  fcontent fcontent text NOT NULL",
    "ALTER TABLE ibf_pfields_data CHANGE  ftype ftype varchar(250) NOT NULL default 'text'",
    "ALTER TABLE ibf_pfields_data CHANGE  freq freq tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_pfields_data CHANGE  fhide fhide tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_pfields_data CHANGE  fmaxinput fmaxinput smallint(6) NOT NULL default '250'",
    "ALTER TABLE ibf_pfields_data CHANGE  fedit fedit tinyint(1) NOT NULL default '1'",
    "ALTER TABLE ibf_pfields_data CHANGE  forder forder smallint(6) NOT NULL default '1'",
    "ALTER TABLE ibf_pfields_data CHANGE  fshowreg fshowreg tinyint(1) NOT NULL default '0'",

    "ALTER TABLE ibf_polls CHANGE  pid pid mediumint(8) NOT NULL auto_increment",
    "ALTER TABLE ibf_polls CHANGE  tid tid int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_polls CHANGE  start_date start_date int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_polls CHANGE  choices choices text NOT NULL",
    "ALTER TABLE ibf_polls CHANGE  starter_id starter_id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_polls CHANGE  votes votes smallint(5) NOT NULL default '0'",
    "ALTER TABLE ibf_polls CHANGE  forum_id forum_id smallint(5) NOT NULL default '0'",
    "ALTER TABLE ibf_polls CHANGE  poll_question poll_question varchar(255) NOT NULL default ''",
 
    "ALTER TABLE ibf_posts CHANGE  pid pid int(10) NOT NULL auto_increment",
    "ALTER TABLE ibf_posts CHANGE  append_edit append_edit tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_posts CHANGE  edit_time edit_time int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_posts CHANGE  author_id author_id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_posts CHANGE  author_name author_name varchar(32) NOT NULL default ''",
    "ALTER TABLE ibf_posts CHANGE  use_sig use_sig tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_posts CHANGE  use_emo use_emo tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_posts CHANGE  ip_address ip_address varchar(16) NOT NULL default ''",
    "ALTER TABLE ibf_posts CHANGE  icon_id icon_id smallint(3) NOT NULL default '0'",
    "ALTER TABLE ibf_posts CHANGE  post post text NOT NULL",
    "ALTER TABLE ibf_posts CHANGE  queued queued tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_posts CHANGE  topic_id topic_id int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_posts CHANGE  forum_id forum_id smallint(5) NOT NULL default '0'",
    "ALTER TABLE ibf_posts CHANGE  attach_id attach_id varchar(64) NOT NULL default ''",
    "ALTER TABLE ibf_posts CHANGE  attach_hits attach_hits int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_posts CHANGE  attach_type attach_type varchar(128) NOT NULL default ''",
    "ALTER TABLE ibf_posts CHANGE  attach_file attach_file varchar(255) NOT NULL default ''",
    "ALTER TABLE ibf_posts CHANGE  post_title post_title varchar(255) NOT NULL default ''",
    "ALTER TABLE ibf_posts CHANGE  edit_name edit_name varchar(255) NOT NULL default ''",
  
    "ALTER TABLE ibf_posts ADD  FULLTEXT KEY post (post)",

    "ALTER TABLE ibf_reg_antispam CHANGE  ip_address ip_address varchar(32) NOT NULL default ''",
    "ALTER TABLE ibf_reg_antispam CHANGE  ctime ctime int(10) NOT NULL default '0'",    

		"DROP TABLE IF EXISTS ibf_rules;",
		
    "ALTER TABLE ibf_search_results CHANGE  member_id member_id mediumint(10) NOT NULL default '0'",
    "ALTER TABLE ibf_search_results CHANGE  ip_address ip_address varchar(64) NOT NULL default ''",
    "ALTER TABLE ibf_search_results CHANGE  post_id post_id text NOT NULL",
    "ALTER TABLE ibf_search_results CHANGE  post_max post_max int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_search_results ADD  query_cache text NOT NULL",

		"DROP TABLE IF EXISTS ibf_skin_templates;",
		"CREATE TABLE ibf_skin_templates (
		  suid int(10) NOT NULL auto_increment,
		  set_id int(10) NOT NULL default '0',
		  group_name varchar(255) NOT NULL default '',
		  section_content mediumtext NOT NULL,
		  func_name varchar(255) NOT NULL default '',
		  func_data text NOT NULL,
		  updated int(10) NOT NULL default '0',
		  can_remove tinyint(4) NOT NULL default '0',
		  PRIMARY KEY  (suid)
		) TYPE=MyISAM;",
		
		"DROP TABLE IF EXISTS ibf_skins;",
		"CREATE TABLE ibf_skins (
		  uid int(10) NOT NULL auto_increment,
		  sname varchar(100) NOT NULL default '',
		  sid int(10) NOT NULL default '0',
		  set_id int(5) NOT NULL default '0',
		  tmpl_id int(10) NOT NULL default '0',
		  macro_id int(10) NOT NULL default '1',
		  css_id int(10) NOT NULL default '1',
		  img_dir varchar(200) NOT NULL default '1',
		  tbl_width varchar(250) NOT NULL default '',
		  tbl_border varchar(250) NOT NULL default '',
		  hidden tinyint(1) NOT NULL default '0',
		  default_set tinyint(1) NOT NULL default '0',
		  css_method varchar(100) NOT NULL default 'inline',
		  PRIMARY KEY  (uid),
		  KEY tmpl_id (tmpl_id),
		  KEY css_id (css_id)
		) TYPE=MyISAM ;",

		"CREATE TABLE ibf_spider_logs (
		  sid int(10) NOT NULL auto_increment,
		  bot varchar(255) NOT NULL default '',
		  query_string text NOT NULL,
		  entry_date int(10) NOT NULL default '0',
		  ip_address varchar(16) NOT NULL default '',
		  PRIMARY KEY  (sid)
		) TYPE=MyISAM ;",

    "ALTER TABLE ibf_stats CHANGE  TOTAL_REPLIES TOTAL_REPLIES int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_stats CHANGE  TOTAL_TOPICS TOTAL_TOPICS int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_stats CHANGE  LAST_MEM_NAME LAST_MEM_NAME varchar(32) NOT NULL default ''",
    "ALTER TABLE ibf_stats CHANGE  LAST_MEM_ID LAST_MEM_ID mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_stats CHANGE  MOST_DATE MOST_DATE int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_stats CHANGE  MOST_COUNT MOST_COUNT int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_stats CHANGE  MEM_COUNT MEM_COUNT mediumint(8) NOT NULL default '0'",

		"DROP TABLE IF EXISTS ibf_templates;",
		"CREATE TABLE ibf_templates (
		  tmid int(10) NOT NULL auto_increment,
		  template mediumtext NOT NULL,
		  name varchar(128) NOT NULL default '',
		  PRIMARY KEY  (tmid)
		) TYPE=MyISAM ;",
 	
    "ALTER TABLE ibf_titles CHANGE  posts posts int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_titles CHANGE  title title varchar(128) NOT NULL default ''",
    "ALTER TABLE ibf_titles CHANGE  pips pips varchar(128) NOT NULL default ''",


		"DROP TABLE IF EXISTS ibf_tmpl_names;",
		"CREATE TABLE ibf_tmpl_names (
		  skid int(10) NOT NULL auto_increment,
		  skname varchar(60) NOT NULL default 'Invision Board',
		  author varchar(250) NOT NULL default '',
		  email varchar(250) NOT NULL default '',
		  url varchar(250) NOT NULL default '',
		  PRIMARY KEY  (skid)
		) TYPE=MyISAM;",
		"CREATE TABLE ibf_topic_mmod (
		  mm_id smallint(5) NOT NULL auto_increment,
		  mm_title varchar(250) NOT NULL default '',
		  mm_enabled tinyint(1) NOT NULL default '0',
		  topic_state varchar(10) NOT NULL default 'leave',
		  topic_pin varchar(10) NOT NULL default 'leave',
		  topic_move smallint(5) NOT NULL default '0',
		  topic_move_link tinyint(1) NOT NULL default '0',
		  topic_title_st varchar(250) NOT NULL default '',
		  topic_title_end varchar(250) NOT NULL default '',
		  topic_reply tinyint(1) NOT NULL default '0',
		  topic_reply_content text NOT NULL,
		  topic_reply_postcount tinyint(1) NOT NULL default '0',
		  PRIMARY KEY  (mm_id)
		) TYPE=MyISAM;",
			
    "ALTER TABLE ibf_topics CHANGE  tid tid int(10) NOT NULL auto_increment",
    "ALTER TABLE ibf_topics CHANGE  title title varchar(250) NOT NULL default ''",
    "ALTER TABLE ibf_topics CHANGE  description description varchar(70) NOT NULL default ''",
    "ALTER TABLE ibf_topics CHANGE  state state varchar(8) NOT NULL default ''",
    "ALTER TABLE ibf_topics CHANGE  posts posts smallint(4) NOT NULL default '0'",
    "ALTER TABLE ibf_topics CHANGE  starter_id starter_id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_topics CHANGE  start_date start_date int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_topics CHANGE  last_poster_id last_poster_id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_topics CHANGE  icon_id icon_id tinyint(2) NOT NULL default '0'",
    "ALTER TABLE ibf_topics CHANGE  starter_name starter_name varchar(32) NOT NULL default ''",
    "ALTER TABLE ibf_topics CHANGE  last_poster_name last_poster_name varchar(32) NOT NULL default ''",
    "ALTER TABLE ibf_topics CHANGE  poll_state poll_state varchar(8) NOT NULL default ''",
    "ALTER TABLE ibf_topics CHANGE  last_vote last_vote int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_topics CHANGE  views views smallint(5) NOT NULL default '0'",
    "ALTER TABLE ibf_topics CHANGE  forum_id forum_id smallint(5) NOT NULL default '0'",
    "ALTER TABLE ibf_topics CHANGE  author_mode author_mode tinyint(1) NOT NULL default '0'",
    "ALTER TABLE ibf_topics CHANGE  moved_to moved_to varchar(64) NOT NULL default ''",
    "ALTER TABLE ibf_topics CHANGE  rating rating text NOT NULL",

    "ALTER TABLE ibf_topics DROP INDEX forum_id",

    "ALTER TABLE ibf_topics ADD  KEY last_post (last_post)",
    "ALTER TABLE ibf_topics ADD  KEY forum_id (forum_id,approved,pinned)",
    "ALTER TABLE ibf_topics ADD  FULLTEXT KEY title (title)",

    "ALTER TABLE ibf_tracker CHANGE  trid trid mediumint(8) NOT NULL auto_increment",
    "ALTER TABLE ibf_tracker CHANGE  member_id member_id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE ibf_tracker CHANGE  start_date start_date int(10) NOT NULL default '0'",

		"CREATE TABLE ibf_validating (
		  vid varchar(32) NOT NULL default '',
		  member_id mediumint(8) NOT NULL default '0',
		  real_group smallint(3) NOT NULL default '0',
		  temp_group smallint(3) NOT NULL default '0',
		  entry_date int(10) NOT NULL default '0',
		  coppa_user tinyint(1) NOT NULL default '0',
		  lost_pass tinyint(1) NOT NULL default '0',
		  new_reg tinyint(1) NOT NULL default '0',
		  email_chg tinyint(1) NOT NULL default '0',
		  ip_address varchar(16) NOT NULL default '0',
		  PRIMARY KEY  (vid),
		  KEY new_reg (new_reg)
		) TYPE=MyISAM;",
	
    "ALTER TABLE ibf_voters CHANGE  vid vid int(10) NOT NULL auto_increment",
    "ALTER TABLE ibf_voters CHANGE  tid tid int(10) NOT NULL default '0'",
    "ALTER TABLE ibf_voters CHANGE  member_id member_id varchar(32) NOT NULL default ''",
    "ALTER TABLE ibf_voters CHANGE  forum_id forum_id smallint(5) NOT NULL default '0'",

		"CREATE TABLE ibf_warn_logs (
		  wlog_id int(10) NOT NULL auto_increment,
		  wlog_mid mediumint(8) NOT NULL default '0',
		  wlog_notes text NOT NULL,
		  wlog_contact varchar(250) NOT NULL default 'none',
		  wlog_contact_content text NOT NULL,
		  wlog_date int(10) NOT NULL default '0',
		  wlog_type varchar(6) NOT NULL default 'pos',
		  wlog_addedby mediumint(8) NOT NULL default '0',
		  PRIMARY KEY  (wlog_id)
		) TYPE=MyISAM;",	
		"DROP TABLE IF EXISTS xbb_session;",
		"CREATE TABLE xbb_session (
		  sess_id varchar(32) NOT NULL default '',
		  sess_updated int(10) unsigned NOT NULL default '0',
		  sess_ip varchar(15) NOT NULL default '',
		  sess_data text NOT NULL,
		  member_name varchar(64) NOT NULL default '',
		  member_id mediumint(8) NOT NULL default '0',
		  browser varchar(64) NOT NULL default '',
		  login_type tinyint(1) NOT NULL default '0',
		  location varchar(40) NOT NULL default '',
		  member_group smallint(3) NOT NULL default '0',
		  in_forum smallint(5) NOT NULL default '0',
		  in_topic int(10) NOT NULL default '0',
		  PRIMARY KEY  (sess_id),
		  KEY updated (sess_updated),
		  KEY in_topic (in_topic),
		  KEY in_forum (in_forum)
		) TYPE=MyISAM;",	
					
    "ALTER TABLE xbb_smiles CHANGE  id id smallint(3) NOT NULL auto_increment",
    "ALTER TABLE xbb_smiles CHANGE  code code varchar(32) NOT NULL default ''",
    "ALTER TABLE xbb_smiles CHANGE  smile_url smile_url varchar(128) NOT NULL default ''",

    "ALTER TABLE xbb_users CHANGE  uid uid int(10) unsigned NOT NULL auto_increment",
    "ALTER TABLE xbb_users CHANGE  uname uname varchar(50) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  email email varchar(150) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  url url varchar(250) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  user_avatar user_avatar varchar(128) NOT NULL default 'blank.gif'",
    "ALTER TABLE xbb_users CHANGE  user_icq user_icq varchar(30) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  user_from user_from varchar(128) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  user_viewemail user_viewemail varchar(8) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  actkey actkey varchar(8) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  user_aim user_aim varchar(30) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  user_yim user_yim varchar(30) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  user_msnm user_msnm varchar(30) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  pass pass varchar(50) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  posts posts mediumint(7) unsigned NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  attachsig attachsig tinyint(1) NOT NULL default '1'",
    "ALTER TABLE xbb_users CHANGE  user_occ user_occ varchar(100) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  user_intrest user_intrest text NOT NULL",
    "ALTER TABLE xbb_users CHANGE  mgroup mgroup smallint(3) NOT NULL default '3'",
    "ALTER TABLE xbb_users CHANGE  avatar_size avatar_size varchar(9) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  title title varchar(64) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  allow_admin_mails allow_admin_mails tinyint(1) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  email_pm email_pm tinyint(1) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  email_full email_full tinyint(1) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  skin skin smallint(5) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  warn_level warn_level int(10) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  signature signature text NOT NULL",
    "ALTER TABLE xbb_users CHANGE  language language varchar(32) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  last_post last_post int(10) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  allow_post restrict_post varchar(100) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  view_img view_img tinyint(1) NOT NULL default '1'",
    "ALTER TABLE xbb_users CHANGE  view_avs view_avs tinyint(1) NOT NULL default '1'",
    "ALTER TABLE xbb_users CHANGE  view_pop view_pop tinyint(1) NOT NULL default '1'",
    "ALTER TABLE xbb_users CHANGE  bday_day bday_day int(2) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  bday_month bday_month int(2) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  bday_year bday_year int(4) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  new_msg new_msg tinyint(2) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  msg_from_id msg_from_id mediumint(8) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  msg_msg_id msg_msg_id int(10) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  msg_total msg_total smallint(5) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  vdirs vdirs text NOT NULL",
    "ALTER TABLE xbb_users CHANGE  show_popup show_popup tinyint(1) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  misc misc varchar(128) NOT NULL default ''",
    "ALTER TABLE xbb_users CHANGE  last_visit last_visit int(10) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  last_activity last_activity int(10) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  dst_in_use dst_in_use tinyint(1) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  view_prefs view_prefs varchar(64) NOT NULL default '-1&-1'",
    "ALTER TABLE xbb_users CHANGE  coppa_user coppa_user tinyint(1) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  mod_posts mod_posts varchar(100) NOT NULL default '0'",
    "ALTER TABLE xbb_users CHANGE  auto_track auto_track tinyint(1) NOT NULL default '0'",

    "ALTER TABLE xbb_users DROP  validate_key ",
    "ALTER TABLE xbb_users DROP  prev_group ",
    "ALTER TABLE xbb_users DROP  new_pass ",

    "ALTER TABLE xbb_users ADD  warn_lastwarn int(10) NOT NULL default '0' after warn_level",
    "ALTER TABLE xbb_users ADD  org_perm_id varchar(255) NOT NULL default ''",
    "ALTER TABLE xbb_users ADD  org_supmod tinyint(1) NOT NULL default '0'",
    "ALTER TABLE xbb_users ADD  integ_msg varchar(250) NOT NULL default ''",
    "ALTER TABLE xbb_users ADD  temp_ban varchar(100) NOT NULL default ''"				
	);

	foreach ($sql as $dosql)
	{			
	  if(!$DB->query($dosql)) {	  	
	  	echo "Unsuccessful line <Br><br><font color=red>".$dosql."</font>";   
	  	exit;
	  }
	}
	$DB->query("UPDATE xbb_users SET restrict_post = 0 WHERE 1");
	$DB->query("UPDATE xbb_users SET notify_method = 2 WHERE 1");
	$DB->query("UPDATE xbb_users SET uid = 0 WHERE uname='Guest'");

?>
  <style type='text/css'>
  	TABLE, TR, TD     { font-family:Verdana, Arial;font-size: 11px; color:#333333 }
	BODY      { font: 11px Verdana; color:#333333 }
	a:link, a:visited, a:active  { color:#000055 }
	a:hover                      { color:#333377;text-decoration:underline }
	</style>
<?
	Echo"<br><Font color=Green><b>Upgraded tables's Struction Successfully</b></font><br>";
	echo"<br><a href='ipb_upgrade_113_12_xps.php?act=tpl'>Go to progress templates and others stuff</a>";
} 
else if($_GET['act']=="tpl")
{
	$sql_tpl=array(
	"INSERT INTO ibf_faq VALUES (1, 'Registration benefits', 'To be able to use all the features on this board, the administrator will probably require that you register for a member account. Registration is free and only takes a moment to complete.\r<br>\r<br>During registration, the administrator requires that you supply a valid email address. This is important as the administrator may require that you validate your registration via an email. If this is the case, you will be notified when registering. If your e-mail does not arrive, then on the member bar at the top of the page, there will be a link that will allow you to re-send the validation e-mail. \r<br>\r<br>In some cases, the administrator will need to approve your registration before you can use your member account fully. If this is the case you will be notified during registration.\r<br>\r<br>Once you have registered and logged in, you will have access to your personal messenger and your control panel.\r<br>\r<br>For more information on these items, please see the relevant sections in this documentation.', 'How to register and the added benefits of being a registered member.');",
	"INSERT INTO ibf_faq VALUES (2, 'Cookies and cookie usage', 'Using cookies is optional, but strongly recommended. Cookies are used to track topics, showing you which topics have new replies since your last visit and to automatically log you in when you return.\r<br>\r<br>If your computer is unable to use the cookie system to browse the board correctly, then the board will automatically add in a session ID to each link to track you around the board.\r<br>\r<br><b>Clearing Cookies</b>\r<br>\r<br>You can clear the cookies at any time by clicking on the link found at the bottom of the main board page (the first page you see when returning to the board). If this does not work for you, you may need to remove the cookies manually.\r<br>\r<br><u>Removing Cookies in Internet Explorer for Windows</u>\r<br>\r<br><ul>\r<br><li> Close all open Internet Explorer Windows\r<br><li> Click on the \'start\' button\r<br><li> Move up to \'Find\' and click on \'Files and Folders\'\r<br><li> When the new window appears, type in the domain name of the board you are using into the \'containing text\' field. (If the boards address was \'http://www.invisionboard.com/forums/index.php\' you would enter \'invisionboard.com\' without the quotes)\r<br><li> In the \'look in\' box, type in <b>C:WindowsCookies</b> and press \'Find Now\'\r<br><li> After it has finished searching, highlight all files (click on a file then press CTRL+A) and delete them.\r<br></ul>\r<br>\r<br><u>Removing Cookies in Internet Explorer for Macintosh</u>\r<br>\r<br><ul>\r<br><li> With Internet Explorer active, choose \'Edit\' and then \'Preferences\' from the Macintosh menu bar at the top of the screen\r<br><li> When the preferences panel opens, choose \'Cookies\' found in the \'Receiving Files\' section.\r<br><li> When the cookie pane loads, look for the domain name of the board (If the boards address was \'http://www.invisionboard.com/forums/index.php\' look for \'invisionboard.com\' or \'www.invisionboard.com\'\r<br><li> For each cookie, click on the entry and press the delete button.\r<br></ul>\r<br>\r<br>Your cookies should now be removed. In some cases you may need to restart your computer for the changes to take effect.', 'The benefits of using cookies and how to remove cookies set by this board.');",
	"INSERT INTO ibf_faq VALUES (3, 'Recovering lost or forgotten passwords', 'Security is a big feature on this board, and to that end, all passwords are encrypted when you register.\r<br>This means that we cannot email your password to you as we hold no record of your \'uncrypted\' password. You can however, apply to have your password reset.\r<br>\r<br>To do this, click on the <a href=\'index.php?act=Reg&CODE=10\'>Lost Password link</a> found on the log in page.\r<br>\r<br>Further instruction is available from there.', 'How to reset your password if you\'ve forgotton it.');",
	"INSERT INTO ibf_faq VALUES (4, 'Your Control Panel (My Controls)', 'Your control panel is your own private board console. You can change how the board looks and feels as well as your own information from here.\r<br>\r<br><b>Subscriptions</b>\r<br>\r<br>This is where you manage your topic and forums subscriptions. Please see the help file \'Email Notification of new messages\' for more information on how to subscribe to topics.\r<br>\r<br><b>Edit Profile Info</b>\r<br>\r<br>This section allows you to add or edit your contact information and enter some personal information if you choose.\r<br>\r<br><b>Edit Signature</b>\r<br>\r<br>A board \'signature\' is very similar to an email signature. This signature is attached to the foot of every message you post unless you choose to check the box that allows you to ommit the signature in the message you are posting. You may use BB Code if available and in some cases, pure HTML (if the board administrator allows it).\r<br>\r<br><b>Edit Avatar Settings</b>\r<br>\r<br>An avatar is a little image that appears under your username when you view a topic or post you authored. If the administrator allows, you may either choose from the board gallery, enter a URL to an avatar stored on your server or upload an avatar to use. You may also set the width of the avatar to ensure that it\'s sized in proportion.\r<br>\r<br><b>Change Personal Photo</b>\r<br>\r<br>This section will allow you to add a photograph to your profile. This will be displayed when a user clicks to view your profile, on the mini-profile screen and will also be linked to from the member list.\r<br>\r<br><b>Email Settings</b>\r<br>\r<br><u>Hide my email address</u> allows you to deny the ability for other users to send you an email from the board.\r<br><u>Send me updates sent by the board administrator</u> will allow the administrator to include your email address in any mailings they send out - this is used mostly for important updates and community information.\r<br><u>Include a copy of the post when emailing me from a subscribed topic</u>, this allows you to have the new post included in any reply to topic notifications.\r<br><u>Send a confirmation email when I receive a new private message</u>, this will send you an e-mail notification to your registered e-mail address each time you receive a private message on the board.\r<br><u>Enable \'Email Notification\' by default?</u>, this will automatically subscribe you to any topic that you make a reply to. You may unsubscribe from the \'Subscriptions\' section of My Controls if you wish.\r<br>\r<br><b>Board Settings</b>\r<br>\r<br>From this section, you can set your time zone, choose to not see users signatures, avatars and posted images.\r<br>You can choose to get a pop up window informing you when you have a new message and choose to show or hide the \'Fast Reply\' box where it is enabled.\r<br>You are also able to choose display preferences for the number of topics/posts shown per page on the board.\r<br>\r<br><b>Skins and Languages</b>\r<br>\r<br>If available, you can choose a skin style and language choice. This affects how the board is displayed so you may wish to preview the skin before submitting the form.\r<br>\r<br><b>Change Email Address</b>\r<br>\r<br>At any time, you can change the email address that is registered to your account. In some cases, you will need to revalidate your account after changing your email address. If this is the case, you will be notified before your email address change is processed.\r<br>\r<br><b>Change Password</b>\r<br>\r<br>You may change your password from this section. Please note that you will need to know your current password before you can change your password.', 'Editing contact information, personal information, avatars, signatures, board settings, languages and style choices.');",
	"INSERT INTO ibf_faq VALUES (5, 'Email Notification of new messages', 'This board can notify you when a new reply is added to a topic. Many users find this useful to keep up to date on topics without the need to view the board to check for new messages.\r<br>\r<br>There are three ways to subscribe to a topic:\r<br>\r<br><li>Click the \'Track This Topic\' link at the top of the topic that you wish to track\r<br><li> On the posting screen when replying to or creating a topic, check the \'Enable email notification of replies?\' checkbox\r<br><li> From the E-Mail settings section of your User CP (My Controls) check the \'Enable Email Notification by default?\' option, this will automatically subscribe you to any topic that you make a reply to\r<br>\r<br>Please note that to avoid multiple emails being sent to your email address, you will only get one e-mail for each topic you are subscribed to until the next time you visit the board.\r<br>\r<br>You are also able to subscribe to each individual forum on the board, to be notified when a new topic is created in that particular forum. To enable this, click the \'Subscribe to this forum\' link at the bottom of the forum that you wish to subscribe to.\r<br>\r<br>To unsubscribe from any forums or topics that you are subscribed to - just go to the \'Subscriptions\' section of \'My Controls\' and you can do this from there.', 'How to get emailed when a new reply is added to a topic.');",
	"INSERT INTO ibf_faq VALUES (6, 'Your Personal Messenger', 'Your personal messenger acts much like an email account in that you can send and receive messages and store messages in folders.\r<br>\r<br><b>Send a new PM</b>\r<br>\r<br>This will allow you to send a message to another member. If you have names in your contact list, you can choose a name from it - or you may choose to enter a name in the relevant form field. This will be automatically filled in if you clicked a \'PM\' button on the board (from the member list or a post). If allowed, you may also be able to enter in multiple names in the box provided, will need to add one username per line.\r<br>If the administrator allows, you may use BB Code and HTML in your private message. If you choose to check the \'Add a copy of this message to you sent items folder\' box, a copy of the message will be saved for you for later reference. If you tick the \'Track this message?\' box, then the details of the message will be available in your \'Message Tracker\' where you will be able to see if/when it has been read.\r<br>\r<br><b>Go to Inbox</b>\r<br>\r<br>Your inbox is where all new messages are sent to. Clicking on the message title will show you the message in a similar format to the board topic view. You can also delete or move messages from your inbox.\r<br>\r<br><b>Empty PM Folders</b>\r<br>\r<br>This option provides you with a quick and easy way to clear out all of your PM folders.\r<br>\r<br><b>Edit Storage Folders</b>\r<br>\r<br>You may rename, add or remove folders to store messages is, allowing you to organise your messages to your preference. You cannot remove \'Sent Items\' or \'Inbox\'.\r<br>\r<br><b>PM Buddies/Block List</b>\r<br>\r<br>You may add in users names in this section, or edit any saved entries. You can also use this as a ban list, denying the named member the ability to message you.\r<br>Names entered in this section will appear in the drop down list when sending a new PM, allowing you to quickly choose the members name when sending a message.\r<br>\r<br><b>Archive Messages</b>\r<br>\r<br>If your messenger folders are full and you are unable to receive new messages, you can archive them off. This compiles the messages into a single HTML page or Microsoft ?Excel Format. This page is then emailed to your registered email address for your convenience.\r<br>\r<br><b>Saved (Unsent) PMs</b>\r<br>\r<br>This area will allow you to go back to any PM\'s that you have chosen to save to be sent later.\r<br>\r<br><b>Message Tracker</B>\r<br>\r<br>This is the page that any messages that you have chosen to track will appear. Details of if and when they have been read by the recipient will appear here. This also gives you the chance to delete any messages that you have sent and not yet been read by the intended recipient.', 'How to send personal messages, track them, edit your messenger folders and archive stored messages.');",
	"INSERT INTO ibf_faq VALUES (7, 'Contacting the moderating team & reporting posts', '<b>Contacting the moderating team</b>\r<br>\r<br>If you need to contact a moderator or simply wish to view the complete administration team, you can click the link \'The moderating team\' found at the bottom of the main board page (the first page you see when visiting the board), or from \'My Assistant\'.\r<br>\r<br>This list will show you administrators (those who have administration control panel access), global moderators (those who can moderate in all forums) and the moderators of the individual forums.\r<br>\r<br>If you wish to contact someone about your member account, then contact an administrator - if you wish to contact someone about a post or topic, contact either a global moderator or the forum moderator.\r<br>\r<br><b>Reporting a post</b>\r<br>\r<br>If the administrator has enabled this function on the board, you\'ll see a \'Report\' button in a post, next to the \'Quote\' button. This function will let you report the post to the forum moderator (or the administrator(s), if there isn\'t a specific moderator available). You can use this function when you think the moderator(s) should be aware of the existance of that post. However, <b>do not use this to chat with the moderator(s)!</b>. You can use the email function or the Personal Messenger function for that.', 'Where to find a list of the board moderators and administrators.');",
	"INSERT INTO ibf_faq VALUES (8, 'Viewing members profile information', 'You can view a members profile at any time by clicking on their name when it is underlined (as a link) or by clicking on their name in a post within a topic.\r<br>\r<br>This will show you their profile page which contains their contact information (if they have entered some) and their \'active stats\'.\r<br>\r<br>You can also click on the \'Mini Profile\' button underneath their posts, this will show up a mini \'e-card\' with their contact information and a photograph if they have chosen to have one.', 'How to view members contact information.');",
	"INSERT INTO ibf_faq VALUES (9, 'Viewing active topics and new posts', 'You can view which new topics have new replies today by clicking on the \'Today\'s Active Topics\' link found at the bottom of the main board page (the first page you see when visiting the board). You can set your own date criteria, choosing to view all topics  with new replies during several date choices.\r<br>\r<br>The \'View New Posts\' link in the member bar at the top of each page, will allow you to view all of the topics which have new replies in since your last visit to the board.', 'How to view all the topics which have a new reply today and the new posts made since your last visit.');",
	"INSERT INTO ibf_faq VALUES (10, 'Searching Topics and Posts', 'The search feature is designed to allow you to quickly find topics and posts that contain the keywords you enter.\r<br>\r<br>There are two types of search form available, simple search and advanced search. You may switch between the two using the \'More Options\' and \'Simple Mode\' buttons.\r<br>\r<br><b>Simple Mode</b>\r<br>\r<br>All you need to do here is enter in a keyword into the search box, and select a forum(s) to search in. (to select multiple forums, hold down the control key on a PC, or the Shift/Apple key on a Mac) choose a sorting order and search.\r<br>\r<br><b>Advanced Mode</b>\r<br>\r<br>The advanced search screen, will give you a much greater range of options to choose from to refine your search. In addition to searching by keyword, you are able to search by a members username or a combination of both. You can also choose to refine your search by selecting a date range, and there are a number of sorting options available. There are also two ways of displaying the search results, can either show the post text in full or just show a link to the topic, can choose this using the radio buttons available.\r<br>\r<br>If the administrator has enabled it, you may have a minimum amount of time to wait between searches, this is known as search flood control.\r<br>\r<br>There are also search boxes available at the bottom of each forum, to allow you to carry out a quick search of all of the topics within that particular forum.', 'How to use the search feature.');",
	"INSERT INTO ibf_faq VALUES (11, 'Logging in and out', 'If you have chosen not to remember your log in details in cookies, or you are accessing the board on another computer, you will need to log into the board to access your member profile and post with your registered name.\r<br>\r<br>When you log in, you have the choice to save cookies that will log you in automatically when you return. Do not use this option on a shared computer for security.\r<br>\r<br>You can also choose to hide - this will keep your name from appearing in the active users list.\r<br>\r<br>Logging out is simply a matter of clicking on the \'Log Out\' link that is displayed when you are logged in. If you find that you are not logged out, you may need to manually remove your cookies. See the \'Cookies\' help file for more information.', 'How to log in and out from the board and how to remain anonymous and not be shown on the active users list.');",
	"INSERT INTO ibf_faq VALUES (13, 'My Assistant', 'This feature is sometimes referred to as a \'Browser Buddy\'. \r<br>\r<br>At the top it tells you how many posts have been made since you last visited the board.. Also underneath this the number of posts with replies that have been made in topics that the individual has also posted in.\r<br>Click on the \'View\' link on either of the two sentences to see the posts.\r<br>\r<br>The next section is five links to useful features:\r<br>\r<br><li>The link to the moderating team is basically a quick link to see all those that either administrate or moderate certain forums on the message board.\r<br><li> The link to \'Today\'s Active Topics\' shows you all the topics that have been created in the last 24 hours on the board.\r<br><li>Today\'s Top 10 Posters link shows you exactly as the name suggests. It shows you the amount of posts by the members and also their total percentage of the total posts made that day.\r<br><li>The overall Top 10 Posters link shows you the top 10 posters for the whole time that the board has been installed.\r<br><li>My last 10 posts links to the latest topics that you have made on the board. These are shortened on the page, to save space, and are linked to if you require to read more of them.\r<br>\r<br>The two search features allow you to search the whole board for certain words in a whole topic. It isn\'t as featured as the normal search option so it is not as comprehensive.\r<br>\r<br>The Help Search is just as comprehensive as the normal help section\'s search function and allows for quick searching of all the help topics on the board.', 'A comprehensive guide to use this handy little feature.');",
	"INSERT INTO ibf_faq VALUES (12, 'Posting', 'There are three different posting screens available. The new topic button, visible in forums and in topics allows you to add a new topic to that particular forum. The new poll button (is the admin has enabled it) will also be viewable in topics and forums allowing you to create a new poll in the forum. When viewing a topic, there will be an add reply button, allowing you to add a new reply onto that particular topic. \r\n<br>\r\n<br><b>Posting new topics and replying</b>\r\n<br>\r\n<br>When making a post, you will most likely have the option to use IBF code when posting. This will allow you to add various types of formatting to your messages. For more information on this, click the \'BB Code Help\' link under the emoticon box to launch the help window.\r\n<br>\r\n<br>On the left of the text entry box, there is the clickable emoticons box - you can click on these to add them to the content of your message (these are sometimes known as \'smilies\').\r\n<br>\r\n<br>There are three options available when making a post or a reply. \'Enable emoticons?\' if this is unchecked, then any text that would normally be converted into an emoticon will not be. \'Enable signature?\' allows you to choose whether or not you would like your signature to appear on that individual post. \'Enable email notification of replies?\' ticking this box will mean that you will receive e-mail updates to the topic, see the \'Email Notification of new messages\' help topic for more information on this.\r\n<br>\r\n<br>You also have the option to choose a post icon for the topic/post when creating one. This icon will appear next to the topic name on the topic listing in that forum, or will appear next to the date/time of the message if making a reply to a topic.\r\n<br>\r\n<br>If the admin has enabled it, you will also see a file attachments option, this will allow you to attach a file to be uploaded when making a post. Click the browse button to select a file from your computer to be uploaded. If you upload an image file, it may be shown in the content of the post, all other file types will be linked to.\r\n<br>\r\n<br><b>Poll Options</b>\r\n<br>\r\n<br>If you have chosen to post a new poll, there will be an extra two option boxes at the top of the help screen. The first input box will allow you to enter the question that you are asking in the poll. The text field underneath is where you will input the choices for the poll. Simply enter a different option on each line. The maximum number of choices is set by the board admin, and this figure is displayed on the left.\r\n<br>\r\n<br><b>Quoting Posts</b>\r\n<br>\r\n<br>Displayed above each post in a topic, there is a \'Quote\' button. Pressing this button will allow you to reply to a topic, and have the text from a particular reply quoted in your own reply. When you choose to do this, an extra text field will appear below the main text input box to allow you to edit the content of the post being quoted.\r\n<br>\r\n<br><b>Editing Posts</b>\r\n<br>\r\n<br>Above any posts that you have made, you may see an \'Edit\' button. Pressing this will allow you to edit the post that you had previously made. \r\n<br>\r\n<br>When editing you may see an option to \'Add the \'Edit by\' line in this post?\'. If you tick this then it will show up in the posts that it has been edited and the time at which it was edited. If this option does not appear, then the edit by line will always be added to the post.\r\n<br>\r\n<br>If you are unable to see the edit button displayed on each post that you have made, then the administrator may have prevented you from editing posts, or the time limit for editing may have expired.\r\n<br>\r\n<br><b>Fast Reply</b>\r\n<br>\r\n<br>Where it has been enabled, there will be a fast reply button on each topic. Clicking this will open up a posting box on the topic view screen, cutting down on the time required to load the main posting screen. Click the fast reply button to expand the reply box and type the post inside of there. Although the fast reply box is not expanded by default, you can choose the option to have it expanded by default, from the board settings section of your control panel. Pressing the \'More Options\' button will take you to the normal posting screen.', 'A guide to the features avaliable when posting on the boards.');",
	"INSERT INTO ibf_faq VALUES (14, 'Member List', 'The member list, accessed via the \'Members\' link at the top of each page, is basically a listing of all of the members that have registered on the board. \r\n<br>\r\n<br>If you are looking to search for a particular member by all/part of their username, then in the drop down box at the bottom of the page, change the selection from \'Search All Available\' to \'Name Begins With\' or \'Name Contains\' and input all/part of their name in the text input field and press the \'Go!\' button. \r\n<br>\r\n<br>Also, at the bottom of the member list page, there are a number of sorting options available to alter the way in which the list is displayed. \r\n<br>\r\n<br>If a member has chosen to add a photo to their profile information, then a camera icon will appear next to their name, and you may click this to view the photo.', 'Explaining the different ways to sort and search through the list of members.');",
	"INSERT INTO ibf_faq VALUES (15, 'Topic Options', 'At the bottom of each topic, there is a \'Topic Options\' button. Pressing this button will expand the topic options box. \r\n<br>\r\n<br>From this box, you can select from the following options: \r\n<br>\r\n<br><li>Track this topic - this option will allow you to receive e-mail updates for the topic, see the \'Email Notification of new messages\' help file for more information on this \r\n<br><li>Subscribe to this forum - will allow you to receive e-mail updates for any new topics posted in the forum, see the Notification of new messages\' help file for more information on this \r\n<br><li>Download / Print this Topic - will show the topic in a number of different formats. \'Printer Friendly Version\' will display a version of the topic that is suitable for printing out. \'Download HTML Version\' will download a copy of the topic to your hard drive, and this can then be viewed in a web browser, without having to visit the board. \'Download Microsoft Word Version\' will allow you to download the file to your hard drive and open it up in the popular word processing application, Microsoft Word, for viewing offline.', 'A guide to the options avaliable when viewing a topic.');",
	"INSERT INTO ibf_faq VALUES (16, 'Calendar', 'This board features it\'s very own calendar feature, which can be accessed via the calendar link at the top of the board.\r\n<br>\r\n<br>You are able to add your own personal events to the calendar - and these are only viewable by yourself. To add a new event, use the \'Add New Event\' button to be taken to the event posting screen. There are three types of events that you can now add:\r\n<br>\r\n<br><li>A single day/one off event can be added using the first option, by just selecting the date for it to appear on.\r\n<br><li>Ranged Event - is an event that spans across multiple days, to do this in addition to selecting the start date as above, will need to add the end date for the event. There are also options available  to highlight the message on the calendar, useful if there is more than one ranged event being displayed at any one time.\r\n<br><li>Recurring Event - is a one day event, that you can set to appear at set intervals on the calendar, either weekly, monthly or yearly.\r\n<br>\r\n<br>If the admistrator allows you, you may also be able to add a public event, that will not just be shown to yourself, but will be viewable by everyone.\r\n<br>\r\n<br>Also, if the admistrator has chosen,  there will be a link to all the birthdays happening on a particular day displayed on the calendar, and your birthday will appear if you have chosen to enter a date of birth in the Profile Info section of your control panel.', 'More information on the boards calendar feature.');",
  
	"INSERT INTO ibf_css VALUES (1, 'IPB Default CSS', '/* FIX IE6 Scrollbars bug - Leave this in! */\nhtml { overflow-x: auto; } \n\n/* Body entry, change forum page background colour, default font, font size, etc. Leave text-align:center to center board content\n   #ipwrapper will set text-align back to left for the forum. Any other tables / divs you use must use text-align:left to re-align\n   the content properly. This is a work around to a known Internet Explorer bug */\nBODY { font-family: Verdana, Tahoma, Arial, sans-serif; font-size: 11px; color: #000; margin:0px;padding:0px;background-color:#FFF; text-align:center }\nTABLE, TR, TD { font-family: Verdana, Tahoma, Arial, sans-serif; font-size: 11px; color: #000; }\n\n/* MAIN WRAPPER: Adjust forum width here. Leave margins alone to auto-center content */\n#ipbwrapper { text-align:left; width:95%; margin-left:auto;margin-right:auto }\n\na:link, a:visited, a:active { text-decoration: underline; color: #000 }\na:hover { color: #465584; text-decoration:underline }\n\nfieldset.search { padding:6px; line-height:150% }\nlabel      { cursor:pointer; }\nform       { display:inline; }\nimg        { vertical-align:middle; border:0px }\nimg.attach { border:2px outset #EEF2F7;padding:2px }\n\n.googleroot  { padding:6px; line-height:130% }\n.googlechild { padding:6px; margin-left:30px; line-height:130% }\n.googlebottom, .googlebottom a:link, .googlebottom a:visited, .googlebottom a:active { font-size:11px; color: #3A4F6C; }\n.googlish, .googlish a:link, .googlish a:visited, .googlish a:active { font-size:14px; font-weight:bold; color:#00D; }\n.googlepagelinks { font-size:1.1em; letter-spacing:1px }\n.googlesmall, .googlesmall a:link, .googlesmall a:active, .googlesmall a:visited { font-size:10px; color:#434951 }\n\nli.helprow { padding:0px; margin:0px 0px 10px 0px }\nul#help    { padding:0px 0px 0px 15px }\n\noption.cat { font-weight:bold; }\noption.sub { font-weight:bold;color:#555 }\n.caldate   { text-align:right;font-weight:bold;font-size:11px;color:#777;background-color:#DFE6EF;padding:4px;margin:0px }\n\n.warngood { color:green }\n.warnbad  { color:red }\n\n#padandcenter { margin-left:auto;margin-right:auto;text-align:center;padding:14px 0px 14px 0px }\n\n#profilename { font-size:28px; font-weight:bold; }\n#calendarname { font-size:22px; font-weight:bold; }\n\n#photowrap { padding:6px; }\n#phototitle { font-size:24px; border-bottom:1px solid black }\n#photoimg   { text-align:center; margin-top:15px } \n\n#ucpmenu    { line-height:150%;width:22%; border:1px solid #345487;background-color: #F5F9FD }\n#ucpmenu p  { padding:2px 5px 6px 9px;margin:0px; }\n#ucpcontent { background-color: #F5F9FD; border:1px solid #345487;line-height:150%; width:auto }\n#ucpcontent p  { padding:10px;margin:0px; }\n\n#ipsbanner { position:absolute;top:1px;right:5%; }\n#logostrip { border:1px solid #345487;background-color: #3860BB;background-image:url(style_images/<#IMG_DIR#>/tile_back.gif);padding:0px;margin:0px; }\n#submenu   { border:1px solid #BCD0ED;background-color: #DFE6EF;font-size:10px;margin:3px 0px 3px 0px;color:#3A4F6C;font-weight:bold;}\n#submenu a:link, #submenu  a:visited, #submenu a:active { font-weight:bold;font-size:10px;text-decoration: none; color: #3A4F6C; }\n#userlinks { border:1px solid #C2CFDF; background-color: #F0F5FA }\n\n#navstrip  { font-weight:bold;padding:6px 0px 6px 0px; }\n\n.activeuserstrip { background-color:#BCD0ED; padding:6px }\n\n/* Form stuff (post / profile / etc) */\n.pformstrip { background-color: #D1DCEB; color:#3A4F6C;font-weight:bold;padding:7px;margin-top:1px }\n.pformleft  { background-color: #F5F9FD; padding:6px; margin-top:1px;width:25%; border-top:1px solid #C2CFDF; border-right:1px solid #C2CFDF; }\n.pformleftw { background-color: #F5F9FD; padding:6px; margin-top:1px;width:40%; border-top:1px solid #C2CFDF; border-right:1px solid #C2CFDF; }\n.pformright { background-color: #F5F9FD; padding:6px; margin-top:1px;border-top:1px solid #C2CFDF; }\n\n/* Topic View elements */\n.signature   { font-size: 10px; color: #339; line-height:150% }\n.postdetails { font-size: 10px }\n.postcolor   { font-size: 12px; line-height: 160% }\n\n.normalname { font-size: 12px; font-weight: bold; color: #003 }\n.normalname a:link, .normalname a:visited, .normalname a:active { font-size: 12px }\n.unreg { font-size: 11px; font-weight: bold; color: #900 }\n\n.post1 { background-color: #F5F9FD }\n.post2 { background-color: #EEF2F7 }\n.postlinksbar { background-color:#D1DCEB;padding:7px;margin-top:1px;font-size:10px; background-image: url(style_images/<#IMG_DIR#>/tile_sub.gif) }\n\n/* Common elements */\n.row1 { background-color: #F5F9FD }\n.row2 { background-color: #DFE6EF }\n.row3 { background-color: #EEF2F7 }\n.row4 { background-color: #E4EAF2 }\n\n.darkrow1 { background-color: #C2CFDF; color:#4C77B6; }\n.darkrow2 { background-color: #BCD0ED; color:#3A4F6C; }\n.darkrow3 { background-color: #D1DCEB; color:#3A4F6C; }\n\n.hlight { background-color: #DFE6EF }\n.dlight { background-color: #EEF2F7 }\n\n.titlemedium { font-weight:bold; color:#3A4F6C; padding:7px; margin:0px; background-image: url(style_images/<#IMG_DIR#>/tile_sub.gif) }\n.titlemedium  a:link, .titlemedium  a:visited, .titlemedium  a:active  { text-decoration: underline; color: #3A4F6C }\n\n/* Main table top (dark blue gradient by default) */\n.maintitle { vertical-align:middle;font-weight:bold; color:#FFF; padding:8px 0px 8px 5px; background-image: url(style_images/<#IMG_DIR#>/tile_back.gif) }\n.maintitle a:link, .maintitle  a:visited, .maintitle  a:active { text-decoration: none; color: #FFF }\n.maintitle a:hover { text-decoration: underline }\n\n/* tableborders gives the white column / row lines effect */\n.plainborder { border:1px solid #345487;background-color:#F5F9FD }\n.tableborder { border:1px solid #345487;background-color:#FFF; padding:0; margin:0 }\n.tablefill   { border:1px solid #345487;background-color:#F5F9FD;padding:6px;  }\n.tablepad    { background-color:#F5F9FD;padding:6px }\n.tablebasic  { width:100%; padding:0px 0px 0px 0px; margin:0px; border:0px }\n\n.wrapmini    { float:left;line-height:1.5em;width:25% }\n.pagelinks   { float:left;line-height:1.2em;width:35% }\n\n.desc { font-size:10px; color:#434951 }\n.edit { font-size: 9px }\n\n\n.searchlite { font-weight:bold; color:#F00; background-color:#FF0 }\n\n#QUOTE { font-family: Verdana, Arial; font-size: 11px; color: #465584; background-color: #FAFCFE; border: 1px solid #000; padding-top: 2px; padding-right: 2px; padding-bottom: 2px; padding-left: 2px }\n#CODE  { font-family: Courier, Courier New, Verdana, Arial;  font-size: 11px; color: #465584; background-color: #FAFCFE; border: 1px solid #000; padding-top: 2px; padding-right: 2px; padding-bottom: 2px; padding-left: 2px }\n\n.copyright { font-family: Verdana, Tahoma, Arial, Sans-Serif; font-size: 9px; line-height: 12px }\n\n.codebuttons  { font-size: 10px; font-family: verdana, helvetica, sans-serif; vertical-align: middle }\n.forminput, .textinput, .radiobutton, .checkbox  { font-size: 11px; font-family: verdana, helvetica, sans-serif; vertical-align: middle }\n\n.thin { padding:6px 0px 6px 0px;line-height:140%;margin:2px 0px 2px 0px;border-top:1px solid #FFF;border-bottom:1px solid #FFF }\n\n.purple { color:purple;font-weight:bold }\n.red    { color:red;font-weight:bold }\n.green  { color:green;font-weight:bold }\n.blue   { color:blue;font-weight:bold }\n.orange { color:#F90;font-weight:bold }', '', 1060220052);",
	
	"INSERT INTO ibf_languages VALUES (1, 'en', 'English', '', '');",
	
	"INSERT INTO ibf_macro VALUES (1, 'A_LOCKED_B', '<img src=\'style_images/<#IMG_DIR#>/t_closed.gif\' border=\'0\'  alt=\'Closed Topic\' />', 1, 1);","INSERT INTO ibf_macro VALUES (2, 'A_MOVED_B', '<img src=\'style_images/<#IMG_DIR#>/t_moved.gif\' border=\'0\'  alt=\'Moved Topic\'>', 1, 1);","INSERT INTO ibf_macro VALUES (3, 'A_POLLONLY_B', '<img src=\'style_images/<#IMG_DIR#>/t_closed.gif\' border=\'0\'  alt=\'Poll Only\' />', 1, 1);","INSERT INTO ibf_macro VALUES (4, 'A_POST', '<img src=\'style_images/<#IMG_DIR#>/t_new.gif\' border=\'0\'  alt=\'Start new topic\' />', 1, 1);","INSERT INTO ibf_macro VALUES (5, 'A_REPLY', '<img src=\'style_images/<#IMG_DIR#>/t_reply.gif\' border=\'0\'  alt=\'Reply to this topic\' />', 1, 1);","INSERT INTO ibf_macro VALUES (6, 'A_POLL', '<img src=\'style_images/<#IMG_DIR#>/t_poll.gif\' border=\'0\'  alt=\'Start Poll\' />', 1, 1);","INSERT INTO ibf_macro VALUES (7, 'A_STAR', '<img src=\'style_images/<#IMG_DIR#>/pip.gif\' border=\'0\'  alt=\'*\' />', 1, 1);","INSERT INTO ibf_macro VALUES (8, 'B_HOT', '<img src=\'style_images/<#IMG_DIR#>/f_hot.gif\' border=\'0\'  alt=\'Hot topic\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (9, 'B_HOT_NN', '<img src=\'style_images/<#IMG_DIR#>/f_hot_no.gif\' border=\'0\'  alt=\'No new\' />', 1, 1);","INSERT INTO ibf_macro VALUES (10, 'B_LOCKED', '<img src=\'style_images/<#IMG_DIR#>/f_closed.gif\' border=\'0\'  alt=\'Closed\' />', 1, 1);","INSERT INTO ibf_macro VALUES (11, 'B_MOVED', '<img src=\'style_images/<#IMG_DIR#>/f_moved.gif\' border=\'0\'  alt=\'Moved\' />', 1, 1);","INSERT INTO ibf_macro VALUES (12, 'B_NEW', '<img src=\'style_images/<#IMG_DIR#>/f_norm.gif\' border=\'0\'  alt=\'New Posts\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (13, 'B_NORM', '<img src=\'style_images/<#IMG_DIR#>/f_norm_no.gif\' border=\'0\'  alt=\'No New Posts\' />', 1, 1);","INSERT INTO ibf_macro VALUES (14, 'B_PIN', '<img src=\'style_images/<#IMG_DIR#>/f_pinned.gif\' border=\'0\'  alt=\'Pinned\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (15, 'B_POLL', '<img src=\'style_images/<#IMG_DIR#>/f_poll.gif\' border=\'0\'  alt=\'Poll\' />', 1, 1);","INSERT INTO ibf_macro VALUES (16, 'B_POLL_NN', '<img src=\'style_images/<#IMG_DIR#>/f_poll_no.gif\' border=\'0\'  alt=\'No new votes\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (17, 'B_HOT_DOT', '<img src=\'style_images/<#IMG_DIR#>/f_hot_dot.gif\' border=\'0\' alt=\'New Posts\'>', 1, 1);",
	"INSERT INTO ibf_macro VALUES (18, 'B_NEW_DOT', '<img src=\'style_images/<#IMG_DIR#>/f_norm_dot.gif\' border=\'0\' alt=\'No New Posts\'>', 1, 1);","INSERT INTO ibf_macro VALUES (19, 'B_HOT_NN_DOT', '<img src=\'style_images/<#IMG_DIR#>/f_hot_no_dot.gif\' border=\'0\' alt=\'No New Posts*\'>', 1, 1);",
	"INSERT INTO ibf_macro VALUES (20, 'B_NORM_DOT', '<img src=\'style_images/<#IMG_DIR#>/f_norm_no_dot.gif\' border=\'0\' alt=\'No New Posts*\'>', 1, 1);",
	"INSERT INTO ibf_macro VALUES (21, 'B_POLL_DOT', '<img src=\'style_images/<#IMG_DIR#>/f_poll_dot.gif\' border=\'0\' alt=\'Poll*\'>', 1, 1);",
	"INSERT INTO ibf_macro VALUES (22, 'B_POLL_NN_DOT', '<img src=\'style_images/<#IMG_DIR#>/f_poll_no_dot.gif\' border=\'0\' alt=\'No New Votes*\'>', 1, 1);",
	"INSERT INTO ibf_macro VALUES (23, 'C_LOCKED', '<img src=\'style_images/<#IMG_DIR#>/bf_readonly.gif\' border=\'0\'  alt=\'Read Only Forum\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (24, 'C_OFF', '<img src=\'style_images/<#IMG_DIR#>/bf_nonew.gif\' border=\'0\'  alt=\'No New Posts\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (25, 'C_OFF_CAT', '<img src=\'style_images/<#IMG_DIR#>/bc_nonew.gif\' border=\'0\'  alt=\'No New Posts\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (26, 'C_OFF_RES', '<img src=\'style_images/<#IMG_DIR#>/br_nonew.gif\' border=\'0\'  alt=\'No New Posts\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (27, 'C_ON', '<img src=\'style_images/<#IMG_DIR#>/bf_new.gif\' border=\'0\'  alt=\'New Posts\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (28, 'C_ON_CAT', '<img src=\'style_images/<#IMG_DIR#>/bc_new.gif\' border=\'0\'  alt=\'New Posts\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (29, 'C_ON_RES', '<img src=\'style_images/<#IMG_DIR#>/br_new.gif\' border=\'0\'  alt=\'New Posts\'  />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (30, 'F_ACTIVE', '<img src=\'style_images/<#IMG_DIR#>/user.gif\' border=\'0\'  alt=\'Active Users\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (31, 'F_NAV_SEP', '&nbsp;-&gt;&nbsp;', 1, 1);",
	"INSERT INTO ibf_macro VALUES (32, 'F_NAV', '<img src=\'style_images/<#IMG_DIR#>/nav.gif\' border=\'0\'  alt=\'&gt;\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (33, 'F_STATS', '<img src=\'style_images/<#IMG_DIR#>/stats.gif\' border=\'0\'  alt=\'Board Stats\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (34, 'NO_PHOTO', '<img src=\'style_images/<#IMG_DIR#>/nophoto.gif\' border=\'0\'  alt=\'No Photo\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (35, 'CAMERA', '<img src=\'style_images/<#IMG_DIR#>/camera.gif\' border=\'0\'  alt=\'Photo\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (36, 'M_READ', '<img src=\'style_images/<#IMG_DIR#>/f_norm_no.gif\' border=\'0\'  alt=\'Read Msg\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (37, 'M_UNREAD', '<img src=\'style_images/<#IMG_DIR#>/f_norm.gif\' border=\'0\'  alt=\'Unread Msg\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (38, 'P_AOL', '<img src=\'style_images/<#IMG_DIR#>/p_aim.gif\' border=\'0\'  alt=\'AOL\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (39, 'P_DELETE', '<img src=\'style_images/<#IMG_DIR#>/p_delete.gif\' border=\'0\'  alt=\'Delete Post\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (40, 'P_EDIT', '<img src=\'style_images/<#IMG_DIR#>/p_edit.gif\' border=\'0\'  alt=\'Edit Post\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (41, 'P_EMAIL', '<img src=\'style_images/<#IMG_DIR#>/p_email.gif\' border=\'0\'  alt=\'Email Poster\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (42, 'P_ICQ', '<img src=\'style_images/<#IMG_DIR#>/p_icq.gif\' border=\'0\'  alt=\'ICQ\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (43, 'P_MSG', '<img src=\'style_images/<#IMG_DIR#>/p_pm.gif\' border=\'0\'  alt=\'PM\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (44, 'P_QUOTE', '<img src=\'style_images/<#IMG_DIR#>/p_quote.gif\' border=\'0\'  alt=\'Quote Post\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (45, 'P_WEBSITE', '<img src=\'style_images/<#IMG_DIR#>/p_www.gif\' border=\'0\'  alt=\'Users Website\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (46, 'P_YIM', '<img src=\'style_images/<#IMG_DIR#>/p_yim.gif\' border=\'0\' alt=\'Yahoo\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (47, 'P_REPORT', '<img src=\'style_images/<#IMG_DIR#>/p_report.gif\' border=\'0\'  alt=\'Report Post\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (48, 'P_MSN', '<img src=\'style_images/<#IMG_DIR#>/p_msn.gif\' border=\'0\' alt=\'MSN\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (49, 'CAT_IMG', '<img src=\'style_images/<#IMG_DIR#>/nav_m.gif\' border=\'0\'  alt=\'&gt;\' width=\'8\' height=\'8\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (50, 'NEW_POST', '<img src=\'style_images/<#IMG_DIR#>/newpost.gif\' border=\'0\'  alt=\'Goto last unread\' title=\'Goto last unread\' hspace=2>', 1, 1);",
	"INSERT INTO ibf_macro VALUES (51, 'LAST_POST', '<img src=\'style_images/<#IMG_DIR#>/lastpost.gif\' border=\'0\'  alt=\'Last Post\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (52, 'BR_REDIRECT', '<img src=\'style_images/<#IMG_DIR#>/br_redirect.gif\' border=\'0\'  alt=\'Redirect\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (53, 'INTEGRITY_MSGR', '<img src=\'style_images/<#IMG_DIR#>/p_im.gif\' border=\'0\'  alt=\'Integrity Messenger IM\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (54, 'ADDRESS_CARD', '<img src=\'style_images/<#IMG_DIR#>/addresscard.gif\' border=\'0\'  alt=\'Mini Profile\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (55, 'T_QREPLY', '<img src=\'style_images/<#IMG_DIR#>/t_qr.gif\' border=\'0\'  alt=\'Fast Reply\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (56, 'T_OPTS', '<img src=\'style_images/<#IMG_DIR#>/t_options.gif\' border=\'0\'  alt=\'Topic Options\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (57, 'CAL_NEWEVENT', '<img src=\'style_images/<#IMG_DIR#>/cal_newevent.gif\' border=\'0\'  alt=\'Add New Event\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (58, 'F_RULES', '<img src=\'style_images/<#IMG_DIR#>/forum_rules.gif\' border=\'0\'  alt=\'Forum Rules\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (59, 'WARN_0', '<img src=\'style_images/<#IMG_DIR#>/warn0.gif\' border=\'0\'  alt=\'-----\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (60, 'WARN_1', '<img src=\'style_images/<#IMG_DIR#>/warn1.gif\' border=\'0\'  alt=\'X----\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (61, 'WARN_2', '<img src=\'style_images/<#IMG_DIR#>/warn2.gif\' border=\'0\'  alt=\'XX---\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (62, 'WARN_3', '<img src=\'style_images/<#IMG_DIR#>/warn3.gif\' border=\'0\'  alt=\'XXX--\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (63, 'WARN_4', '<img src=\'style_images/<#IMG_DIR#>/warn4.gif\' border=\'0\'  alt=\'XXXX-\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (64, 'WARN_5', '<img src=\'style_images/<#IMG_DIR#>/warn5.gif\' border=\'0\'  alt=\'XXXXX\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (65, 'WARN_ADD', '<img src=\'style_images/<#IMG_DIR#>/warn_add.gif\' border=\'0\'  alt=\'+\' />', 1, 1);",
	"INSERT INTO ibf_macro VALUES (66, 'WARN_MINUS', '<img src=\'style_images/<#IMG_DIR#>/warn_minus.gif\' border=\'0\'  alt=\'-\' />', 1, 1);",
	"INSERT INTO ibf_macro_name VALUES (1, 'IPB Default Macro Set');",


	"INSERT INTO ibf_skins VALUES (1, 'Invision Power Board', 0, 1, 1, 1, 1, '1', '95%', '#999999', 0, 1, 'inline');",
	"INSERT INTO ibf_templates VALUES (1, '<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> \n<html xml:lang=\"en\" lang=\"en\" xmlns=\"http://www.w3.org/1999/xhtml\"> \n<head> \n<title><% TITLE %></title> \n<meta http-equiv=\"content-type\" content=\"text/html; charset=big5\" /> \n<% GENERATOR %> \n<% CSS %> \n<% JAVASCRIPT %> \n</head> \n<body>\n<div id=\"ipbwrapper\">\n<% BOARD HEADER %> \n<% NAVIGATION %> \n<% BOARD %> \n<% STATS %> \n<% COPYRIGHT %>\n</div>\n</body> \n</html>', 'Invision Board Standard');",
	"INSERT INTO ibf_tmpl_names VALUES (1, 'Invision Power Board Template Set', 'Invision Power Board', 'skins@invisionboard.com', 'http://www.invisionboard.com');",

	"INSERT INTO ibf_forum_perms VALUES (1, 'Validating Forum Mask');",
	"INSERT INTO ibf_forum_perms VALUES (3, 'Member Forum Mask');",
	"INSERT INTO ibf_forum_perms VALUES (2, 'Guest Forum Mask');",
	"INSERT INTO ibf_forum_perms VALUES (4, 'Admin Forum Mask');",
	"INSERT INTO ibf_forum_perms VALUES (5, 'Banned Forum Mask');"
	);
	foreach ($sql_tpl as $dosql)
	{			
	  if(!$DB->query($dosql)) {	  	
	  	echo "Unsuccessful line <Br><br><font color=red>".$dosql."</font>";   
	  	exit;
	  }
	}
	//-----------------------------------
	// Lets open the style file 
	//-----------------------------------
	
	$style_file = $root.'install_templates.txt';
	
	if ( ! file_exists($style_file) )
	{
		echo("Could not locate '$style_file'. <br><br>Check to ensure that this file exists in the same location as this script.<br><br>You may need to enter a value for the root path in this installer script, to do this, simply open up this script in a text editor and enter a value in \$root - remember to add a trailing slash. NT users will need to use double backslashes");
	}
	
	if ( $fh = fopen( $style_file, 'r' ) )
	{
		$data = fread($fh, filesize($style_file) );
		fclose($fh);
	}
	else
	{
		echo("Could open '$style_file'");
	}
	
	if (strlen($data) < 100)
	{
		echo("Err 1:'$style_file' is incomplete, please re-upload a fresh copy over the existing copy on the server'");
	}
	
	// Chop up the data file.
	
	$template_rows = explode( "||~&~||", $data );
	
	$crows = count($template_rows);
	
	if ( $crows < 100 )
	{
		echo("Err2: (Found $crows rows) '$style_file' is incomplete, please re-upload a fresh copy over the existing copy on the server'");
	}
	
	//-----------------------------------
	// Delete current skins in #1
	//-----------------------------------
	
	$DB->query("DELETE FROM ibf_skin_templates WHERE set_id=1");
	
	//-----------------------------------
	// Lets populate the database!
	//-----------------------------------
	
	foreach( $template_rows as $q )
	{
		$DB->error = "";
		
		$q = trim($q);
		
		//print $q;
	   
		if (strlen($q) < 5)
		{
			continue;
		}
		
		$DB->query("INSERT INTO ibf_skin_templates (set_id, group_name, section_content, func_name, func_data, updated, can_remove) VALUES $q");
			
		if ( $DB->error != "" )
		{
			echo( "mySQL Error: ".$DB->error );
		}
	}	  

?>
  <style type='text/css'>
  	TABLE, TR, TD     { font-family:Verdana, Arial;font-size: 11px; color:#333333 }
	BODY      { font: 11px Verdana; color:#333333 }
	a:link, a:visited, a:active  { color:#000055 }
	a:hover                      { color:#333377;text-decoration:underline }
	</style>
<?	
	
	Echo"<br><Font color=Green><b>Upgraded Successfully</b></font><br><br> Please! <font color=red>DELETE</font> this file for your security.<br>";
	echo"<br><a href='index.php'>Go to your board now</a>";
	
} 
else	
{
?>
  <head><title>IPB module Upgrade :: 1.1.x to 1.20 </title>
  <style type='text/css'>
  	TABLE, TR, TD     { font-family:Verdana, Arial;font-size: 11px; color:#333333 }
	BODY      { font: 11px Verdana; color:#333333 }
	a:link, a:visited, a:active  { color:#000055 }
	a:hover                      { color:#333377;text-decoration:underline }
	
	#title  { font-size:10px; font-weight:bold; line-height:150%; color:#FFFFFF; height: 24px; background-image: url(modules/ipboard/html/sys-img/top_cell.gif); }
	#title  a:link, #title  a:visited, #title  a:active { text-decoration: underline; color : #FFFFFF; font-size:11px }
	
	#detail { font-family: Arial; font-size:11px; color: #333333 }
	
	#large { font-family: verdana, arial; font-size:20px; color:#4C77B6; font-weight:bold; letter-spacing:-1px }
	
	#subtitle { font-family: Verdana; font-size:22px; color:#4C77B6; font-weight:bold }
	
	#warning { font-family: Verdana; font-size:22px; color:#FF0000; font-weight:bold }
	
	#table1 {  background-color:#F1F1F1; width:100%; align:center; border:1px solid black }
	
	#tdrow1 { background-color:#F3F3EE }
	
	#tdrow2 { background-color:#EBEBE4 }
	
	#catrow  { font-size:10px; font-weight:bold; line-height:150%; color:#4C77B6; background-color:#C2CFDF; }
	
	#tablewrap {  border:1px dashed #777777; background-color:#EFEFEF }
	
	#copy { color:#555555; font-size:9px }
	
	#tdtop  { font-weight:bold; height:20px; line-height:150%; color:#FFFFFF; background-image: url(modules/ipboard/html/sys-img/top_cell.gif); }
	
	#green    { background-color: #caf2d9 }
	#red      { background-color: #f5cdcd }
	
	#button   { background-color: #4C77B6; color: #FFFFFF; font-family:Verdana, Arial; font-size:11px }
	
	#textinput { background-color: #EEEEEE; color:?000000; font-family:Verdana, Arial; font-size:10px; width:100% }
	
	#dropdown { background-color: #EEEEEE; color:?000000; font-family:Verdana, Arial; font-size:10px }
	
	#multitext { background-color: #EEEEEE; color:?000000; font-family:Courier, Verdana, Arial; font-size:10px }
	
  </style>
  </head>
 <body marginheight='0' marginwidth='0' leftmargin='0' topmargin='0' bgcolor='#FFFFFF'> 
  <table width='100%' height='70' cellpadding='0' cellspacing='0' border='0'>
   <tr bgcolor='#4C77B6'>
	<td width='370' align='left' bgcolor='#4C77B6'><img src='modules/ipboard/html/sys-img/title.gif' width='370' height='70'></td>
   </tr>
  </table>
  <br>
<table width='90%' cellpadding='0' cellspacing='0' border='0' align='center'>
 <tr>
  <td id='subtitle'>&#149;&nbsp; IPBM v1.1.x to v1.20 ɯ</td>
   <tr>
	<td>
	 <table cellpadding='8' cellspacing='0' width='100%' align='center' border='0' id='tablewrap'>
	  <tr>
		<td>
		  <table width='100%' cellspacing='1' cellpadding='0' align='center' border='0' id='table1'>
		   <tr>
			<td>
			 <table width='100%' cellspacing='2' cellpadding='3' align='center' border='0'>
			  <tr>
			   <td>
			   		<b>wϥ IPBM 1.1.x tCqΤɯŤ</b>
			   		<br><br>
			   		<font color=blue><b>AɯūeХ`NHU:</b></font><br><br>
			   		1. <font color=red>ƥ</font> zҦ, onAF XOOPS PLҦ.
			   		<br><br>
						2. zN <B>Lkϥ</b> ª <B>IPB 1.1.x</B> O, ҥH, ɯŵ{N <font color=red></font> Q쥻G IPB  1.2. w]O <br>
						&nbsp;&nbsp;&nbsp;&nbsp;bϥηs IPB 1.2 OP, N| <font color=darkbkue>ipboard/skin/#</font> P <font color=darkbkue>ipboard/style_images/#</font><b> </b> ¦O <br>&nbsp;&nbsp;&nbsp;&nbsp;÷sW "<font color=blue><b>1</b></font>" w]OƧ.

			   		<br><br>
						3. zN <b>Lkϥ</b> ª <b>IPB 1.1.x</b> y], ҥH, ɯŵ{N <font color=red></font> Q쥻y] IPB  1.2. w]y]
						<br>&nbsp;&nbsp;&nbsp;&nbsp;bϥηs IPB 1.2 y]P, N| <font color=darkbkue>ipboard/lang/#</font> <b></b> ¦y] " ÷sW <font color=blue><b>1</b></font>" ӹw]y]Ƨ.

			   		<br><br>
			   		<font color=blue><b>`N:</b></font><br><br>
			   		Цbɯūe <font color=red>ƥ</font> zƮwNzªIPBQװϪl.
			   		Yz]楻ɯŵ{yƷl,ڭ̱NӾᦹd.<br>
			   		{ɯŮɱN|@w{׭I,
			   		Цۤv.
			   		<br><br>
			   		<font color=blue><b>}ls@~:</b></font><br><br>
  					<a href="ipb_upgrade_113_12_xps.php?act=struct">ڶ}liɯŸƮwഫ@~</a> 			   </td>
			 </tr>
			</table>
		   </td>
		  </tr>
	     </table>
        </td>
       </tr>
      </table>
     </td>
    </tr>
  </tr>
</table>
   
  <br><br><center><span id='copy'>&copy 2003 Koudanshi (<a href="http://bbpixel.com">koudanshi.net</a>)<br />koudanshi 䴩 zಾ\</span></center> 
 </body>
</html>
	
<?
}
?>
