<?php
// $Id: xoopspagenav.php,v 1.1 2002/08/06 01:48:00 onokazu Exp $
// ------------------------------------------------------------------------- //
//                XOOPS - PHP Content Management System                      //
//                       <http://www.xoops.org/>                             //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
// Author of File:                                                              //
// Kazumi Ono (http://www.myweb.ne.jp/, http://www.xoops.org/)               //
// ------------------------------------------------------------------------- //
class XoopsPageNav{

        var $total;
        var $perpage;
        var $current;
        var $url;

        function XoopsPageNav($total_items, $items_perpage, $current_start, $start_name="start", $extra_arg=""){
                $this->total = intval($total_items);
                $this->perpage = intval($items_perpage);
                $this->current = intval($current_start);
                if ( $extra_arg != '' && ( substr($extra_arg, -5) != '&amp;' || substr($extra_arg, -1) != '&' ) ) {
                        $extra_arg .= '&amp;';
                }
                $this->url = $GLOBALS['PHP_SELF'].'?'.$extra_arg.trim($start_name).'=';
        }

        function renderNav($offset = 4){
                if ( $this->total < $this->perpage ) {
                        return;
                }
                $total_pages = ceil($this->total / $this->perpage);
                if ( $total_pages > 1 ) {
                           $ret = '';
                        $prev = $this->current - $this->perpage;
                        if ( $prev >= 0 ) {
                                $ret .= '<a href="'.$this->url.$prev.'">&nbsp;<img src="images/gauche.gif" width="11" height="11" border="0" title="'._PREC.'"></a> ';
                        }
                        $counter = 1;
                        $current_page = intval(floor(($this->current + $this->perpage) / $this->perpage));
                        while ( $counter <= $total_pages ) {
                                if ( $counter == $current_page ) {
                                        $ret .= '<b>('.$counter.')</b> ';
                                } elseif ( ($counter > $current_page-$offset && $counter < $current_page + $offset ) || $counter == 1 || $counter == $total_pages ) {
                                        if ( $counter == $total_pages && $current_page < $total_pages - $offset ) {
                                                $ret .= '... ';
                                        }
                                        $ret .= '<a href="'.$this->url.(($counter - 1) * $this->perpage).'">'.$counter.'</a> ';
                                        if ( $counter == 1 && $current_page > 1 + $offset ) {
                                                $ret .= '... ';
                                        }
                                }
                                $counter++;
                        }
                        $next = $this->current + $this->perpage;
                        if ( $this->total > $next ) {
                                $ret .= '<a href="'.$this->url.$next.'">&nbsp;<img src="images/droite.gif" width="11" height="11" border="0" title="'._SUIV.'"></a> ';

                        }
                }
                return $ret;
        }

        function renderSelect($showbutton = false){
                if ( $this->total < $this->perpage ) {
                        return;
                }
                $total_pages = ceil($this->total / $this->perpage);
                $ret = '';
                if ( $total_pages > 1 ) {
                           $ret = '<form name="pagenavform">';
                        $ret .= '<select name="pagenavselect" onchange="location=this.options[this.options.selectedIndex].value;">';
                        $counter = 1;
                        $current_page = intval(floor(($this->current + $this->perpage) / $this->perpage));
                        while ( $counter <= $total_pages ) {
                                if ( $counter == $current_page ) {
                                        $ret .= '<option value="'.$this->url.(($counter - 1) * $this->perpage).'" selected="selected">'.$counter.'</option>';
                                } else {
                                        $ret .= '<option value="'.$this->url.(($counter - 1) * $this->perpage).'">'.$counter.'</option>';
                                }
                                $counter++;
                        }
                        $ret .= '</select>';
                        if ($showbutton) {
                                $ret .= '&nbsp;<input type="submit" value="'._GO.'" />';
                        }
                        $ret .= '</form>';
                }
                return $ret;
        }

}

?>