/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.net.URI;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.aries.jax.rs.rest.management.internal.BaseResource;
import org.apache.aries.jax.rs.rest.management.internal.map.CaseInsensitiveMap;
import org.apache.aries.jax.rs.rest.management.schema.ServiceListSchema;
import org.osgi.framework.BundleContext;
import org.osgi.framework.dto.FrameworkDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;

public class FrameworkServicesResource
extends BaseResource {
    public FrameworkServicesResource(BundleContext bundleContext) {
        super(bundleContext);
    }

    @GET
    @Produces(value={"application/org.osgi.services+json", "application/org.osgi.services+xml"})
    @Path(value="framework/services{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="GET/services", summary="Retrieves a Service List Representation from the REST management service", responses={@ApiResponse(responseCode="200", description="The request has been served successfully", content={@Content(schema=@Schema(implementation=ServiceListSchema.class))}), @ApiResponse(responseCode="400", description="The provided filter expression was not valid"), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")})
    public Response services(@Parameter(name="filter", in=ParameterIn.QUERY, description="A filter parameter whose value is a filter expression that follows the Core Specifications Framework Filter Syntax; see OSGi Core, Chapter 3.2.7 Filter Syntax. The filter is matched against the service attributes and only services that match are returned", examples={@ExampleObject(summary="format: filter=<filter_string>", value="filter=(&(osgi.vendor=Apache Aries)(objectClass=com.acme.Widget))")}) @QueryParam(value="filter") String filter, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        Predicate<ServiceReferenceDTO> predicate = FrameworkServicesResource.fromFilterQuery(filter);
        Response.ResponseBuilder builder = Response.ok((Object)((Object)ServiceListSchema.build(((FrameworkDTO)this.framework.adapt(FrameworkDTO.class)).services.stream().map(sr -> {
            sr.properties = new CaseInsensitiveMap(sr.properties);
            return sr;
        }).filter(predicate).map(sr -> String.valueOf(sr.id)).map(id -> this.uriInfo.getBaseUriBuilder().path("framework").path("service").path(id)).map(rec$ -> ((UriBuilder)rec$).build(new Object[0])).map(URI::toASCIIString).collect(Collectors.toList()))));
        return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.services+json" : "application/org.osgi.services+xml").map(type -> builder.type(type)).orElse(builder).build();
    }
}

