/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.trevni.Checksum;
import org.apache.trevni.Codec;
import org.apache.trevni.ColumnDescriptor;
import org.apache.trevni.InputBuffer;
import org.apache.trevni.InputBytes;
import org.apache.trevni.TrevniRuntimeException;
import org.apache.trevni.ValueType;

public class ColumnValues<T extends Comparable>
implements Iterator<T>,
Iterable<T> {
    private final ColumnDescriptor column;
    private final ValueType type;
    private final Codec codec;
    private final Checksum checksum;
    private final InputBuffer in;
    private InputBuffer values;
    private int block = -1;
    private long row = 0L;
    private T previous;
    private int arrayLength;

    ColumnValues(ColumnDescriptor column) throws IOException {
        this.column = column;
        this.type = column.metaData.getType();
        this.codec = Codec.get(column.metaData);
        this.checksum = Checksum.get(column.metaData);
        this.in = new InputBuffer(column.file);
        column.ensureBlocksRead();
    }

    public long getRow() {
        return this.row;
    }

    public void seek(long r) throws IOException {
        if (r < this.row || r >= this.column.lastRow(this.block)) {
            this.startBlock(this.column.findBlock(r));
        }
        while (r > this.row && this.hasNext()) {
            this.values.skipValue(this.type);
            ++this.row;
        }
        this.previous = null;
    }

    public void seek(T v) throws IOException {
        if (!this.column.metaData.hasIndexValues()) {
            throw new TrevniRuntimeException("Column does not have value index: " + this.column.metaData.getName());
        }
        if (this.previous == null || this.previous.compareTo(v) > 0 || this.block != this.column.blockCount() - 1 && this.column.firstValues[this.block + 1].compareTo(v) <= 0) {
            this.startBlock(this.column.findBlock(v));
        }
        while (this.hasNext()) {
            long savedPosition = this.values.tell();
            T savedPrevious = this.previous;
            if (this.next().compareTo(v) < 0) continue;
            this.values.seek(savedPosition);
            this.previous = savedPrevious;
            --this.row;
            return;
        }
    }

    private void startBlock(int block) throws IOException {
        this.block = block;
        this.row = this.column.firstRows[block];
        this.in.seek(this.column.blockStarts[block]);
        int end = this.column.blocks[block].compressedSize;
        byte[] raw = new byte[end + this.checksum.size()];
        this.in.readFully(raw);
        ByteBuffer data = this.codec.decompress(ByteBuffer.wrap(raw, 0, end));
        if (!this.checksum.compute(data).equals(ByteBuffer.wrap(raw, end, this.checksum.size()))) {
            throw new IOException("Checksums mismatch.");
        }
        this.values = new InputBuffer(new InputBytes(data));
    }

    @Override
    public Iterator iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.block < this.column.blockCount() - 1 || this.row < this.column.lastRow(this.block);
    }

    @Override
    public T next() {
        if (this.column.metaData.isArray() || this.column.metaData.getParent() != null) {
            throw new TrevniRuntimeException("Column is array: " + this.column.metaData.getName());
        }
        try {
            this.startRow();
            return this.nextValue();
        }
        catch (IOException e) {
            throw new TrevniRuntimeException(e);
        }
    }

    public void startRow() throws IOException {
        if (this.row >= this.column.lastRow(this.block)) {
            if (this.block >= this.column.blockCount()) {
                throw new TrevniRuntimeException("Read past end of column.");
            }
            this.startBlock(this.block + 1);
        }
        ++this.row;
    }

    public int nextLength() throws IOException {
        if (!this.column.metaData.isArray()) {
            throw new TrevniRuntimeException("Column is not array: " + this.column.metaData.getName());
        }
        assert (this.arrayLength == 0);
        this.arrayLength = this.values.readLength();
        return this.arrayLength;
    }

    public T nextValue() throws IOException {
        --this.arrayLength;
        this.previous = this.values.readValue(this.type);
        return this.previous;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

