/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.trevni.InputBuffer;
import org.apache.trevni.OutputBuffer;
import org.apache.trevni.TrevniRuntimeException;

public class MetaData<T extends MetaData>
extends LinkedHashMap<String, byte[]> {
    static final String RESERVED_KEY_PREFIX = "trevni.";
    static final String CODEC_KEY = "trevni.codec";
    static final String CHECKSUM_KEY = "trevni.checksum";
    private MetaData<?> defaults;

    void setDefaults(MetaData defaults) {
        this.defaults = defaults;
    }

    public String getCodec() {
        return this.getString(CODEC_KEY);
    }

    public T setCodec(String codec) {
        this.setReserved(CODEC_KEY, codec);
        return (T)this;
    }

    public String getChecksum() {
        return this.getString(CHECKSUM_KEY);
    }

    public T setChecksum(String checksum) {
        this.setReserved(CHECKSUM_KEY, checksum);
        return (T)this;
    }

    public String getString(String key) {
        byte[] value = (byte[])this.get(key);
        if (value == null && this.defaults != null) {
            value = (byte[])this.defaults.get(key);
        }
        if (value == null) {
            return null;
        }
        return new String(value, StandardCharsets.UTF_8);
    }

    public long getLong(String key) {
        return Long.parseLong(this.getString(key));
    }

    public boolean getBoolean(String key) {
        return this.get(key) != null;
    }

    public T set(String key, byte[] value) {
        if (MetaData.isReserved(key)) {
            throw new TrevniRuntimeException("Cannot set reserved key: " + key);
        }
        this.put(key, value);
        return (T)this;
    }

    public static boolean isReserved(String key) {
        return key.startsWith(RESERVED_KEY_PREFIX);
    }

    public T set(String key, String value) {
        return this.set(key, value.getBytes(StandardCharsets.UTF_8));
    }

    T setReserved(String key, String value) {
        this.put(key, value.getBytes(StandardCharsets.UTF_8));
        return (T)this;
    }

    T setReservedBoolean(String key, boolean value) {
        if (value) {
            this.setReserved(key, "");
        } else {
            this.remove(key);
        }
        return (T)this;
    }

    public T set(String key, long value) {
        return this.set(key, Long.toString(value));
    }

    void write(OutputBuffer out) throws IOException {
        out.writeInt(this.size());
        for (Map.Entry e : this.entrySet()) {
            out.writeString((String)e.getKey());
            out.writeBytes((byte[])e.getValue());
        }
    }

    static void read(InputBuffer in, MetaData<?> metaData) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            metaData.put(in.readString(), in.readBytes());
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{').append(' ');
        for (Map.Entry e : this.entrySet()) {
            builder.append((String)e.getKey());
            builder.append('=');
            builder.append(new String((byte[])e.getValue(), StandardCharsets.ISO_8859_1));
            builder.append(' ');
        }
        builder.append('}');
        return builder.toString();
    }
}

