/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.trevni.Input;
import org.apache.trevni.InputFile;
import org.apache.trevni.avro.HadoopInput;

class TrevniUtil {
    TrevniUtil() {
    }

    static Input input(String filename) throws IOException {
        if (filename.startsWith("hdfs://")) {
            return new HadoopInput(new Path(filename), new Configuration());
        }
        return new InputFile(new File(filename));
    }

    static InputStream input(String filename, InputStream stdin) throws IOException {
        if (filename.equals("-")) {
            return new BufferedInputStream(stdin);
        }
        if (filename.startsWith("hdfs://")) {
            FileSystem fs = FileSystem.get((URI)URI.create(filename), (Configuration)new Configuration());
            return new BufferedInputStream((InputStream)fs.open(new Path(filename)));
        }
        return new BufferedInputStream(new FileInputStream(new File(filename)));
    }

    static OutputStream output(String filename, OutputStream stdout) throws IOException {
        if (filename.equals("-")) {
            return new BufferedOutputStream(stdout);
        }
        if (filename.startsWith("hdfs://")) {
            FileSystem fs = FileSystem.get((URI)URI.create(filename), (Configuration)new Configuration());
            return new BufferedOutputStream((OutputStream)fs.create(new Path(filename)));
        }
        return new BufferedOutputStream(new FileOutputStream(new File(filename)));
    }
}

