/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Provision Eventarc and Workflow service account
resource "google_service_account" "default" {
  account_id  = var.eventarc_workflow_service_account_id
  description = "Executes and processes Eventarc and Workflows"
}

// Add IAM roles to Eventarc and Workflow service account
resource "google_project_iam_member" "default" {
  for_each = toset([
    "roles/pubsub.publisher",
    "roles/workflows.invoker",
    "roles/eventarc.eventReceiver",
  ])
  member  = "serviceAccount:${google_service_account.default.email}"
  role    = each.key
  project = var.project
}

resource "google_project_iam_member" "gcp-sa-pubsub" {
  member  = "serviceAccount:service-${data.google_project.default.number}@gcp-sa-pubsub.iam.gserviceaccount.com"
  project = var.project
  role    = "roles/iam.serviceAccountTokenCreator"
}
