/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec.tasks;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.buildspec.tasks.Builder;
import org.apache.camel.v1.buildspec.tasks.builder.Configuration;
import org.apache.camel.v1.buildspec.tasks.builder.ConfigurationBuilder;
import org.apache.camel.v1.buildspec.tasks.builder.ConfigurationFluent;
import org.apache.camel.v1.buildspec.tasks.builder.Maven;
import org.apache.camel.v1.buildspec.tasks.builder.MavenBuilder;
import org.apache.camel.v1.buildspec.tasks.builder.MavenFluent;
import org.apache.camel.v1.buildspec.tasks.builder.Runtime;
import org.apache.camel.v1.buildspec.tasks.builder.RuntimeBuilder;
import org.apache.camel.v1.buildspec.tasks.builder.RuntimeFluent;
import org.apache.camel.v1.buildspec.tasks.builder.Sources;
import org.apache.camel.v1.buildspec.tasks.builder.SourcesBuilder;
import org.apache.camel.v1.buildspec.tasks.builder.SourcesFluent;

public class BuilderFluent<A extends BuilderFluent<A>>
extends BaseFluent<A> {
    private String baseImage;
    private String buildDir;
    private ConfigurationBuilder configuration;
    private List<String> dependencies;
    private MavenBuilder maven;
    private String name;
    private RuntimeBuilder runtime;
    private ArrayList<SourcesBuilder> sources;
    private List<String> steps;

    public BuilderFluent() {
    }

    public BuilderFluent(Builder instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Builder instance) {
        Builder builder = instance = instance != null ? instance : new Builder();
        if (instance != null) {
            this.withBaseImage(instance.getBaseImage());
            this.withBuildDir(instance.getBuildDir());
            this.withConfiguration(instance.getConfiguration());
            this.withDependencies(instance.getDependencies());
            this.withMaven(instance.getMaven());
            this.withName(instance.getName());
            this.withRuntime(instance.getRuntime());
            this.withSources(instance.getSources());
            this.withSteps(instance.getSteps());
        }
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)((Object)this);
    }

    public boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public A withBuildDir(String buildDir) {
        this.buildDir = buildDir;
        return (A)((Object)this);
    }

    public boolean hasBuildDir() {
        return this.buildDir != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public A addToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.add(index, item);
        return (A)((Object)this);
    }

    public A setToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.set(index, item);
        return (A)((Object)this);
    }

    public A addToDependencies(String ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDependencies(String ... items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dependencies.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dependencies.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public String getDependency(int index) {
        return this.dependencies.get(index);
    }

    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    public String getLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1);
    }

    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDependencies(List<String> dependencies) {
        if (dependencies != null) {
            this.dependencies = new ArrayList<String>();
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)((Object)this);
    }

    public A withDependencies(String ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this._visitables.remove((Object)"dependencies");
        }
        if (dependencies != null) {
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public Maven buildMaven() {
        return this.maven != null ? this.maven.build() : null;
    }

    public A withMaven(Maven maven) {
        this._visitables.remove((Object)"maven");
        if (maven != null) {
            this.maven = new MavenBuilder(maven);
            this._visitables.get((Object)"maven").add(this.maven);
        } else {
            this.maven = null;
            this._visitables.get((Object)"maven").remove((Object)this.maven);
        }
        return (A)((Object)this);
    }

    public boolean hasMaven() {
        return this.maven != null;
    }

    public MavenNested<A> withNewMaven() {
        return new MavenNested(null);
    }

    public MavenNested<A> withNewMavenLike(Maven item) {
        return new MavenNested(item);
    }

    public MavenNested<A> editMaven() {
        return this.withNewMavenLike(Optional.ofNullable(this.buildMaven()).orElse(null));
    }

    public MavenNested<A> editOrNewMaven() {
        return this.withNewMavenLike(Optional.ofNullable(this.buildMaven()).orElse(new MavenBuilder().build()));
    }

    public MavenNested<A> editOrNewMavenLike(Maven item) {
        return this.withNewMavenLike(Optional.ofNullable(this.buildMaven()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Runtime buildRuntime() {
        return this.runtime != null ? this.runtime.build() : null;
    }

    public A withRuntime(Runtime runtime) {
        this._visitables.remove((Object)"runtime");
        if (runtime != null) {
            this.runtime = new RuntimeBuilder(runtime);
            this._visitables.get((Object)"runtime").add(this.runtime);
        } else {
            this.runtime = null;
            this._visitables.get((Object)"runtime").remove((Object)this.runtime);
        }
        return (A)((Object)this);
    }

    public boolean hasRuntime() {
        return this.runtime != null;
    }

    public RuntimeNested<A> withNewRuntime() {
        return new RuntimeNested(null);
    }

    public RuntimeNested<A> withNewRuntimeLike(Runtime item) {
        return new RuntimeNested(item);
    }

    public RuntimeNested<A> editRuntime() {
        return this.withNewRuntimeLike(Optional.ofNullable(this.buildRuntime()).orElse(null));
    }

    public RuntimeNested<A> editOrNewRuntime() {
        return this.withNewRuntimeLike(Optional.ofNullable(this.buildRuntime()).orElse(new RuntimeBuilder().build()));
    }

    public RuntimeNested<A> editOrNewRuntimeLike(Runtime item) {
        return this.withNewRuntimeLike(Optional.ofNullable(this.buildRuntime()).orElse(item));
    }

    public A addToSources(int index, Sources item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        SourcesBuilder builder = new SourcesBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get((Object)"sources").add(index, builder);
            this.sources.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSources(int index, Sources item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        SourcesBuilder builder = new SourcesBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get((Object)"sources").set(index, builder);
            this.sources.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSources(Sources ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (Sources item : items) {
            SourcesBuilder builder = new SourcesBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSources(Collection<Sources> items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (Sources item : items) {
            SourcesBuilder builder = new SourcesBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSources(Sources ... items) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        for (Sources item : items) {
            SourcesBuilder builder = new SourcesBuilder(item);
            this._visitables.get((Object)"sources").remove((Object)builder);
            this.sources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSources(Collection<Sources> items) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        for (Sources item : items) {
            SourcesBuilder builder = new SourcesBuilder(item);
            this._visitables.get((Object)"sources").remove((Object)builder);
            this.sources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSources(Predicate<SourcesBuilder> predicate) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        Iterator<SourcesBuilder> each = this.sources.iterator();
        List visitables = this._visitables.get((Object)"sources");
        while (each.hasNext()) {
            SourcesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Sources> buildSources() {
        return this.sources != null ? BuilderFluent.build(this.sources) : null;
    }

    public Sources buildSource(int index) {
        return this.sources.get(index).build();
    }

    public Sources buildFirstSource() {
        return this.sources.get(0).build();
    }

    public Sources buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    public Sources buildMatchingSource(Predicate<SourcesBuilder> predicate) {
        for (SourcesBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSource(Predicate<SourcesBuilder> predicate) {
        for (SourcesBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSources(List<Sources> sources) {
        if (this.sources != null) {
            this._visitables.get((Object)"sources").clear();
        }
        if (sources != null) {
            this.sources = new ArrayList();
            for (Sources item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)((Object)this);
    }

    public A withSources(Sources ... sources) {
        if (this.sources != null) {
            this.sources.clear();
            this._visitables.remove((Object)"sources");
        }
        if (sources != null) {
            for (Sources item : sources) {
                this.addToSources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    public SourcesNested<A> addNewSource() {
        return new SourcesNested(-1, null);
    }

    public SourcesNested<A> addNewSourceLike(Sources item) {
        return new SourcesNested(-1, item);
    }

    public SourcesNested<A> setNewSourceLike(int index, Sources item) {
        return new SourcesNested(index, item);
    }

    public SourcesNested<A> editSource(int index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    public SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editMatchingSource(Predicate<SourcesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public A addToSteps(int index, String item) {
        if (this.steps == null) {
            this.steps = new ArrayList<String>();
        }
        this.steps.add(index, item);
        return (A)((Object)this);
    }

    public A setToSteps(int index, String item) {
        if (this.steps == null) {
            this.steps = new ArrayList<String>();
        }
        this.steps.set(index, item);
        return (A)((Object)this);
    }

    public A addToSteps(String ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList<String>();
        }
        for (String item : items) {
            this.steps.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSteps(Collection<String> items) {
        if (this.steps == null) {
            this.steps = new ArrayList<String>();
        }
        for (String item : items) {
            this.steps.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSteps(String ... items) {
        if (this.steps == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.steps.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSteps(Collection<String> items) {
        if (this.steps == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.steps.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSteps() {
        return this.steps;
    }

    public String getStep(int index) {
        return this.steps.get(index);
    }

    public String getFirstStep() {
        return this.steps.get(0);
    }

    public String getLastStep() {
        return this.steps.get(this.steps.size() - 1);
    }

    public String getMatchingStep(Predicate<String> predicate) {
        for (String item : this.steps) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingStep(Predicate<String> predicate) {
        for (String item : this.steps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSteps(List<String> steps) {
        if (steps != null) {
            this.steps = new ArrayList<String>();
            for (String item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = null;
        }
        return (A)((Object)this);
    }

    public A withSteps(String ... steps) {
        if (this.steps != null) {
            this.steps.clear();
            this._visitables.remove((Object)"steps");
        }
        if (steps != null) {
            for (String item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuilderFluent that = (BuilderFluent)((Object)o);
        if (!Objects.equals(this.baseImage, that.baseImage)) {
            return false;
        }
        if (!Objects.equals(this.buildDir, that.buildDir)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.dependencies, that.dependencies)) {
            return false;
        }
        if (!Objects.equals((Object)this.maven, (Object)that.maven)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.runtime, (Object)that.runtime)) {
            return false;
        }
        if (!Objects.equals(this.sources, that.sources)) {
            return false;
        }
        return Objects.equals(this.steps, that.steps);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseImage, this.buildDir, this.configuration, this.dependencies, this.maven, this.name, this.runtime, this.sources, this.steps, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.buildDir != null) {
            sb.append("buildDir:");
            sb.append(this.buildDir + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.maven != null) {
            sb.append("maven:");
            sb.append(this.maven + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.runtime != null) {
            sb.append("runtime:");
            sb.append(this.runtime + ",");
        }
        if (this.sources != null && !this.sources.isEmpty()) {
            sb.append("sources:");
            sb.append(this.sources + ",");
        }
        if (this.steps != null && !this.steps.isEmpty()) {
            sb.append("steps:");
            sb.append(this.steps);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)BuilderFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }

    public class MavenNested<N>
    extends MavenFluent<MavenNested<N>>
    implements Nested<N> {
        MavenBuilder builder;

        MavenNested(Maven item) {
            this.builder = new MavenBuilder(this, item);
        }

        public N and() {
            return (N)BuilderFluent.this.withMaven(this.builder.build());
        }

        public N endMaven() {
            return this.and();
        }
    }

    public class RuntimeNested<N>
    extends RuntimeFluent<RuntimeNested<N>>
    implements Nested<N> {
        RuntimeBuilder builder;

        RuntimeNested(Runtime item) {
            this.builder = new RuntimeBuilder(this, item);
        }

        public N and() {
            return (N)BuilderFluent.this.withRuntime(this.builder.build());
        }

        public N endRuntime() {
            return this.and();
        }
    }

    public class SourcesNested<N>
    extends SourcesFluent<SourcesNested<N>>
    implements Nested<N> {
        SourcesBuilder builder;
        int index;

        SourcesNested(int index, Sources item) {
            this.index = index;
            this.builder = new SourcesBuilder(this, item);
        }

        public N and() {
            return (N)BuilderFluent.this.setToSources(this.index, this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }
}

