/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec.tasks.kaniko;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Objects;
import org.apache.camel.v1.buildspec.tasks.kaniko.Cache;

public class CacheFluent<A extends CacheFluent<A>>
extends BaseFluent<A> {
    private Boolean enabled;
    private String persistentVolumeClaim;

    public CacheFluent() {
    }

    public CacheFluent(Cache instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Cache instance) {
        Cache cache = instance = instance != null ? instance : new Cache();
        if (instance != null) {
            this.withEnabled(instance.getEnabled());
            this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getPersistentVolumeClaim() {
        return this.persistentVolumeClaim;
    }

    public A withPersistentVolumeClaim(String persistentVolumeClaim) {
        this.persistentVolumeClaim = persistentVolumeClaim;
        return (A)((Object)this);
    }

    public boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CacheFluent that = (CacheFluent)((Object)o);
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        return Objects.equals(this.persistentVolumeClaim, that.persistentVolumeClaim);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.persistentVolumeClaim, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.persistentVolumeClaim != null) {
            sb.append("persistentVolumeClaim:");
            sb.append(this.persistentVolumeClaim);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }
}

