/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilespec.build;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationprofilespec.build.Maven;
import org.apache.camel.v1.integrationprofilespec.build.maven.CaSecrets;
import org.apache.camel.v1.integrationprofilespec.build.maven.CaSecretsBuilder;
import org.apache.camel.v1.integrationprofilespec.build.maven.CaSecretsFluent;
import org.apache.camel.v1.integrationprofilespec.build.maven.Extension;
import org.apache.camel.v1.integrationprofilespec.build.maven.ExtensionBuilder;
import org.apache.camel.v1.integrationprofilespec.build.maven.ExtensionFluent;
import org.apache.camel.v1.integrationprofilespec.build.maven.Profiles;
import org.apache.camel.v1.integrationprofilespec.build.maven.ProfilesBuilder;
import org.apache.camel.v1.integrationprofilespec.build.maven.ProfilesFluent;
import org.apache.camel.v1.integrationprofilespec.build.maven.Settings;
import org.apache.camel.v1.integrationprofilespec.build.maven.SettingsBuilder;
import org.apache.camel.v1.integrationprofilespec.build.maven.SettingsFluent;
import org.apache.camel.v1.integrationprofilespec.build.maven.SettingsSecurity;
import org.apache.camel.v1.integrationprofilespec.build.maven.SettingsSecurityBuilder;
import org.apache.camel.v1.integrationprofilespec.build.maven.SettingsSecurityFluent;

public class MavenFluent<A extends MavenFluent<A>>
extends BaseFluent<A> {
    private ArrayList<CaSecretsBuilder> caSecrets;
    private List<String> cliOptions;
    private ArrayList<ExtensionBuilder> extension;
    private String localRepository;
    private ArrayList<ProfilesBuilder> profiles;
    private Map<String, String> properties;
    private SettingsBuilder settings;
    private SettingsSecurityBuilder settingsSecurity;

    public MavenFluent() {
    }

    public MavenFluent(Maven instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Maven instance) {
        Maven maven = instance = instance != null ? instance : new Maven();
        if (instance != null) {
            this.withCaSecrets(instance.getCaSecrets());
            this.withCliOptions(instance.getCliOptions());
            this.withExtension(instance.getExtension());
            this.withLocalRepository(instance.getLocalRepository());
            this.withProfiles(instance.getProfiles());
            this.withProperties(instance.getProperties());
            this.withSettings(instance.getSettings());
            this.withSettingsSecurity(instance.getSettingsSecurity());
        }
    }

    public A addToCaSecrets(int index, CaSecrets item) {
        if (this.caSecrets == null) {
            this.caSecrets = new ArrayList();
        }
        CaSecretsBuilder builder = new CaSecretsBuilder(item);
        if (index < 0 || index >= this.caSecrets.size()) {
            this._visitables.get((Object)"caSecrets").add(builder);
            this.caSecrets.add(builder);
        } else {
            this._visitables.get((Object)"caSecrets").add(index, builder);
            this.caSecrets.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToCaSecrets(int index, CaSecrets item) {
        if (this.caSecrets == null) {
            this.caSecrets = new ArrayList();
        }
        CaSecretsBuilder builder = new CaSecretsBuilder(item);
        if (index < 0 || index >= this.caSecrets.size()) {
            this._visitables.get((Object)"caSecrets").add(builder);
            this.caSecrets.add(builder);
        } else {
            this._visitables.get((Object)"caSecrets").set(index, builder);
            this.caSecrets.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToCaSecrets(CaSecrets ... items) {
        if (this.caSecrets == null) {
            this.caSecrets = new ArrayList();
        }
        for (CaSecrets item : items) {
            CaSecretsBuilder builder = new CaSecretsBuilder(item);
            this._visitables.get((Object)"caSecrets").add(builder);
            this.caSecrets.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToBuildCaSecrets(Collection<CaSecrets> items) {
        if (this.caSecrets == null) {
            this.caSecrets = new ArrayList();
        }
        for (CaSecrets item : items) {
            CaSecretsBuilder builder = new CaSecretsBuilder(item);
            this._visitables.get((Object)"caSecrets").add(builder);
            this.caSecrets.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromCaSecrets(CaSecrets ... items) {
        if (this.caSecrets == null) {
            return (A)((Object)this);
        }
        for (CaSecrets item : items) {
            CaSecretsBuilder builder = new CaSecretsBuilder(item);
            this._visitables.get((Object)"caSecrets").remove((Object)builder);
            this.caSecrets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBuildCaSecrets(Collection<CaSecrets> items) {
        if (this.caSecrets == null) {
            return (A)((Object)this);
        }
        for (CaSecrets item : items) {
            CaSecretsBuilder builder = new CaSecretsBuilder(item);
            this._visitables.get((Object)"caSecrets").remove((Object)builder);
            this.caSecrets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBuildCaSecrets(Predicate<CaSecretsBuilder> predicate) {
        if (this.caSecrets == null) {
            return (A)((Object)this);
        }
        Iterator<CaSecretsBuilder> each = this.caSecrets.iterator();
        List visitables = this._visitables.get((Object)"caSecrets");
        while (each.hasNext()) {
            CaSecretsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<CaSecrets> buildCaSecrets() {
        return this.caSecrets != null ? MavenFluent.build(this.caSecrets) : null;
    }

    public CaSecrets buildCaSecret(int index) {
        return this.caSecrets.get(index).build();
    }

    public CaSecrets buildFirstCaSecret() {
        return this.caSecrets.get(0).build();
    }

    public CaSecrets buildLastCaSecret() {
        return this.caSecrets.get(this.caSecrets.size() - 1).build();
    }

    public CaSecrets buildMatchingCaSecret(Predicate<CaSecretsBuilder> predicate) {
        for (CaSecretsBuilder item : this.caSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCaSecret(Predicate<CaSecretsBuilder> predicate) {
        for (CaSecretsBuilder item : this.caSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCaSecrets(List<CaSecrets> caSecrets) {
        if (this.caSecrets != null) {
            this._visitables.get((Object)"caSecrets").clear();
        }
        if (caSecrets != null) {
            this.caSecrets = new ArrayList();
            for (CaSecrets item : caSecrets) {
                this.addToCaSecrets(item);
            }
        } else {
            this.caSecrets = null;
        }
        return (A)((Object)this);
    }

    public A withCaSecrets(CaSecrets ... caSecrets) {
        if (this.caSecrets != null) {
            this.caSecrets.clear();
            this._visitables.remove((Object)"caSecrets");
        }
        if (caSecrets != null) {
            for (CaSecrets item : caSecrets) {
                this.addToCaSecrets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCaSecrets() {
        return this.caSecrets != null && !this.caSecrets.isEmpty();
    }

    public CaSecretsNested<A> addNewCaSecret() {
        return new CaSecretsNested(-1, null);
    }

    public CaSecretsNested<A> addNewCaSecretLike(CaSecrets item) {
        return new CaSecretsNested(-1, item);
    }

    public CaSecretsNested<A> setNewCaSecretLike(int index, CaSecrets item) {
        return new CaSecretsNested(index, item);
    }

    public CaSecretsNested<A> editCaSecret(int index) {
        if (this.caSecrets.size() <= index) {
            throw new RuntimeException("Can't edit caSecrets. Index exceeds size.");
        }
        return this.setNewCaSecretLike(index, this.buildCaSecret(index));
    }

    public CaSecretsNested<A> editFirstCaSecret() {
        if (this.caSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first caSecrets. The list is empty.");
        }
        return this.setNewCaSecretLike(0, this.buildCaSecret(0));
    }

    public CaSecretsNested<A> editLastCaSecret() {
        int index = this.caSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last caSecrets. The list is empty.");
        }
        return this.setNewCaSecretLike(index, this.buildCaSecret(index));
    }

    public CaSecretsNested<A> editMatchingCaSecret(Predicate<CaSecretsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.caSecrets.size(); ++i) {
            if (!predicate.test(this.caSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching caSecrets. No match found.");
        }
        return this.setNewCaSecretLike(index, this.buildCaSecret(index));
    }

    public A addToCliOptions(int index, String item) {
        if (this.cliOptions == null) {
            this.cliOptions = new ArrayList<String>();
        }
        this.cliOptions.add(index, item);
        return (A)((Object)this);
    }

    public A setToCliOptions(int index, String item) {
        if (this.cliOptions == null) {
            this.cliOptions = new ArrayList<String>();
        }
        this.cliOptions.set(index, item);
        return (A)((Object)this);
    }

    public A addToCliOptions(String ... items) {
        if (this.cliOptions == null) {
            this.cliOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.cliOptions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCliOptions(Collection<String> items) {
        if (this.cliOptions == null) {
            this.cliOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.cliOptions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCliOptions(String ... items) {
        if (this.cliOptions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.cliOptions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCliOptions(Collection<String> items) {
        if (this.cliOptions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.cliOptions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCliOptions() {
        return this.cliOptions;
    }

    public String getCliOption(int index) {
        return this.cliOptions.get(index);
    }

    public String getFirstCliOption() {
        return this.cliOptions.get(0);
    }

    public String getLastCliOption() {
        return this.cliOptions.get(this.cliOptions.size() - 1);
    }

    public String getMatchingCliOption(Predicate<String> predicate) {
        for (String item : this.cliOptions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCliOption(Predicate<String> predicate) {
        for (String item : this.cliOptions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCliOptions(List<String> cliOptions) {
        if (cliOptions != null) {
            this.cliOptions = new ArrayList<String>();
            for (String item : cliOptions) {
                this.addToCliOptions(item);
            }
        } else {
            this.cliOptions = null;
        }
        return (A)((Object)this);
    }

    public A withCliOptions(String ... cliOptions) {
        if (this.cliOptions != null) {
            this.cliOptions.clear();
            this._visitables.remove((Object)"cliOptions");
        }
        if (cliOptions != null) {
            for (String item : cliOptions) {
                this.addToCliOptions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCliOptions() {
        return this.cliOptions != null && !this.cliOptions.isEmpty();
    }

    public A addToExtension(int index, Extension item) {
        if (this.extension == null) {
            this.extension = new ArrayList();
        }
        ExtensionBuilder builder = new ExtensionBuilder(item);
        if (index < 0 || index >= this.extension.size()) {
            this._visitables.get((Object)"extension").add(builder);
            this.extension.add(builder);
        } else {
            this._visitables.get((Object)"extension").add(index, builder);
            this.extension.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExtension(int index, Extension item) {
        if (this.extension == null) {
            this.extension = new ArrayList();
        }
        ExtensionBuilder builder = new ExtensionBuilder(item);
        if (index < 0 || index >= this.extension.size()) {
            this._visitables.get((Object)"extension").add(builder);
            this.extension.add(builder);
        } else {
            this._visitables.get((Object)"extension").set(index, builder);
            this.extension.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExtension(Extension ... items) {
        if (this.extension == null) {
            this.extension = new ArrayList();
        }
        for (Extension item : items) {
            ExtensionBuilder builder = new ExtensionBuilder(item);
            this._visitables.get((Object)"extension").add(builder);
            this.extension.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToBuildExtension(Collection<Extension> items) {
        if (this.extension == null) {
            this.extension = new ArrayList();
        }
        for (Extension item : items) {
            ExtensionBuilder builder = new ExtensionBuilder(item);
            this._visitables.get((Object)"extension").add(builder);
            this.extension.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExtension(Extension ... items) {
        if (this.extension == null) {
            return (A)((Object)this);
        }
        for (Extension item : items) {
            ExtensionBuilder builder = new ExtensionBuilder(item);
            this._visitables.get((Object)"extension").remove((Object)builder);
            this.extension.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBuildExtension(Collection<Extension> items) {
        if (this.extension == null) {
            return (A)((Object)this);
        }
        for (Extension item : items) {
            ExtensionBuilder builder = new ExtensionBuilder(item);
            this._visitables.get((Object)"extension").remove((Object)builder);
            this.extension.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBuildExtension(Predicate<ExtensionBuilder> predicate) {
        if (this.extension == null) {
            return (A)((Object)this);
        }
        Iterator<ExtensionBuilder> each = this.extension.iterator();
        List visitables = this._visitables.get((Object)"extension");
        while (each.hasNext()) {
            ExtensionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Extension> buildExtension() {
        return this.extension != null ? MavenFluent.build(this.extension) : null;
    }

    public Extension buildExtension(int index) {
        return this.extension.get(index).build();
    }

    public Extension buildFirstExtension() {
        return this.extension.get(0).build();
    }

    public Extension buildLastExtension() {
        return this.extension.get(this.extension.size() - 1).build();
    }

    public Extension buildMatchingExtension(Predicate<ExtensionBuilder> predicate) {
        for (ExtensionBuilder item : this.extension) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExtension(Predicate<ExtensionBuilder> predicate) {
        for (ExtensionBuilder item : this.extension) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtension(List<Extension> extension) {
        if (this.extension != null) {
            this._visitables.get((Object)"extension").clear();
        }
        if (extension != null) {
            this.extension = new ArrayList();
            for (Extension item : extension) {
                this.addToExtension(item);
            }
        } else {
            this.extension = null;
        }
        return (A)((Object)this);
    }

    public A withExtension(Extension ... extension) {
        if (this.extension != null) {
            this.extension.clear();
            this._visitables.remove((Object)"extension");
        }
        if (extension != null) {
            for (Extension item : extension) {
                this.addToExtension(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExtension() {
        return this.extension != null && !this.extension.isEmpty();
    }

    public ExtensionNested<A> addNewExtension() {
        return new ExtensionNested(-1, null);
    }

    public ExtensionNested<A> addNewExtensionLike(Extension item) {
        return new ExtensionNested(-1, item);
    }

    public ExtensionNested<A> setNewExtensionLike(int index, Extension item) {
        return new ExtensionNested(index, item);
    }

    public ExtensionNested<A> editExtension(int index) {
        if (this.extension.size() <= index) {
            throw new RuntimeException("Can't edit extension. Index exceeds size.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public ExtensionNested<A> editFirstExtension() {
        if (this.extension.size() == 0) {
            throw new RuntimeException("Can't edit first extension. The list is empty.");
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    public ExtensionNested<A> editLastExtension() {
        int index = this.extension.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extension. The list is empty.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public ExtensionNested<A> editMatchingExtension(Predicate<ExtensionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extension.size(); ++i) {
            if (!predicate.test(this.extension.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extension. No match found.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public A withLocalRepository(String localRepository) {
        this.localRepository = localRepository;
        return (A)((Object)this);
    }

    public boolean hasLocalRepository() {
        return this.localRepository != null;
    }

    public A addToProfiles(int index, Profiles item) {
        if (this.profiles == null) {
            this.profiles = new ArrayList();
        }
        ProfilesBuilder builder = new ProfilesBuilder(item);
        if (index < 0 || index >= this.profiles.size()) {
            this._visitables.get((Object)"profiles").add(builder);
            this.profiles.add(builder);
        } else {
            this._visitables.get((Object)"profiles").add(index, builder);
            this.profiles.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToProfiles(int index, Profiles item) {
        if (this.profiles == null) {
            this.profiles = new ArrayList();
        }
        ProfilesBuilder builder = new ProfilesBuilder(item);
        if (index < 0 || index >= this.profiles.size()) {
            this._visitables.get((Object)"profiles").add(builder);
            this.profiles.add(builder);
        } else {
            this._visitables.get((Object)"profiles").set(index, builder);
            this.profiles.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToProfiles(Profiles ... items) {
        if (this.profiles == null) {
            this.profiles = new ArrayList();
        }
        for (Profiles item : items) {
            ProfilesBuilder builder = new ProfilesBuilder(item);
            this._visitables.get((Object)"profiles").add(builder);
            this.profiles.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToBuildProfiles(Collection<Profiles> items) {
        if (this.profiles == null) {
            this.profiles = new ArrayList();
        }
        for (Profiles item : items) {
            ProfilesBuilder builder = new ProfilesBuilder(item);
            this._visitables.get((Object)"profiles").add(builder);
            this.profiles.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromProfiles(Profiles ... items) {
        if (this.profiles == null) {
            return (A)((Object)this);
        }
        for (Profiles item : items) {
            ProfilesBuilder builder = new ProfilesBuilder(item);
            this._visitables.get((Object)"profiles").remove((Object)builder);
            this.profiles.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBuildProfiles(Collection<Profiles> items) {
        if (this.profiles == null) {
            return (A)((Object)this);
        }
        for (Profiles item : items) {
            ProfilesBuilder builder = new ProfilesBuilder(item);
            this._visitables.get((Object)"profiles").remove((Object)builder);
            this.profiles.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBuildProfiles(Predicate<ProfilesBuilder> predicate) {
        if (this.profiles == null) {
            return (A)((Object)this);
        }
        Iterator<ProfilesBuilder> each = this.profiles.iterator();
        List visitables = this._visitables.get((Object)"profiles");
        while (each.hasNext()) {
            ProfilesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Profiles> buildProfiles() {
        return this.profiles != null ? MavenFluent.build(this.profiles) : null;
    }

    public Profiles buildProfile(int index) {
        return this.profiles.get(index).build();
    }

    public Profiles buildFirstProfile() {
        return this.profiles.get(0).build();
    }

    public Profiles buildLastProfile() {
        return this.profiles.get(this.profiles.size() - 1).build();
    }

    public Profiles buildMatchingProfile(Predicate<ProfilesBuilder> predicate) {
        for (ProfilesBuilder item : this.profiles) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingProfile(Predicate<ProfilesBuilder> predicate) {
        for (ProfilesBuilder item : this.profiles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProfiles(List<Profiles> profiles) {
        if (this.profiles != null) {
            this._visitables.get((Object)"profiles").clear();
        }
        if (profiles != null) {
            this.profiles = new ArrayList();
            for (Profiles item : profiles) {
                this.addToProfiles(item);
            }
        } else {
            this.profiles = null;
        }
        return (A)((Object)this);
    }

    public A withProfiles(Profiles ... profiles) {
        if (this.profiles != null) {
            this.profiles.clear();
            this._visitables.remove((Object)"profiles");
        }
        if (profiles != null) {
            for (Profiles item : profiles) {
                this.addToProfiles(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasProfiles() {
        return this.profiles != null && !this.profiles.isEmpty();
    }

    public ProfilesNested<A> addNewProfile() {
        return new ProfilesNested(-1, null);
    }

    public ProfilesNested<A> addNewProfileLike(Profiles item) {
        return new ProfilesNested(-1, item);
    }

    public ProfilesNested<A> setNewProfileLike(int index, Profiles item) {
        return new ProfilesNested(index, item);
    }

    public ProfilesNested<A> editProfile(int index) {
        if (this.profiles.size() <= index) {
            throw new RuntimeException("Can't edit profiles. Index exceeds size.");
        }
        return this.setNewProfileLike(index, this.buildProfile(index));
    }

    public ProfilesNested<A> editFirstProfile() {
        if (this.profiles.size() == 0) {
            throw new RuntimeException("Can't edit first profiles. The list is empty.");
        }
        return this.setNewProfileLike(0, this.buildProfile(0));
    }

    public ProfilesNested<A> editLastProfile() {
        int index = this.profiles.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last profiles. The list is empty.");
        }
        return this.setNewProfileLike(index, this.buildProfile(index));
    }

    public ProfilesNested<A> editMatchingProfile(Predicate<ProfilesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.profiles.size(); ++i) {
            if (!predicate.test(this.profiles.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching profiles. No match found.");
        }
        return this.setNewProfileLike(index, this.buildProfile(index));
    }

    public A addToProperties(String key, String value) {
        if (this.properties == null && key != null && value != null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.properties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToProperties(Map<String, String> map) {
        if (this.properties == null && map != null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.properties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromProperties(String key) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.properties != null) {
            this.properties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromProperties(Map<String, String> map) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.properties == null) continue;
                this.properties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public <K, V> A withProperties(Map<String, String> properties) {
        this.properties = properties == null ? null : new LinkedHashMap<String, String>(properties);
        return (A)((Object)this);
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    public Settings buildSettings() {
        return this.settings != null ? this.settings.build() : null;
    }

    public A withSettings(Settings settings) {
        this._visitables.remove((Object)"settings");
        if (settings != null) {
            this.settings = new SettingsBuilder(settings);
            this._visitables.get((Object)"settings").add(this.settings);
        } else {
            this.settings = null;
            this._visitables.get((Object)"settings").remove((Object)this.settings);
        }
        return (A)((Object)this);
    }

    public boolean hasSettings() {
        return this.settings != null;
    }

    public SettingsNested<A> withNewSettings() {
        return new SettingsNested(null);
    }

    public SettingsNested<A> withNewSettingsLike(Settings item) {
        return new SettingsNested(item);
    }

    public SettingsNested<A> editBuildSettings() {
        return this.withNewSettingsLike(Optional.ofNullable(this.buildSettings()).orElse(null));
    }

    public SettingsNested<A> editOrNewSettings() {
        return this.withNewSettingsLike(Optional.ofNullable(this.buildSettings()).orElse(new SettingsBuilder().build()));
    }

    public SettingsNested<A> editOrNewSettingsLike(Settings item) {
        return this.withNewSettingsLike(Optional.ofNullable(this.buildSettings()).orElse(item));
    }

    public SettingsSecurity buildSettingsSecurity() {
        return this.settingsSecurity != null ? this.settingsSecurity.build() : null;
    }

    public A withSettingsSecurity(SettingsSecurity settingsSecurity) {
        this._visitables.remove((Object)"settingsSecurity");
        if (settingsSecurity != null) {
            this.settingsSecurity = new SettingsSecurityBuilder(settingsSecurity);
            this._visitables.get((Object)"settingsSecurity").add(this.settingsSecurity);
        } else {
            this.settingsSecurity = null;
            this._visitables.get((Object)"settingsSecurity").remove((Object)this.settingsSecurity);
        }
        return (A)((Object)this);
    }

    public boolean hasSettingsSecurity() {
        return this.settingsSecurity != null;
    }

    public SettingsSecurityNested<A> withNewSettingsSecurity() {
        return new SettingsSecurityNested(null);
    }

    public SettingsSecurityNested<A> withNewSettingsSecurityLike(SettingsSecurity item) {
        return new SettingsSecurityNested(item);
    }

    public SettingsSecurityNested<A> editBuildSettingsSecurity() {
        return this.withNewSettingsSecurityLike(Optional.ofNullable(this.buildSettingsSecurity()).orElse(null));
    }

    public SettingsSecurityNested<A> editOrNewSettingsSecurity() {
        return this.withNewSettingsSecurityLike(Optional.ofNullable(this.buildSettingsSecurity()).orElse(new SettingsSecurityBuilder().build()));
    }

    public SettingsSecurityNested<A> editOrNewSettingsSecurityLike(SettingsSecurity item) {
        return this.withNewSettingsSecurityLike(Optional.ofNullable(this.buildSettingsSecurity()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MavenFluent that = (MavenFluent)((Object)o);
        if (!Objects.equals(this.caSecrets, that.caSecrets)) {
            return false;
        }
        if (!Objects.equals(this.cliOptions, that.cliOptions)) {
            return false;
        }
        if (!Objects.equals(this.extension, that.extension)) {
            return false;
        }
        if (!Objects.equals(this.localRepository, that.localRepository)) {
            return false;
        }
        if (!Objects.equals(this.profiles, that.profiles)) {
            return false;
        }
        if (!Objects.equals(this.properties, that.properties)) {
            return false;
        }
        if (!Objects.equals((Object)this.settings, (Object)that.settings)) {
            return false;
        }
        return Objects.equals((Object)this.settingsSecurity, (Object)that.settingsSecurity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.caSecrets, this.cliOptions, this.extension, this.localRepository, this.profiles, this.properties, this.settings, this.settingsSecurity, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caSecrets != null && !this.caSecrets.isEmpty()) {
            sb.append("caSecrets:");
            sb.append(this.caSecrets + ",");
        }
        if (this.cliOptions != null && !this.cliOptions.isEmpty()) {
            sb.append("cliOptions:");
            sb.append(this.cliOptions + ",");
        }
        if (this.extension != null && !this.extension.isEmpty()) {
            sb.append("extension:");
            sb.append(this.extension + ",");
        }
        if (this.localRepository != null) {
            sb.append("localRepository:");
            sb.append(this.localRepository + ",");
        }
        if (this.profiles != null && !this.profiles.isEmpty()) {
            sb.append("profiles:");
            sb.append(this.profiles + ",");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("properties:");
            sb.append(this.properties + ",");
        }
        if (this.settings != null) {
            sb.append("settings:");
            sb.append(this.settings + ",");
        }
        if (this.settingsSecurity != null) {
            sb.append("settingsSecurity:");
            sb.append((Object)this.settingsSecurity);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CaSecretsNested<N>
    extends CaSecretsFluent<CaSecretsNested<N>>
    implements Nested<N> {
        CaSecretsBuilder builder;
        int index;

        CaSecretsNested(int index, CaSecrets item) {
            this.index = index;
            this.builder = new CaSecretsBuilder(this, item);
        }

        public N and() {
            return (N)MavenFluent.this.setToCaSecrets(this.index, this.builder.build());
        }

        public N endBuildCaSecret() {
            return this.and();
        }
    }

    public class ExtensionNested<N>
    extends ExtensionFluent<ExtensionNested<N>>
    implements Nested<N> {
        ExtensionBuilder builder;
        int index;

        ExtensionNested(int index, Extension item) {
            this.index = index;
            this.builder = new ExtensionBuilder(this, item);
        }

        public N and() {
            return (N)MavenFluent.this.setToExtension(this.index, this.builder.build());
        }

        public N endBuildExtension() {
            return this.and();
        }
    }

    public class ProfilesNested<N>
    extends ProfilesFluent<ProfilesNested<N>>
    implements Nested<N> {
        ProfilesBuilder builder;
        int index;

        ProfilesNested(int index, Profiles item) {
            this.index = index;
            this.builder = new ProfilesBuilder(this, item);
        }

        public N and() {
            return (N)MavenFluent.this.setToProfiles(this.index, this.builder.build());
        }

        public N endBuildProfile() {
            return this.and();
        }
    }

    public class SettingsNested<N>
    extends SettingsFluent<SettingsNested<N>>
    implements Nested<N> {
        SettingsBuilder builder;

        SettingsNested(Settings item) {
            this.builder = new SettingsBuilder(this, item);
        }

        public N and() {
            return (N)MavenFluent.this.withSettings(this.builder.build());
        }

        public N endBuildSettings() {
            return this.and();
        }
    }

    public class SettingsSecurityNested<N>
    extends SettingsSecurityFluent<SettingsSecurityNested<N>>
    implements Nested<N> {
        SettingsSecurityBuilder builder;

        SettingsSecurityNested(SettingsSecurity item) {
            this.builder = new SettingsSecurityBuilder(this, item);
        }

        public N and() {
            return (N)MavenFluent.this.withSettingsSecurity(this.builder.build());
        }

        public N endBuildSettingsSecurity() {
            return this.and();
        }
    }
}

