/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec.volumes.ephemeral.volumeclaimtemplate;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.integrationspec.template.spec.volumes.ephemeral.volumeclaimtemplate.SpecBuilder;
import org.apache.camel.v1.integrationspec.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.DataSource;
import org.apache.camel.v1.integrationspec.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.DataSourceRef;
import org.apache.camel.v1.integrationspec.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.Resources;
import org.apache.camel.v1.integrationspec.template.spec.volumes.ephemeral.volumeclaimtemplate.spec.Selector;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"accessModes", "dataSource", "dataSourceRef", "resources", "selector", "storageClassName", "volumeAttributesClassName", "volumeMode", "volumeName"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Spec
implements Editable<SpecBuilder>,
KubernetesResource {
    @JsonProperty(value="accessModes")
    @JsonPropertyDescription(value="accessModes contains the desired access modes the volume should have.\nMore info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> accessModes;
    @JsonProperty(value="dataSource")
    @JsonPropertyDescription(value="dataSource field can be used to specify either:\n* An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot)\n* An existing PVC (PersistentVolumeClaim)\nIf the provisioner or an external controller can support the specified data source,\nit will create a new volume based on the contents of the specified data source.\nWhen the AnyVolumeDataSource feature gate is enabled, dataSource contents will be copied to dataSourceRef,\nand dataSourceRef contents will be copied to dataSource when dataSourceRef.namespace is not specified.\nIf the namespace is specified, then dataSourceRef will not be copied to dataSource.")
    @JsonSetter(nulls=Nulls.SKIP)
    private DataSource dataSource;
    @JsonProperty(value="dataSourceRef")
    @JsonPropertyDescription(value="dataSourceRef specifies the object from which to populate the volume with data, if a non-empty\nvolume is desired. This may be any object from a non-empty API group (non\ncore object) or a PersistentVolumeClaim object.\nWhen this field is specified, volume binding will only succeed if the type of\nthe specified object matches some installed volume populator or dynamic\nprovisioner.\nThis field will replace the functionality of the dataSource field and as such\nif both fields are non-empty, they must have the same value. For backwards\ncompatibility, when namespace isn't specified in dataSourceRef,\nboth fields (dataSource and dataSourceRef) will be set to the same\nvalue automatically if one of them is empty and the other is non-empty.\nWhen namespace is specified in dataSourceRef,\ndataSource isn't set to the same value and must be empty.\nThere are three important differences between dataSource and dataSourceRef:\n* While dataSource only allows two specific types of objects, dataSourceRef\n  allows any non-core object, as well as PersistentVolumeClaim objects.\n* While dataSource ignores disallowed values (dropping them), dataSourceRef\n  preserves all values, and generates an error if a disallowed value is\n  specified.\n* While dataSource only allows local objects, dataSourceRef allows objects\n  in any namespaces.\n(Beta) Using this field requires the AnyVolumeDataSource feature gate to be enabled.\n(Alpha) Using the namespace field of dataSourceRef requires the CrossNamespaceVolumeDataSource feature gate to be enabled.")
    @JsonSetter(nulls=Nulls.SKIP)
    private DataSourceRef dataSourceRef;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="resources represents the minimum resources the volume should have.\nIf RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements\nthat are lower than previous value but must still be higher than capacity recorded in the\nstatus field of the claim.\nMore info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources")
    @JsonSetter(nulls=Nulls.SKIP)
    private Resources resources;
    @JsonProperty(value="selector")
    @JsonPropertyDescription(value="selector is a label query over volumes to consider for binding.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Selector selector;
    @JsonProperty(value="storageClassName")
    @JsonPropertyDescription(value="storageClassName is the name of the StorageClass required by the claim.\nMore info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1")
    @JsonSetter(nulls=Nulls.SKIP)
    private String storageClassName;
    @JsonProperty(value="volumeAttributesClassName")
    @JsonPropertyDescription(value="volumeAttributesClassName may be used to set the VolumeAttributesClass used by this claim.\nIf specified, the CSI driver will create or update the volume with the attributes defined\nin the corresponding VolumeAttributesClass. This has a different purpose than storageClassName,\nit can be changed after the claim is created. An empty string value means that no VolumeAttributesClass\nwill be applied to the claim but it's not allowed to reset this field to empty string once it is set.\nIf unspecified and the PersistentVolumeClaim is unbound, the default VolumeAttributesClass\nwill be set by the persistentvolume controller if it exists.\nIf the resource referred to by volumeAttributesClass does not exist, this PersistentVolumeClaim will be\nset to a Pending state, as reflected by the modifyVolumeStatus field, until such as a resource\nexists.\nMore info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#volumeattributesclass\n(Alpha) Using this field requires the VolumeAttributesClass feature gate to be enabled.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String volumeAttributesClassName;
    @JsonProperty(value="volumeMode")
    @JsonPropertyDescription(value="volumeMode defines what type of volume is required by the claim.\nValue of Filesystem is implied when not included in claim spec.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String volumeMode;
    @JsonProperty(value="volumeName")
    @JsonPropertyDescription(value="volumeName is the binding reference to the PersistentVolume backing this claim.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String volumeName;

    public SpecBuilder edit() {
        return new SpecBuilder(this);
    }

    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSourceRef getDataSourceRef() {
        return this.dataSourceRef;
    }

    public void setDataSourceRef(DataSourceRef dataSourceRef) {
        this.dataSourceRef = dataSourceRef;
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public String getStorageClassName() {
        return this.storageClassName;
    }

    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public String getVolumeAttributesClassName() {
        return this.volumeAttributesClassName;
    }

    public void setVolumeAttributesClassName(String volumeAttributesClassName) {
        this.volumeAttributesClassName = volumeAttributesClassName;
    }

    public String getVolumeMode() {
        return this.volumeMode;
    }

    public void setVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public String toString() {
        return "Spec(accessModes=" + this.getAccessModes() + ", dataSource=" + this.getDataSource() + ", dataSourceRef=" + this.getDataSourceRef() + ", resources=" + this.getResources() + ", selector=" + this.getSelector() + ", storageClassName=" + this.getStorageClassName() + ", volumeAttributesClassName=" + this.getVolumeAttributesClassName() + ", volumeMode=" + this.getVolumeMode() + ", volumeName=" + this.getVolumeName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Spec)) {
            return false;
        }
        Spec other = (Spec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$accessModes = this.getAccessModes();
        List<String> other$accessModes = other.getAccessModes();
        if (this$accessModes == null ? other$accessModes != null : !((Object)this$accessModes).equals(other$accessModes)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !((Object)this$dataSource).equals(other$dataSource)) {
            return false;
        }
        DataSourceRef this$dataSourceRef = this.getDataSourceRef();
        DataSourceRef other$dataSourceRef = other.getDataSourceRef();
        if (this$dataSourceRef == null ? other$dataSourceRef != null : !((Object)this$dataSourceRef).equals(other$dataSourceRef)) {
            return false;
        }
        Resources this$resources = this.getResources();
        Resources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Selector this$selector = this.getSelector();
        Selector other$selector = other.getSelector();
        if (this$selector == null ? other$selector != null : !((Object)this$selector).equals(other$selector)) {
            return false;
        }
        String this$storageClassName = this.getStorageClassName();
        String other$storageClassName = other.getStorageClassName();
        if (this$storageClassName == null ? other$storageClassName != null : !this$storageClassName.equals(other$storageClassName)) {
            return false;
        }
        String this$volumeAttributesClassName = this.getVolumeAttributesClassName();
        String other$volumeAttributesClassName = other.getVolumeAttributesClassName();
        if (this$volumeAttributesClassName == null ? other$volumeAttributesClassName != null : !this$volumeAttributesClassName.equals(other$volumeAttributesClassName)) {
            return false;
        }
        String this$volumeMode = this.getVolumeMode();
        String other$volumeMode = other.getVolumeMode();
        if (this$volumeMode == null ? other$volumeMode != null : !this$volumeMode.equals(other$volumeMode)) {
            return false;
        }
        String this$volumeName = this.getVolumeName();
        String other$volumeName = other.getVolumeName();
        return !(this$volumeName == null ? other$volumeName != null : !this$volumeName.equals(other$volumeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Spec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $accessModes = this.getAccessModes();
        result = result * 59 + ($accessModes == null ? 43 : ((Object)$accessModes).hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : ((Object)$dataSource).hashCode());
        DataSourceRef $dataSourceRef = this.getDataSourceRef();
        result = result * 59 + ($dataSourceRef == null ? 43 : ((Object)$dataSourceRef).hashCode());
        Resources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Selector $selector = this.getSelector();
        result = result * 59 + ($selector == null ? 43 : ((Object)$selector).hashCode());
        String $storageClassName = this.getStorageClassName();
        result = result * 59 + ($storageClassName == null ? 43 : $storageClassName.hashCode());
        String $volumeAttributesClassName = this.getVolumeAttributesClassName();
        result = result * 59 + ($volumeAttributesClassName == null ? 43 : $volumeAttributesClassName.hashCode());
        String $volumeMode = this.getVolumeMode();
        result = result * 59 + ($volumeMode == null ? 43 : $volumeMode.hashCode());
        String $volumeName = this.getVolumeName();
        result = result * 59 + ($volumeName == null ? 43 : $volumeName.hashCode());
        return result;
    }
}

