/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.LoadDbSchemaAction;
import org.apache.cayenne.modeler.action.ReverseEngineeringAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.dialog.db.load.TransferableNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportModel;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;
import org.apache.cayenne.modeler.editor.dbimport.DraggableTreePanel;
import org.apache.cayenne.modeler.editor.dbimport.ReverseEngineeringConfigPanel;
import org.apache.cayenne.modeler.editor.dbimport.ReverseEngineeringTreePanel;
import org.apache.cayenne.modeler.editor.dbimport.TreeToolbarPanel;
import org.apache.cayenne.modeler.editor.dbimport.tree.ColorTreeRenderer;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.ModelerUtil;

public class DbImportView
extends JPanel {
    private static final String MAIN_LAYOUT = "fill:160dlu:grow, 5dlu, fill:50dlu, 5dlu, fill:160dlu:grow";
    private static final String HEADER_LAYOUT = "fill:80dlu:grow";
    private static final String BUTTON_PANEL_LAYOUT = "fill:50dlu";
    private static final String PROGRESS_PANEL_LAYOUT = "fill:160dlu:grow, 60dlu, fill:160dlu:grow";
    private static final int ALL_LINE_SPAN = 5;
    private static final ImageIcon rightArrow = ModelerUtil.buildIcon("icon-arrow-closed.png");
    private static final ImageIcon downArrow = ModelerUtil.buildIcon("icon-arrow-open.png");
    private TreeToolbarPanel treeToolbar;
    private ReverseEngineeringTreePanel treePanel;
    private ReverseEngineeringConfigPanel configPanel;
    private DraggableTreePanel draggableTreePanel;
    private JProgressBar loadDbSchemaProgress;
    private JProgressBar reverseEngineeringProgress;
    private CayenneAction.CayenneToolbarButton loadDbSchemaButton;
    private ProjectController projectController;
    private boolean initFromModel;

    public DbImportView(ProjectController projectController) {
        this.projectController = projectController;
        this.initFromModel = false;
        this.initFormElements();
        this.buildForm();
        this.draggableTreePanel.getSourceTree().repaint();
    }

    private void buildForm() {
        FormLayout buttonPanelLayout = new FormLayout(BUTTON_PANEL_LAYOUT);
        DefaultFormBuilder buttonBuilder = new DefaultFormBuilder(buttonPanelLayout);
        buttonBuilder.append(this.draggableTreePanel.getMoveButton());
        buttonBuilder.append(this.draggableTreePanel.getMoveInvertButton());
        FormLayout layout = new FormLayout(MAIN_LAYOUT);
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.treeToolbar, 5);
        FormLayout headerLayout = new FormLayout(HEADER_LAYOUT);
        DefaultFormBuilder reverseEngineeringHeaderBuilder = new DefaultFormBuilder(headerLayout);
        JLabel importLabel = new JLabel("Database Import Configuration");
        importLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        reverseEngineeringHeaderBuilder.append(importLabel);
        builder.append(reverseEngineeringHeaderBuilder.getPanel());
        DefaultFormBuilder databaseHeaderBuilder = new DefaultFormBuilder(headerLayout);
        JLabel schemaLabel = new JLabel("Database Schema");
        schemaLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        databaseHeaderBuilder.append(schemaLabel);
        LoadDbSchemaAction loadDbSchemaAction = this.projectController.getApplication().getActionManager().getAction(LoadDbSchemaAction.class);
        loadDbSchemaAction.setDraggableTreePanel(this.draggableTreePanel);
        this.loadDbSchemaButton = (CayenneAction.CayenneToolbarButton)loadDbSchemaAction.buildButton(0);
        this.loadDbSchemaButton.setShowingText(false);
        this.loadDbSchemaButton.setText("Refresh DB Schema");
        this.treeToolbar.add(this.loadDbSchemaButton);
        ReverseEngineeringAction reverseEngineeringAction = this.projectController.getApplication().getActionManager().getAction(ReverseEngineeringAction.class);
        reverseEngineeringAction.setView(this);
        CayenneAction.CayenneToolbarButton reverseEngineeringButton = (CayenneAction.CayenneToolbarButton)reverseEngineeringAction.buildButton(0);
        reverseEngineeringButton.setShowingText(true);
        reverseEngineeringButton.setText("Run Import");
        JPanel reverseEngineeringButtonPanel = new JPanel();
        reverseEngineeringButtonPanel.setLayout(new FlowLayout(2));
        reverseEngineeringButtonPanel.add(reverseEngineeringButton);
        this.treeToolbar.addSeparator();
        this.treeToolbar.add(reverseEngineeringButtonPanel);
        builder.append("");
        builder.append(databaseHeaderBuilder.getPanel());
        builder.append(this.treePanel);
        builder.append(buttonBuilder.getPanel());
        builder.append(this.draggableTreePanel);
        this.loadDbSchemaProgress = new JProgressBar();
        this.reverseEngineeringProgress = new JProgressBar();
        this.loadDbSchemaProgress.setIndeterminate(true);
        this.loadDbSchemaProgress.setVisible(false);
        this.reverseEngineeringProgress.setIndeterminate(true);
        this.reverseEngineeringProgress.setVisible(false);
        FormLayout progressLayout = new FormLayout(PROGRESS_PANEL_LAYOUT, "fill:10dlu");
        DefaultFormBuilder progressBarBuilder = new DefaultFormBuilder(progressLayout);
        progressBarBuilder.append(this.reverseEngineeringProgress);
        progressBarBuilder.append(this.loadDbSchemaProgress);
        builder.append((Component)progressBarBuilder.getPanel(), 5);
        this.createAdvancedOptionsHiderPanel(builder);
        builder.append((Component)this.configPanel, 5);
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    private void createAdvancedOptionsHiderPanel(DefaultFormBuilder builder) {
        JPanel advancedOptionsPanel = new JPanel();
        advancedOptionsPanel.setLayout(new FlowLayout(0));
        final JButton hideButton = new JButton("Advanced Options");
        hideButton.setIcon(this.configPanel.isVisible() ? downArrow : rightArrow);
        hideButton.setBorderPainted(false);
        hideButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbImportView.this.configPanel.setVisible(!DbImportView.this.configPanel.isVisible());
                hideButton.setIcon(DbImportView.this.configPanel.isVisible() ? downArrow : rightArrow);
            }
        });
        advancedOptionsPanel.add(hideButton);
        builder.append((Component)advancedOptionsPanel, 5);
    }

    private void initFormElements() {
        DbImportTreeNode root = new DbImportTreeNode(new ReverseEngineering());
        DbImportTreeNode draggableTreeRoot = new DbImportTreeNode(new ReverseEngineering());
        DbImportTree reverseEngineeringTree = new DbImportTree(root);
        DbImportTree draggableTree = new DbImportTree(new TransferableNode(draggableTreeRoot));
        DbImportModel model = new DbImportModel(root);
        model.setCanBeCleaned(true);
        DbImportModel draggableTreeModel = new DbImportModel(draggableTreeRoot);
        draggableTreeModel.setCanBeCleaned(false);
        draggableTree.setRootVisible(false);
        draggableTree.setShowsRootHandles(true);
        draggableTree.setModel(draggableTreeModel);
        reverseEngineeringTree.setRootVisible(false);
        reverseEngineeringTree.setModel(model);
        reverseEngineeringTree.setShowsRootHandles(true);
        this.draggableTreePanel = new DraggableTreePanel(this.projectController, draggableTree, reverseEngineeringTree);
        this.treeToolbar = new TreeToolbarPanel(this.projectController, reverseEngineeringTree, this.draggableTreePanel);
        this.treePanel = new ReverseEngineeringTreePanel(this.projectController, reverseEngineeringTree, draggableTree);
        this.treePanel.setTreeToolbar(this.treeToolbar);
        model.setDbSchemaTree(draggableTree);
        draggableTreeModel.setDbSchemaTree(draggableTree);
        ((ColorTreeRenderer)this.draggableTreePanel.getSourceTree().getCellRenderer()).setReverseEngineeringTree(reverseEngineeringTree);
        this.configPanel = new ReverseEngineeringConfigPanel(this.projectController, this);
        this.configPanel.setLayout(new FlowLayout(0));
        this.configPanel.setVisible(false);
    }

    public void initFromModel() {
        DataMap map = this.projectController.getCurrentDataMap();
        this.treePanel.getReverseEngineeringTree().stopEditing();
        if (map != null) {
            this.initFromModel = true;
            this.treeToolbar.unlockButtons();
            ReverseEngineering reverseEngineering = this.projectController.getApplication().getMetaData().get(map, ReverseEngineering.class);
            if (reverseEngineering == null) {
                reverseEngineering = new ReverseEngineering();
                this.projectController.getApplication().getMetaData().add(map, reverseEngineering);
            }
            this.configPanel.fillCheckboxes(reverseEngineering);
            this.configPanel.initializeTextFields(reverseEngineering);
            this.configPanel.initStrategy(reverseEngineering);
            CharSequence[] tableTypes = reverseEngineering.getTableTypes();
            if (tableTypes.length != 0) {
                this.configPanel.getTableTypes().setText(String.join((CharSequence)",", tableTypes));
            } else {
                this.configPanel.getTableTypes().setText("TABLE, VIEW");
                this.configPanel.getTableTypes().updateModel();
            }
            this.treePanel.updateTree();
            DbImportTreeNode root = this.draggableTreePanel.getSourceTree().getRootNode();
            root.removeAllChildren();
            this.draggableTreePanel.updateTree(this.projectController.getCurrentDataMap());
            this.draggableTreePanel.getMoveButton().setEnabled(false);
            this.draggableTreePanel.getMoveInvertButton().setEnabled(false);
        }
        this.initFromModel = false;
    }

    public boolean isSkipRelationshipsLoading() {
        return this.configPanel.getSkipRelationshipsLoading().isSelected();
    }

    public boolean isSkipPrimaryKeyLoading() {
        return this.configPanel.getSkipPrimaryKeyLoading().isSelected();
    }

    public boolean isForceDataMapCatalog() {
        return this.configPanel.getForceDataMapCatalog().isSelected();
    }

    public boolean isForceDataMapSchema() {
        return this.configPanel.getForceDataMapSchema().isSelected();
    }

    public boolean isUsePrimitives() {
        return this.configPanel.getUsePrimitives().isSelected();
    }

    public boolean isUseJava7Typed() {
        return this.configPanel.getUseJava7Types().isSelected();
    }

    public String getMeaningfulPk() {
        return "".equals(this.configPanel.getMeaningfulPk().getComponent().getText()) ? null : this.configPanel.getMeaningfulPk().getComponent().getText();
    }

    public String getNamingStrategy() {
        return (String)this.configPanel.getStrategyCombo().getSelectedItem();
    }

    public String getStripFromTableNames() {
        return this.configPanel.getStripFromTableNames().getComponent().getText();
    }

    public JProgressBar getLoadDbSchemaProgress() {
        return this.loadDbSchemaProgress;
    }

    public void lockToolbarButtons() {
        this.treeToolbar.changeToolbarButtonsState(false);
    }

    public void unlockToolbarButtons() {
        this.treeToolbar.unlockButtons();
    }

    public JProgressBar getReverseEngineeringProgress() {
        return this.reverseEngineeringProgress;
    }

    public JButton getLoadDbSchemaButton() {
        return this.loadDbSchemaButton;
    }

    public boolean isInitFromModel() {
        return this.initFromModel;
    }

    public String[] getTableTypes() {
        return this.configPanel.getReverseEngineeringBySelectedMap().getTableTypes();
    }
}

