/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale.converters;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.locale.converters.DecimalLocaleConverter;

public class BigDecimalLocaleConverter
extends DecimalLocaleConverter<BigDecimal> {
    public static Builder builder() {
        return new Builder();
    }

    private BigDecimalLocaleConverter(BigDecimal defaultValue, Locale locale, String pattern, boolean useDefault, boolean locPattern) {
        super(defaultValue, locale, pattern, useDefault, locPattern);
    }

    @Override
    protected BigDecimal parse(Object value, String pattern) throws ParseException {
        Object result = super.parse(value, pattern);
        if (result == null || result instanceof BigDecimal) {
            return (BigDecimal)result;
        }
        try {
            return new BigDecimal(result.toString());
        }
        catch (NumberFormatException ex) {
            throw new ConversionException("Supplied number is not of type BigDecimal: " + result);
        }
    }

    public static class Builder
    extends DecimalLocaleConverter.Builder<Builder, BigDecimal> {
        @Override
        public BigDecimalLocaleConverter get() {
            return new BigDecimalLocaleConverter((BigDecimal)this.defaultValue, this.locale, this.pattern, this.useDefault || this.defaultValue != null, this.localizedPattern);
        }
    }
}

