/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale.converters;

import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.locale.converters.DecimalLocaleConverter;

public class ShortLocaleConverter
extends DecimalLocaleConverter<Short> {
    public static Builder builder() {
        return new Builder();
    }

    private ShortLocaleConverter(Short defaultValue, Locale locale, String pattern, boolean useDefault, boolean locPattern) {
        super(defaultValue, locale, pattern, useDefault, locPattern);
    }

    @Override
    protected Short parse(Object value, String pattern) throws ParseException {
        Object result = super.parse(value, pattern);
        if (result == null || result instanceof Short) {
            return (Short)result;
        }
        Number parsed = (Number)result;
        if (parsed.longValue() != (long)parsed.shortValue()) {
            throw new ConversionException("Supplied number is not of type Short: " + parsed.longValue());
        }
        return parsed.shortValue();
    }

    public static class Builder
    extends DecimalLocaleConverter.Builder<Builder, Short> {
        @Override
        public ShortLocaleConverter get() {
            return new ShortLocaleConverter((Short)this.defaultValue, this.locale, this.pattern, this.useDefault || this.defaultValue != null, this.localizedPattern);
        }
    }
}

