/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import org.apache.commons.beanutils2.BeanPropertyValueChangeConsumer;
import org.apache.commons.beanutils2.TestBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanPropertyValueChangeConsumerTest {
    private static final Integer expectedIntegerValue = 123;
    private static final Float expectedFloatValue = Float.valueOf(123.123f);
    private static final Double expectedDoubleValue = 567879.12344;
    private static final Boolean expectedBooleanValue = Boolean.TRUE;
    private static final Byte expectedByteValue = Byte.valueOf("12");

    @Test
    public void testExecuteWithIndexedProperty() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("intIndexed[0]", (Object)expectedIntegerValue).accept((Object)testBean);
        Assertions.assertSame((Object)expectedIntegerValue, (Object)testBean.getIntIndexed(0));
    }

    @Test
    public void testExecuteWithInvalidPropertyName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanPropertyValueChangeConsumer("bogusProperty", (Object)"foo").accept((Object)new TestBean()));
    }

    @Test
    public void testExecuteWithMappedProperty() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("mappedProperty(fred)", (Object)"barney").accept((Object)testBean);
        Assertions.assertEquals((Object)"barney", (Object)testBean.getMappedProperty("fred"));
    }

    @Test
    public void testExecuteWithNestedProperty() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("nested.stringProperty", (Object)"bar").accept((Object)testBean);
        Assertions.assertEquals((Object)"bar", (Object)testBean.getNested().getStringProperty());
    }

    @Test
    public void testExecuteWithNullInPropertyPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanPropertyValueChangeConsumer("anotherNested.stringProperty", (Object)"foo").accept((Object)new TestBean()));
    }

    @Test
    public void testExecuteWithNullInPropertyPathAngIgnoreTrue() {
        TestBean testBean = new TestBean();
        BeanPropertyValueChangeConsumer consumer = new BeanPropertyValueChangeConsumer("anotherNested.stringProperty", (Object)"Should ignore exception", true);
        consumer.accept((Object)testBean);
    }

    @Test
    public void testExecuteWithReadOnlyProperty() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanPropertyValueChangeConsumer("readOnlyProperty", (Object)"foo").accept((Object)new TestBean()));
    }

    @Test
    public void testExecuteWithSimpleBooleanPropertyAndBooleanValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("booleanProperty", (Object)expectedBooleanValue).accept((Object)testBean);
        Assertions.assertEquals((Object)expectedBooleanValue, (Object)testBean.getBooleanProperty());
    }

    @Test
    public void testExecuteWithSimpleBooleanPropertyAndStringValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanPropertyValueChangeConsumer("booleanProperty", (Object)"true").accept((Object)new TestBean()));
    }

    @Test
    public void testExecuteWithSimpleBytePropertyAndByteValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("byteProperty", (Object)expectedByteValue).accept((Object)testBean);
        Assertions.assertEquals((byte)expectedByteValue, (byte)testBean.getByteProperty());
    }

    @Test
    public void testExecuteWithSimpleBytePropertyAndStringValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanPropertyValueChangeConsumer("byteProperty", (Object)"foo").accept((Object)new TestBean()));
    }

    @Test
    public void testExecuteWithSimpleDoublePropertyAndDoubleValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("doubleProperty", (Object)expectedDoubleValue).accept((Object)testBean);
        Assertions.assertEquals((double)expectedDoubleValue, (double)testBean.getDoubleProperty());
    }

    @Test
    public void testExecuteWithSimpleDoublePropertyAndFloatValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("doubleProperty", (Object)expectedFloatValue).accept((Object)testBean);
        Assertions.assertEquals((double)expectedFloatValue.doubleValue(), (double)testBean.getDoubleProperty());
    }

    @Test
    public void testExecuteWithSimpleDoublePropertyAndIntegerValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("doubleProperty", (Object)expectedIntegerValue).accept((Object)testBean);
        Assertions.assertEquals((double)expectedIntegerValue.doubleValue(), (double)testBean.getDoubleProperty());
    }

    @Test
    public void testExecuteWithSimpleDoublePropertyAndStringValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanPropertyValueChangeConsumer("doubleProperty", (Object)"123").accept((Object)new TestBean()));
    }

    @Test
    public void testExecuteWithSimpleFloatPropertyAndDoubleValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanPropertyValueChangeConsumer("floatProperty", (Object)expectedDoubleValue).accept((Object)new TestBean()));
    }

    @Test
    public void testExecuteWithSimpleFloatPropertyAndFloatValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("floatProperty", (Object)expectedFloatValue).accept((Object)testBean);
        Assertions.assertEquals((float)expectedFloatValue.floatValue(), (float)testBean.getFloatProperty());
    }

    @Test
    public void testExecuteWithSimpleFloatPropertyAndIntegerValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("floatProperty", (Object)expectedIntegerValue).accept((Object)testBean);
        Assertions.assertEquals((float)expectedIntegerValue.floatValue(), (float)testBean.getFloatProperty());
    }

    @Test
    public void testExecuteWithSimpleFloatPropertyAndStringValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanPropertyValueChangeConsumer("floatProperty", (Object)"123").accept((Object)new TestBean()));
    }

    @Test
    public void testExecuteWithSimpleIntPropertyAndDoubleValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanPropertyValueChangeConsumer("intProperty", (Object)expectedDoubleValue).accept((Object)new TestBean()));
    }

    @Test
    public void testExecuteWithSimpleIntPropertyAndFloatValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanPropertyValueChangeConsumer("intProperty", (Object)expectedFloatValue).accept((Object)new TestBean()));
    }

    @Test
    public void testExecuteWithSimpleIntPropertyAndIntegerValue() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("intProperty", (Object)expectedIntegerValue).accept((Object)testBean);
        Assertions.assertEquals((int)expectedIntegerValue, (int)testBean.getIntProperty());
    }

    @Test
    public void testExecuteWithSimpleIntPropertyAndStringValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanPropertyValueChangeConsumer("intProperty", (Object)"123").accept((Object)new TestBean()));
    }

    @Test
    public void testExecuteWithSimplePrimitivePropertyAndNullValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BeanPropertyValueChangeConsumer("intProperty", null).accept((Object)new TestBean()));
    }

    @Test
    public void testExecuteWithSimpleStringProperty() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("stringProperty", (Object)"barney").accept((Object)testBean);
        Assertions.assertEquals((Object)"barney", (Object)testBean.getStringProperty());
    }

    @Test
    public void testExecuteWithWriteOnlyProperty() {
        TestBean testBean = new TestBean();
        new BeanPropertyValueChangeConsumer("writeOnlyProperty", (Object)"foo").accept((Object)testBean);
        Assertions.assertEquals((Object)"foo", (Object)testBean.getWriteOnlyPropertyValue());
    }
}

