/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.converters.ClassReloader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassReloaderTest {
    @Test
    public void testBasicOperation() throws Exception {
        Class<DummyClass> sharedClass = DummyClass.class;
        ClassLoader sharedLoader = this.getClass().getClassLoader();
        ClassReloader componentLoader = new ClassReloader(sharedLoader);
        Class<?> componentClass = componentLoader.reload(sharedClass);
        Assertions.assertTrue((sharedClass != componentClass ? 1 : 0) != 0);
        Assertions.assertSame((Object)sharedLoader, (Object)sharedClass.getClassLoader());
        Assertions.assertSame((Object)componentLoader, (Object)componentClass.getClassLoader());
        Assertions.assertTrue((sharedLoader != componentLoader ? 1 : 0) != 0);
        Object obj1 = sharedClass.newInstance();
        Object obj2 = componentClass.newInstance();
        Assertions.assertTrue((boolean)sharedClass.isInstance(obj1), (String)"Obj1 class incorrect");
        Assertions.assertFalse((boolean)componentClass.isInstance(obj1), (String)"Obj1 class incorrect");
        Assertions.assertFalse((boolean)sharedClass.isInstance(obj2), (String)"Obj2 class incorrect");
        Assertions.assertTrue((boolean)componentClass.isInstance(obj2), (String)"Obj2 class incorrect");
    }

    public static class DummyClass {
    }
}

