/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MapUtils {
    public static <K, V> Map<K, V> copy(Map<K, V> source) {
        return source == null ? null : new HashMap<K, V>(source);
    }

    public static <K, V> Map<K, V> merge(Map<K, V> lhs, Map<K, V> rhs) {
        Map<K, V> result = null;
        if (lhs == null || lhs.isEmpty()) {
            result = MapUtils.copy(rhs);
        } else if (rhs == null || rhs.isEmpty()) {
            result = MapUtils.copy(lhs);
        } else {
            result = MapUtils.copy(lhs);
            result.putAll(rhs);
        }
        return result;
    }

    public static <K, V> Map<String, V> prefix(Map<K, V> source, String prefix) {
        if (source == null) {
            return null;
        }
        HashMap<String, V> result = new HashMap<String, V>();
        for (Map.Entry<K, V> entry : source.entrySet()) {
            result.put(prefix + '.' + Objects.toString(entry.getKey(), ""), entry.getValue());
        }
        return result;
    }

    @Deprecated
    public MapUtils() {
    }
}

