/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.twod;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.geometry.euclidean.internal.AbstractPathConnector;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.spherical.twod.GreatArc;
import org.apache.commons.geometry.spherical.twod.GreatArcPath;
import org.apache.commons.geometry.spherical.twod.Point2S;

public abstract class AbstractGreatArcConnector
extends AbstractPathConnector<ConnectableGreatArc> {
    public void add(GreatArc arc) {
        this.addPathElement(new ConnectableGreatArc(arc));
    }

    public void add(Iterable<GreatArc> arcs) {
        for (GreatArc segment : arcs) {
            this.add(segment);
        }
    }

    public void connect(Iterable<GreatArc> arcs) {
        ArrayList<ConnectableGreatArc> newEntries = new ArrayList<ConnectableGreatArc>();
        for (GreatArc segment : arcs) {
            newEntries.add(new ConnectableGreatArc(segment));
        }
        this.connectPathElements(newEntries);
    }

    public List<GreatArcPath> connectAll(Iterable<GreatArc> arcs) {
        this.add(arcs);
        return this.connectAll();
    }

    public List<GreatArcPath> connectAll() {
        List roots = this.computePathRoots();
        ArrayList<GreatArcPath> paths = new ArrayList<GreatArcPath>(roots.size());
        for (ConnectableGreatArc root : roots) {
            paths.add(this.toPath(root));
        }
        return paths;
    }

    private GreatArcPath toPath(ConnectableGreatArc root) {
        GreatArcPath.Builder builder = GreatArcPath.builder(null);
        builder.append(root.getArc());
        for (ConnectableGreatArc current = (ConnectableGreatArc)root.getNext(); current != null && current != root; current = (ConnectableGreatArc)current.getNext()) {
            builder.append(current.getArc());
        }
        return builder.build();
    }

    protected static class ConnectableGreatArc
    extends AbstractPathConnector.ConnectableElement<ConnectableGreatArc> {
        private final Point2S start;
        private final GreatArc arc;

        public ConnectableGreatArc(Point2S start) {
            this(start, null);
        }

        public ConnectableGreatArc(GreatArc arc) {
            this(arc.getStartPoint(), arc);
        }

        private ConnectableGreatArc(Point2S start, GreatArc arc) {
            this.start = start;
            this.arc = arc;
        }

        public GreatArc getArc() {
            return this.arc;
        }

        public boolean hasStart() {
            return this.start != null;
        }

        public boolean hasEnd() {
            return this.arc.getEndPoint() != null;
        }

        public boolean endPointsEq(ConnectableGreatArc other) {
            if (this.hasEnd() && other.hasEnd()) {
                return this.arc.getEndPoint().eq(other.arc.getEndPoint(), this.arc.getCircle().getPrecision());
            }
            return false;
        }

        public boolean hasZeroSize() {
            return this.arc != null && this.arc.getCircle().getPrecision().eqZero(this.arc.getSize());
        }

        public boolean canConnectTo(ConnectableGreatArc next) {
            Point2S end = this.arc.getEndPoint();
            Point2S nextStart = next.start;
            return end != null && nextStart != null && end.eq(nextStart, this.arc.getCircle().getPrecision());
        }

        public double getRelativeAngle(ConnectableGreatArc other) {
            return this.arc.getCircle().angle(other.getArc().getCircle());
        }

        public ConnectableGreatArc getConnectionSearchKey() {
            return new ConnectableGreatArc(this.arc.getEndPoint());
        }

        public boolean shouldContinueConnectionSearch(ConnectableGreatArc candidate, boolean ascending) {
            if (candidate.hasStart()) {
                double candidatePolar = candidate.getArc().getStartPoint().getPolar();
                double thisPolar = this.arc.getEndPoint().getPolar();
                int cmp = this.arc.getCircle().getPrecision().compare(candidatePolar, thisPolar);
                return ascending ? cmp <= 0 : cmp >= 0;
            }
            return true;
        }

        public int compareTo(ConnectableGreatArc other) {
            int cmp = Point2S.POLAR_AZIMUTH_ASCENDING_ORDER.compare(this.start, other.start);
            if (cmp == 0) {
                boolean thisHasArc = this.arc != null;
                boolean otherHasArc = other.arc != null;
                cmp = Boolean.compare(thisHasArc, otherHasArc);
                if (cmp == 0 && thisHasArc && (cmp = Boolean.compare(this.hasZeroSize(), other.hasZeroSize())) == 0) {
                    cmp = Vector3D.COORDINATE_ASCENDING_ORDER.compare(this.arc.getCircle().getPole(), other.arc.getCircle().getPole());
                }
            }
            return cmp;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.arc);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !((Object)((Object)this)).getClass().equals(obj.getClass())) {
                return false;
            }
            ConnectableGreatArc other = (ConnectableGreatArc)((Object)obj);
            return Objects.equals(this.start, other.start) && Objects.equals(this.arc, other.arc);
        }

        protected ConnectableGreatArc getSelf() {
            return this;
        }
    }
}

