/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.core.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.function.DoubleFunction;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;

public abstract class AbstractTextFormatWriter
implements Closeable {
    private static final String DEFAULT_LINE_SEPARATOR = "\n";
    private final Writer writer;
    private String lineSeparator = "\n";
    private DoubleFunction<String> doubleFormat;

    protected AbstractTextFormatWriter(Writer writer) {
        this(writer, Double::toString);
    }

    protected AbstractTextFormatWriter(Writer writer, DoubleFunction<String> doubleFormat) {
        this.writer = writer;
        this.doubleFormat = doubleFormat;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public DoubleFunction<String> getDoubleFormat() {
        return this.doubleFormat;
    }

    public void setDoubleFormat(DoubleFunction<String> doubleFormat) {
        this.doubleFormat = doubleFormat;
    }

    @Override
    public void close() {
        GeometryIOUtils.closeUnchecked(this.writer);
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected void write(double d) {
        this.write(this.doubleFormat.apply(d));
    }

    protected void write(int n) {
        this.write(String.valueOf(n));
    }

    protected void write(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException exc) {
            throw GeometryIOUtils.createUnchecked(exc);
        }
    }

    protected void write(String str) {
        try {
            this.writer.write(str);
        }
        catch (IOException exc) {
            throw GeometryIOUtils.createUnchecked(exc);
        }
    }

    protected void writeNewLine() {
        this.write(this.lineSeparator);
    }
}

