/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import org.apache.commons.geometry.core.Spatial;
import org.apache.commons.geometry.core.internal.SimpleTupleFormat;
import org.apache.commons.geometry.euclidean.internal.Vectors;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.twod.PolarCoordinates;
import org.apache.commons.numbers.angle.Angle;

public final class SphericalCoordinates
implements Spatial {
    private final double radius;
    private final double azimuth;
    private final double polar;

    private SphericalCoordinates(double radius, double azimuth, double polar) {
        double rad = radius;
        double az = azimuth;
        double pol = polar;
        if (rad < 0.0) {
            rad = Math.abs(rad);
            az += Math.PI;
            pol += Math.PI;
        }
        this.radius = rad;
        this.azimuth = SphericalCoordinates.normalizeAzimuth(az);
        this.polar = SphericalCoordinates.normalizePolar(pol);
    }

    public double getRadius() {
        return this.radius;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getPolar() {
        return this.polar;
    }

    public int getDimension() {
        return 3;
    }

    public boolean isNaN() {
        return Double.isNaN(this.radius) || Double.isNaN(this.azimuth) || Double.isNaN(this.polar);
    }

    public boolean isInfinite() {
        return !this.isNaN() && (Double.isInfinite(this.radius) || Double.isInfinite(this.azimuth) || Double.isInfinite(this.polar));
    }

    public boolean isFinite() {
        return Double.isFinite(this.radius) && Double.isFinite(this.azimuth) && Double.isFinite(this.polar);
    }

    public Vector3D toVector() {
        return SphericalCoordinates.toCartesian(this.radius, this.azimuth, this.polar);
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 127;
        }
        return Double.hashCode(this.radius) >> 17 ^ Double.hashCode(this.azimuth) >> 5 ^ Double.hashCode(this.polar);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SphericalCoordinates) {
            SphericalCoordinates rhs = (SphericalCoordinates)other;
            if (rhs.isNaN()) {
                return this.isNaN();
            }
            return Double.compare(this.radius, rhs.radius) == 0 && Double.compare(this.azimuth, rhs.azimuth) == 0 && Double.compare(this.polar, rhs.polar) == 0;
        }
        return false;
    }

    public String toString() {
        return SimpleTupleFormat.getDefault().format(this.radius, this.azimuth, this.polar);
    }

    public static SphericalCoordinates of(double radius, double azimuth, double polar) {
        return new SphericalCoordinates(radius, azimuth, polar);
    }

    public static SphericalCoordinates fromCartesian(double x, double y, double z) {
        double radius = Vectors.norm(x, y, z);
        double azimuth = Math.atan2(y, x);
        double polar = radius > 0.0 ? Math.acos(z / radius) : 0.0;
        return new SphericalCoordinates(radius, azimuth, polar);
    }

    public static SphericalCoordinates fromCartesian(Vector3D vec) {
        return SphericalCoordinates.fromCartesian(vec.getX(), vec.getY(), vec.getZ());
    }

    public static Vector3D toCartesian(double radius, double azimuth, double polar) {
        double xyLength = radius * Math.sin(polar);
        double x = xyLength * Math.cos(azimuth);
        double y = xyLength * Math.sin(azimuth);
        double z = radius * Math.cos(polar);
        return Vector3D.of(x, y, z);
    }

    public static SphericalCoordinates parse(String input) {
        return (SphericalCoordinates)SimpleTupleFormat.getDefault().parse(input, SphericalCoordinates::new);
    }

    public static double normalizeAzimuth(double azimuth) {
        return PolarCoordinates.normalizeAzimuth(azimuth);
    }

    public static double normalizePolar(double polar) {
        if (Double.isFinite(polar)) {
            return Math.abs(Angle.Rad.WITHIN_MINUS_PI_AND_PI.applyAsDouble(polar));
        }
        return polar;
    }
}

