/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.obj;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.mesh.SimpleTriangleMesh;
import org.apache.commons.geometry.euclidean.threed.mesh.TriangleMesh;
import org.apache.commons.geometry.io.euclidean.threed.obj.AbstractObjPolygonReader;
import org.apache.commons.geometry.io.euclidean.threed.obj.PolygonObjParser;
import org.apache.commons.numbers.core.Precision;

public class ObjTriangleMeshReader
extends AbstractObjPolygonReader {
    private final SimpleTriangleMesh.Builder meshBuilder;
    private final List<Vector3D> normals = new ArrayList<Vector3D>();

    public ObjTriangleMeshReader(Reader reader, Precision.DoubleEquivalence precision) {
        super(reader);
        this.meshBuilder = SimpleTriangleMesh.builder((Precision.DoubleEquivalence)precision);
    }

    public TriangleMesh readTriangleMesh() {
        PolygonObjParser.Face face;
        while ((face = this.readFace()) != null) {
            Vector3D definedNormal = face.getDefinedCompositeNormal(this.normals::get);
            Iterator<PolygonObjParser.VertexAttributes> attrs = face.getVertexAttributesCounterClockwise(definedNormal, arg_0 -> ((SimpleTriangleMesh.Builder)this.meshBuilder).getVertex(arg_0)).iterator();
            int p0 = attrs.next().getVertexIndex();
            int p1 = attrs.next().getVertexIndex();
            while (attrs.hasNext()) {
                int p2 = attrs.next().getVertexIndex();
                this.meshBuilder.addFace(p0, p1, p2);
                p1 = p2;
            }
        }
        return this.meshBuilder.build();
    }

    @Override
    protected void handleVertex(Vector3D vertex) {
        this.meshBuilder.addVertex(vertex);
    }

    @Override
    protected void handleNormal(Vector3D normal) {
        this.normals.add(normal);
    }
}

