/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.test.TestUtils;
import org.apache.commons.io.test.ThrowOnFlushAndCloseOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IOUtilsWriteTest {
    private static final int FILE_SIZE = 4097;
    private final byte[] inData = TestUtils.generateTestData(4097L);

    IOUtilsWriteTest() {
    }

    @Test
    void testWrite_byteArrayToOutputStream() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((byte[])this.inData, (OutputStream)((Object)out));
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testWrite_byteArrayToOutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((byte[])null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWrite_byteArrayToOutputStream_nullStream() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write((byte[])this.inData, (OutputStream)null));
    }

    @Test
    void testWrite_byteArrayToWriter() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((byte[])this.inData, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testWrite_byteArrayToWriter_Encoding() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((byte[])this.inData, (Writer)writer, (String)"UTF8");
        out.off();
        ((Writer)writer).flush();
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, StandardCharsets.UTF_8).getBytes(StandardCharsets.US_ASCII);
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])bytes, (String)"Content differs");
    }

    @Test
    void testWrite_byteArrayToWriter_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write(null, (Writer)writer, (String)"UTF8");
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWrite_byteArrayToWriter_Encoding_nullEncoding() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((byte[])this.inData, (Writer)writer, (String)null);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testWrite_byteArrayToWriter_Encoding_nullWriter() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write((byte[])this.inData, null, (String)"UTF8"));
    }

    @Test
    void testWrite_byteArrayToWriter_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((byte[])null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWrite_byteArrayToWriter_nullWriter() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write((byte[])this.inData, (Writer)null));
    }

    @Test
    void testWrite_charArrayToOutputStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((char[])str.toCharArray(), (OutputStream)((Object)out));
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testWrite_charArrayToOutputStream_Encoding() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((char[])str.toCharArray(), (OutputStream)((Object)out), (String)"UTF16");
        out.off();
        out.flush();
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, StandardCharsets.UTF_16).getBytes(StandardCharsets.US_ASCII);
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])bytes, (String)"Content differs");
    }

    @Test
    void testWrite_charArrayToOutputStream_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((char[])null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWrite_charArrayToOutputStream_Encoding_nullStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write((char[])str.toCharArray(), (OutputStream)null));
    }

    @Test
    void testWrite_charArrayToOutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((char[])null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWrite_charArrayToOutputStream_nullEncoding() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((char[])str.toCharArray(), (OutputStream)((Object)out), (String)null);
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testWrite_charArrayToOutputStream_nullStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write((char[])str.toCharArray(), (OutputStream)null));
    }

    @Test
    void testWrite_charArrayToWriter() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((char[])str.toCharArray(), (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testWrite_charArrayToWriter_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((char[])null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWrite_charArrayToWriter_Encoding_nullStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write((char[])str.toCharArray(), (Writer)null));
    }

    @Test
    void testWrite_charSequenceToOutputStream() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((CharSequence)csq, (OutputStream)((Object)out));
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testWrite_charSequenceToOutputStream_Encoding() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((CharSequence)csq, (OutputStream)((Object)out), (String)"UTF16");
        out.off();
        out.flush();
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, StandardCharsets.UTF_16).getBytes(StandardCharsets.US_ASCII);
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])bytes, (String)"Content differs");
    }

    @Test
    void testWrite_charSequenceToOutputStream_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((CharSequence)null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWrite_charSequenceToOutputStream_Encoding_nullStream() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write((CharSequence)csq, (OutputStream)null));
    }

    @Test
    void testWrite_charSequenceToOutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((CharSequence)null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWrite_charSequenceToOutputStream_nullEncoding() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((CharSequence)csq, (OutputStream)((Object)out), (String)null);
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testWrite_charSequenceToOutputStream_nullStream() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write((CharSequence)csq, (OutputStream)null));
    }

    @Test
    void testWrite_charSequenceToWriter() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((CharSequence)csq, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testWrite_charSequenceToWriter_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((CharSequence)null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWrite_charSequenceToWriter_Encoding_nullStream() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, StandardCharsets.US_ASCII));
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write((CharSequence)csq, (Writer)null));
    }

    @Test
    void testWrite_stringToOutputStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((String)str, (OutputStream)((Object)out));
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testWrite_stringToOutputStream_Encoding() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((String)str, (OutputStream)((Object)out), (String)"UTF16");
        out.off();
        out.flush();
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, StandardCharsets.UTF_16).getBytes(StandardCharsets.US_ASCII);
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])bytes, (String)"Content differs");
    }

    @Test
    void testWrite_stringToOutputStream_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((String)null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWrite_stringToOutputStream_Encoding_nullStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write((String)str, (OutputStream)null));
    }

    @Test
    void testWrite_stringToOutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((String)null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWrite_stringToOutputStream_nullEncoding() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((String)str, (OutputStream)((Object)out), (String)null);
        out.off();
        out.flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testWrite_stringToOutputStream_nullStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write((String)str, (OutputStream)null));
    }

    @Test
    void testWrite_stringToWriter() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((String)str, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertArrayEquals((byte[])this.inData, (byte[])baout.toByteArray(), (String)"Content differs");
    }

    @Test
    void testWrite_stringToWriter_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.write((String)null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWrite_stringToWriter_Encoding_nullStream() throws Exception {
        String str = new String(this.inData, StandardCharsets.US_ASCII);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.write((String)str, (Writer)null));
    }

    @Test
    void testWriteLines_OutputStream() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines(list, (String)"*", (OutputStream)((Object)out));
        out.off();
        out.flush();
        String expected = "hello*world**this is**some text*";
        String actual = baout.toString();
        Assertions.assertEquals((Object)"hello*world**this is**some text*", (Object)actual);
    }

    @Test
    void testWriteLines_OutputStream_Encoding() throws Exception {
        Object[] data = new Object[]{"hello\u8364", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines(list, (String)"*", (OutputStream)((Object)out), (String)StandardCharsets.UTF_8.name());
        out.off();
        out.flush();
        String expected = "hello\u8364*world**this is**some text*";
        String actual = baout.toString(StandardCharsets.UTF_8.name());
        Assertions.assertEquals((Object)"hello\u8364*world**this is**some text*", (Object)actual);
    }

    @Test
    void testWriteLines_OutputStream_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines(null, (String)"*", (OutputStream)((Object)out), (String)StandardCharsets.US_ASCII.name());
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWriteLines_OutputStream_Encoding_nullEncoding() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines(list, (String)"*", (OutputStream)((Object)out), (String)null);
        out.off();
        out.flush();
        String expected = "hello*world**this is**some text*";
        String actual = baout.toString();
        Assertions.assertEquals((Object)"hello*world**this is**some text*", (Object)actual);
    }

    @Test
    void testWriteLines_OutputStream_Encoding_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines(list, null, (OutputStream)((Object)out), (String)StandardCharsets.US_ASCII.name());
        out.off();
        out.flush();
        String expected = "hello" + System.lineSeparator() + "world" + System.lineSeparator();
        String actual = baout.toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteLines_OutputStream_Encoding_nullStream() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.writeLines((Collection)list, (String)"*", null, (String)StandardCharsets.US_ASCII.name()));
    }

    @Test
    void testWriteLines_OutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines(null, (String)"*", (OutputStream)((Object)out));
        out.off();
        out.flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWriteLines_OutputStream_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines(list, null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        String expected = "hello" + System.lineSeparator() + "world" + System.lineSeparator();
        String actual = baout.toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteLines_OutputStream_nullStream() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.writeLines((Collection)list, (String)"*", (OutputStream)null));
    }

    @Test
    void testWriteLines_Writer() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.writeLines(list, (String)"*", (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        String expected = "hello*world**this is**some text*";
        String actual = baout.toString();
        Assertions.assertEquals((Object)"hello*world**this is**some text*", (Object)actual);
    }

    @Test
    void testWriteLines_Writer_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.writeLines(null, (String)"*", (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)baout.size(), (String)"Sizes differ");
    }

    @Test
    void testWriteLines_Writer_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThrowOnFlushAndCloseOutputStream out = new ThrowOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, StandardCharsets.US_ASCII);
        IOUtils.writeLines(list, null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        String expected = "hello" + System.lineSeparator() + "world" + System.lineSeparator();
        String actual = baout.toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void testWriteLines_Writer_nullStream() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.writeLines((Collection)list, (String)"*", (Writer)null));
    }
}

