/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache;

import java.util.Collections;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.EventType;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.jcache.JCSCacheEntryEvent;
import org.apache.commons.jcs3.jcache.JCSListener;

public class ExpiryAwareCache<A, B>
extends CompositeCache<A, B> {
    private Map<CacheEntryListenerConfiguration<A, B>, JCSListener<A, B>> listeners;
    private Cache<A, B> cacheRef;

    ExpiryAwareCache(ICompositeCacheAttributes cattr, IElementAttributes attr) {
        super(cattr, attr);
    }

    protected void doExpires(ICacheElement<A, B> element) {
        super.doExpires(element);
        for (JCSListener<A, B> listener : this.listeners.values()) {
            listener.onExpired(Collections.singletonList(new JCSCacheEntryEvent<Object, Object>(this.cacheRef, EventType.REMOVED, null, element.getKey(), element.getVal())));
        }
    }

    void init(Cache<A, B> cache, Map<CacheEntryListenerConfiguration<A, B>, JCSListener<A, B>> listeners) {
        this.cacheRef = cache;
        this.listeners = listeners;
    }
}

