/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPService;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.TCPLateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;

public class LateralTCPIssueRemoveOnPutUnitTest
extends TestCase {
    private static final boolean isSysOut = false;
    private final int serverPort = 1118;

    public LateralTCPIssueRemoveOnPutUnitTest(String testName) {
        super(testName);
    }

    public void setUp() {
        System.setProperty("jcs.auxiliary.LTCP.attributes.TcpServers", "localhost:1118");
        JCS.setConfigFilename((String)"/TestTCPLateralIssueRemoveCache.ccf");
    }

    public void testPutLocalPutRemoteGetBusyVerifyRemoved() throws Exception {
        this.runTestForRegion("region1", 1, 200, 1);
    }

    public void testStandardPut() throws Exception {
        String region = "region1";
        CacheAccess cache = JCS.getInstance((String)"region1");
        Thread.sleep(100L);
        TCPLateralCacheAttributes lattr2 = new TCPLateralCacheAttributes();
        lattr2.setTcpListenerPort(1102);
        lattr2.setTransmissionType(ILateralCacheAttributes.Type.TCP);
        lattr2.setTcpServer("localhost:1118");
        lattr2.setIssueRemoveOnPut(false);
        LateralTCPService service = new LateralTCPService((ITCPLateralCacheAttributes)lattr2, (IElementSerializer)new StandardSerializer());
        service.setListenerId(123456L);
        String keyToBeRemovedOnPut = "test1_notremoved";
        CacheElement element1 = new CacheElement("region1", (Object)"test1_notremoved", (Object)"region1:data-this shouldn't get removed, it should get to the cache.");
        service.update((ICacheElement)element1);
        Thread.sleep(1000L);
        Object testObj = cache.get((Object)"test1_notremoved");
        LateralTCPIssueRemoveOnPutUnitTest.p("testStandardPut, test object = " + testObj);
        LateralTCPIssueRemoveOnPutUnitTest.assertNotNull((String)"The test object should not have been removed by a put.", (Object)testObj);
    }

    public void runTestForRegion(String region, int range, int numOps, int testNum) throws Exception {
        CacheAccess cache = JCS.getInstance((String)region);
        Thread.sleep(100L);
        TCPLateralCacheAttributes lattr2 = new TCPLateralCacheAttributes();
        lattr2.setTcpListenerPort(1102);
        lattr2.setTransmissionType(ILateralCacheAttributes.Type.TCP);
        lattr2.setTcpServer("localhost:1118");
        lattr2.setIssueRemoveOnPut(true);
        lattr2.setAllowPut(false);
        LateralTCPService service = new LateralTCPService((ITCPLateralCacheAttributes)lattr2, (IElementSerializer)new StandardSerializer());
        service.setListenerId(123456L);
        String keyToBeRemovedOnPut = "test1";
        cache.put((Object)"test1", (Object)"this should get removed.");
        CacheElement element1 = new CacheElement(region, (Object)"test1", (Object)(region + ":data-this shouldn't get there"));
        service.update((ICacheElement)element1);
        try {
            for (int i = 1; i < numOps; ++i) {
                Random ran = new Random(i);
                int n = ran.nextInt(4);
                int kn = ran.nextInt(range);
                String key = "key" + kn;
                CacheElement element = new CacheElement(region, (Object)key, (Object)(region + ":data" + i + " junk asdfffffffadfasdfasf " + kn + ":" + n));
                service.update((ICacheElement)element);
                LateralTCPIssueRemoveOnPutUnitTest.p("put " + key);
                if (i % 100 != 0) continue;
                LateralTCPIssueRemoveOnPutUnitTest.p(cache.getStats());
            }
            LateralTCPIssueRemoveOnPutUnitTest.p("Finished cycle of " + numOps);
        }
        catch (Exception e) {
            LateralTCPIssueRemoveOnPutUnitTest.p(e.toString());
            throw e;
        }
        CacheAccess jcs = JCS.getInstance((String)region);
        String key = "testKey" + testNum;
        String data = "testData" + testNum;
        jcs.put((Object)key, (Object)data);
        String value = (String)jcs.get((Object)key);
        LateralTCPIssueRemoveOnPutUnitTest.assertEquals((String)"Couldn't put normally.", (String)data, (String)value);
        for (int i = 1; i < numOps; ++i) {
            String keyL = "key" + i;
            String dataL = (String)jcs.get((Object)keyL);
            if (dataL == null) continue;
            LateralTCPIssueRemoveOnPutUnitTest.assertTrue((String)"Incorrect region detected.", (boolean)dataL.startsWith(region));
        }
        Thread.sleep(200L);
        Object testObj = cache.get((Object)"test1");
        LateralTCPIssueRemoveOnPutUnitTest.p("runTestForRegion, test object = " + testObj);
        LateralTCPIssueRemoveOnPutUnitTest.assertNull((String)"The test object should have been removed by a put.", (Object)testObj);
    }

    public static void p(String s) {
    }
}

