/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.http.client;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheDispatcher;
import org.apache.commons.jcs3.auxiliary.remote.http.client.AbstractHttpClient;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.commons.jcs3.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.serialization.StandardSerializer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;

public class RemoteHttpCacheDispatcher
extends AbstractHttpClient
implements IRemoteCacheDispatcher {
    private static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    private static final String PARAMETER_REQUEST_TYPE = "RequestType";
    private static final String PARAMETER_KEY = "Key";
    private static final String PARAMETER_CACHE_NAME = "CacheName";
    private static final Log log = LogManager.getLog(RemoteHttpCacheDispatcher.class);
    private final StandardSerializer serializer = new StandardSerializer();

    public RemoteHttpCacheDispatcher(RemoteHttpCacheAttributes remoteHttpCacheAttributes) {
        super(remoteHttpCacheAttributes);
    }

    @Override
    public <K, V, T> RemoteCacheResponse<T> dispatchRequest(RemoteCacheRequest<K, V> remoteCacheRequest) throws IOException {
        try {
            byte[] requestAsByteArray = this.serializer.serialize(remoteCacheRequest);
            byte[] responseAsByteArray = this.processRequest(requestAsByteArray, remoteCacheRequest, this.getRemoteHttpCacheAttributes().getUrl());
            RemoteCacheResponse remoteCacheResponse = null;
            try {
                remoteCacheResponse = (RemoteCacheResponse)this.serializer.deSerialize(responseAsByteArray, null);
            }
            catch (ClassNotFoundException e) {
                log.error("Couldn't deserialize the response.", e);
            }
            return remoteCacheResponse;
        }
        catch (Exception e) {
            throw new IOException("Problem dispatching request.", e);
        }
    }

    protected <K, V> byte[] processRequest(byte[] requestAsByteArray, RemoteCacheRequest<K, V> remoteCacheRequest, String url) throws IOException, HttpException {
        RequestBuilder builder = RequestBuilder.post((String)url).setCharset(DEFAULT_ENCODING);
        if (this.getRemoteHttpCacheAttributes().isIncludeCacheNameAsParameter() && remoteCacheRequest.getCacheName() != null) {
            builder.addParameter(PARAMETER_CACHE_NAME, remoteCacheRequest.getCacheName());
        }
        if (this.getRemoteHttpCacheAttributes().isIncludeKeysAndPatternsAsParameter()) {
            String keyValue = "";
            switch (remoteCacheRequest.getRequestType()) {
                case GET: 
                case REMOVE: 
                case GET_KEYSET: {
                    keyValue = remoteCacheRequest.getKey().toString();
                    break;
                }
                case GET_MATCHING: {
                    keyValue = remoteCacheRequest.getPattern();
                    break;
                }
                case GET_MULTIPLE: {
                    keyValue = remoteCacheRequest.getKeySet().toString();
                    break;
                }
                case UPDATE: {
                    keyValue = remoteCacheRequest.getCacheElement().getKey().toString();
                    break;
                }
            }
            builder.addParameter(PARAMETER_KEY, keyValue);
        }
        if (this.getRemoteHttpCacheAttributes().isIncludeRequestTypeasAsParameter()) {
            builder.addParameter(PARAMETER_REQUEST_TYPE, remoteCacheRequest.getRequestType().toString());
        }
        builder.setEntity((HttpEntity)new ByteArrayEntity(requestAsByteArray));
        HttpResponse httpResponse = this.doWebserviceCall(builder);
        return EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
    }

    @Override
    protected void preProcessWebserviceCall(RequestBuilder requestBuilder) throws IOException {
    }

    @Override
    protected void postProcessWebserviceCall(HttpUriRequest request, HttpResponse httpState) throws IOException {
    }
}

