/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.ClassFunctions;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.PackageFunctions;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.TestBean;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.ri.compiler.TestFunctions;
import org.apache.commons.jxpath.ri.compiler.TestFunctions2;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.util.JXPath11CompatibleTypeConverter;
import org.apache.commons.jxpath.util.TypeConverter;
import org.apache.commons.jxpath.util.TypeUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExtensionFunctionTest
extends AbstractJXPathTest {
    private Functions functions;
    private JXPathContext context;
    private TestBean testBean;
    private TypeConverter typeConverter;

    @Override
    @BeforeEach
    public void setUp() {
        if (this.context == null) {
            this.testBean = new TestBean();
            this.context = JXPathContext.newContext((Object)this.testBean);
            Variables vars = this.context.getVariables();
            vars.declareVariable("test", (Object)new TestFunctions(4, "test"));
            FunctionLibrary lib = new FunctionLibrary();
            lib.addFunctions((Functions)new ClassFunctions(TestFunctions.class, "test"));
            lib.addFunctions((Functions)new ClassFunctions(TestFunctions2.class, "test"));
            lib.addFunctions((Functions)new PackageFunctions("", "call"));
            lib.addFunctions((Functions)new PackageFunctions("org.apache.commons.jxpath.ri.compiler.", "jxpathtest"));
            lib.addFunctions((Functions)new PackageFunctions("", null));
            this.context.setFunctions((Functions)lib);
            this.context.getVariables().declareVariable("List.class", List.class);
            this.context.getVariables().declareVariable("NodeSet.class", NodeSet.class);
        }
        this.functions = new ClassFunctions(TestFunctions.class, "test");
        this.typeConverter = TypeUtils.getTypeConverter();
    }

    @AfterEach
    public void tearDown() {
        TypeUtils.setTypeConverter((TypeConverter)this.typeConverter);
    }

    @Test
    public void testAllocation() {
        this.assertXPathValue(this.context, "string(test:new())", "foo=0; bar=null");
        this.assertXPathValue(this.context, "string(jxpathtest:TestFunctions.new())", "foo=0; bar=null");
        this.assertXPathValue(this.context, "string(" + TestFunctions.class.getName() + ".new())", "foo=0; bar=null");
        this.assertXPathValue(this.context, "string(test:new(3, 'baz'))", "foo=3; bar=baz");
        this.assertXPathValue(this.context, "string(test:new('3', 4))", "foo=3; bar=4.0");
        this.context.getVariables().declareVariable("A", (Object)"baz");
        this.assertXPathValue(this.context, "string(test:new(2, $A, false))", "foo=2; bar=baz");
    }

    @Test
    public void testBCNodeSetHack() {
        TypeUtils.setTypeConverter((TypeConverter)new JXPath11CompatibleTypeConverter());
        this.assertXPathValue(this.context, "test:isInstance(//strings, $List.class)", Boolean.FALSE);
        this.assertXPathValue(this.context, "test:isInstance(//strings, $NodeSet.class)", Boolean.TRUE);
    }

    @Test
    public void testCollectionMethodCall() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        this.context.getVariables().declareVariable("myList", list);
        this.assertXPathValue(this.context, "size($myList)", 1);
        this.assertXPathValue(this.context, "size(beans)", 2);
        this.context.getValue("add($myList, 'hello')");
        Assertions.assertEquals((int)2, (int)list.size(), (String)"After adding an element");
        JXPathContext context = JXPathContext.newContext(new ArrayList());
        Assertions.assertEquals((Object)"0", (Object)String.valueOf(context.getValue("size(/)")), (String)"Extension function on root collection");
    }

    @Test
    public void testCollectionReturn() {
        this.assertXPathValueIterator(this.context, "test:collection()/name", ExtensionFunctionTest.list("foo", "bar"));
        this.assertXPathPointerIterator(this.context, "test:collection()/name", ExtensionFunctionTest.list("/.[1]/name", "/.[2]/name"));
        this.assertXPathValue(this.context, "test:collection()/name", "foo");
        this.assertXPathValue(this.context, "test:collection()/@name", "foo");
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add("bar");
        this.context.getVariables().declareVariable("list", list);
        Object values = this.context.getValue("test:items($list)");
        Assertions.assertInstanceOf(Collection.class, (Object)values, (String)"Return type: ");
        Assertions.assertEquals(list, new ArrayList((Collection)values), (String)"Return values: ");
    }

    @Test
    public void testConstructorLookup() {
        Object[] args = new Object[]{1, "x"};
        Function func = this.functions.getFunction("test", "new", args);
        Assertions.assertEquals((Object)"foo=1; bar=x", (Object)func.invoke((ExpressionContext)new Context(null), args).toString(), (String)"test:new(1, x)");
    }

    @Test
    public void testConstructorLookupWithExpressionContext() {
        Object[] args = new Object[]{"baz"};
        Function func = this.functions.getFunction("test", "new", args);
        Assertions.assertEquals((Object)"foo=1; bar=baz", (Object)func.invoke((ExpressionContext)new Context(1), args).toString(), (String)"test:new('baz')");
    }

    @Test
    public void testEstablishNodeSetBaseline() {
        this.assertXPathValue(this.context, "test:isInstance(//strings, $List.class)", Boolean.TRUE);
        this.assertXPathValue(this.context, "test:isInstance(//strings, $NodeSet.class)", Boolean.FALSE);
    }

    @Test
    public void testExpressionContext() {
        this.assertXPathValue(this.context, "//.[test:isMap()]/Key1", "Value 1");
        this.assertXPathValue(this.context, "count(//.[test:count(strings) = 3])", 7.0);
        this.assertXPathValue(this.context, "test:count(//strings)", 21);
        this.assertXPathValue(this.context, "test:countPointers(//strings)", 21);
        this.assertXPathValue(this.context, "/beans[contains(test:path(), '[2]')]/name", "Name 2");
    }

    @Test
    public void testMethodCall() {
        this.assertXPathValue(this.context, "length('foo')", 3);
        this.assertXPathValue(this.context, "call:substring('foo', 1, 2)", "o");
        this.assertXPathValue(this.context, "string(test:getFoo($test))", "4");
        this.assertXPathValue(this.context, "string(call:getFoo($test))", "4");
        this.assertXPathValue(this.context, "string(getFoo($test))", "4");
        this.assertXPathValue(this.context, "string(test:setFooAndBar($test, 7, 'biz'))", "foo=7; bar=biz");
    }

    @Test
    public void testMethodLookup() {
        Object[] args = new Object[]{new TestFunctions()};
        Function func = this.functions.getFunction("test", "getFoo", args);
        Assertions.assertEquals((Object)"0", (Object)func.invoke((ExpressionContext)new Context(null), args).toString(), (String)"test:getFoo($test, 1, x)");
    }

    @Test
    public void testMethodLookupWithExpressionContext() {
        Object[] args = new Object[]{new TestFunctions()};
        Function func = this.functions.getFunction("test", "instancePath", args);
        Assertions.assertEquals((Object)"1", (Object)func.invoke((ExpressionContext)new Context(1), args), (String)"test:instancePath()");
    }

    @Test
    public void testMethodLookupWithExpressionContextAndArgument() {
        Object[] args = new Object[]{new TestFunctions(), "*"};
        Function func = this.functions.getFunction("test", "pathWithSuffix", args);
        Assertions.assertEquals((Object)"1*", (Object)func.invoke((ExpressionContext)new Context(1), args), (String)"test:pathWithSuffix('*')");
    }

    @Test
    public void testNodeSetReturn() {
        this.assertXPathValueIterator(this.context, "test:nodeSet()/name", ExtensionFunctionTest.list("Name 1", "Name 2"));
        this.assertXPathValueIterator(this.context, "test:nodeSet()", ExtensionFunctionTest.list(this.testBean.getBeans()[0], this.testBean.getBeans()[1]));
        this.assertXPathPointerIterator(this.context, "test:nodeSet()/name", ExtensionFunctionTest.list("/beans[1]/name", "/beans[2]/name"));
        this.assertXPathValueAndPointer(this.context, "test:nodeSet()/name", "Name 1", "/beans[1]/name");
        this.assertXPathValueAndPointer(this.context, "test:nodeSet()/@name", "Name 1", "/beans[1]/@name");
        Assertions.assertEquals((int)2, (int)((Number)this.context.getValue("count(test:nodeSet())")).intValue());
        this.assertXPathValue(this.context, "test:nodeSet()", this.testBean.getBeans()[0]);
    }

    @Test
    public void testStaticMethodCall() {
        this.assertXPathValue(this.context, "string(test:build(8, 'goober'))", "foo=8; bar=goober");
        this.assertXPathValue(this.context, "string(jxpathtest:TestFunctions.build(8, 'goober'))", "foo=8; bar=goober");
        this.assertXPathValue(this.context, "string(" + TestFunctions.class.getName() + ".build(8, 'goober'))", "foo=8; bar=goober");
        this.assertXPathValue(this.context, "string(test:increment(8))", "9");
        this.assertXPathValue(this.context, "test:string(/beans/name)", "Name 1");
    }

    @Test
    public void testStaticMethodLookup() {
        Object[] args = new Object[]{1, "x"};
        Function func = this.functions.getFunction("test", "build", args);
        Assertions.assertEquals((Object)"foo=1; bar=x", (Object)func.invoke((ExpressionContext)new Context(null), args).toString(), (String)"test:build(1, x)");
    }

    @Test
    public void testStaticMethodLookupWithConversion() {
        Object[] args = new Object[]{"7", 1};
        Function func = this.functions.getFunction("test", "build", args);
        Assertions.assertEquals((Object)"foo=7; bar=1", (Object)func.invoke((ExpressionContext)new Context(null), args).toString(), (String)"test:build('7', 1)");
    }

    @Test
    public void testStaticMethodLookupWithExpressionContext() {
        Object[] args = new Object[]{};
        Function func = this.functions.getFunction("test", "path", args);
        Assertions.assertEquals((Object)"1", (Object)func.invoke((ExpressionContext)new Context(1), args), (String)"test:path()");
    }

    private static final class Context
    implements ExpressionContext {
        private final Object object;

        public Context(Object object) {
            this.object = object;
        }

        public List<Pointer> getContextNodeList() {
            return null;
        }

        public Pointer getContextNodePointer() {
            return NodePointer.newNodePointer(null, (Object)this.object, (Locale)Locale.getDefault());
        }

        public JXPathContext getJXPathContext() {
            return null;
        }

        public int getPosition() {
            return 0;
        }
    }
}

