/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import org.apache.commons.jxpath.AbstractJXPathTest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.xml.DocumentContainer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XMLUpperCaseElementsTest
extends AbstractJXPathTest {
    protected JXPathContext context;

    protected JXPathContext createContext(String model) {
        JXPathContext context = JXPathContext.newContext((Object)this.createDocumentContainer(model));
        return context;
    }

    protected DocumentContainer createDocumentContainer(String model) {
        return new DocumentContainer(AbstractJXPathTest.class.getResource("VendorUpper.xml"), model);
    }

    protected void doTest(String id, String model, String expectedValue) {
        JXPathContext context = JXPathContext.newContext((Object)this.createDocumentContainer(model));
        Assertions.assertEquals((Object)expectedValue, (Object)context.getValue("test/text[@id='" + id + "']"));
    }

    @Test
    public void testBasicGetDOM() {
        this.assertXPathValue(this.createContext("DOM"), "/Vendor[1]/Contact[1]", "John");
    }

    @Test
    public void testBasicGetJDOM() {
        this.assertXPathValue(this.createContext("JDOM"), "/Vendor[1]/Contact[1]", "John");
    }

    @Test
    public void testBasicIterateDOM() {
        this.assertXPathValueIterator(this.createContext("DOM"), "/Vendor/Contact", XMLUpperCaseElementsTest.list("John", "Jack", "Jim", "Jack Black"));
    }

    @Test
    public void testBasicIterateJDOM() {
        this.assertXPathValueIterator(this.createContext("JDOM"), "/Vendor/Contact", XMLUpperCaseElementsTest.list("John", "Jack", "Jim", "Jack Black"));
    }
}

