/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.ExtendedFieldElementAbstractTest;
import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.analysis.differentiation.SparseGradient;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.random.Well1024a;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseGradientTest
extends ExtendedFieldElementAbstractTest<SparseGradient> {
    @Override
    protected SparseGradient build(double x) {
        return SparseGradient.createVariable((int)0, (double)x);
    }

    @Test
    public void testConstant() {
        double c = 1.0;
        SparseGradient grad = SparseGradient.createConstant((double)c);
        Assert.assertEquals((double)c, (double)grad.getValue(), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)grad.numVars(), (double)1.0E-15);
    }

    @Test
    public void testVariable() {
        double v = 1.0;
        int id = 0;
        SparseGradient grad = SparseGradient.createVariable((int)id, (double)v);
        Assert.assertEquals((double)v, (double)grad.getValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)grad.numVars(), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)grad.getDerivative(id), (double)1.0E-15);
    }

    @Test
    public void testVarAddition() {
        double v1 = 1.0;
        double v2 = 2.0;
        int id1 = -1;
        int id2 = 3;
        SparseGradient var1 = SparseGradient.createVariable((int)-1, (double)1.0);
        SparseGradient var2 = SparseGradient.createVariable((int)3, (double)2.0);
        SparseGradient sum = var1.add(var2);
        Assert.assertEquals((double)3.0, (double)sum.getValue(), (double)1.0E-15);
        Assert.assertEquals((long)2L, (long)sum.numVars());
        Assert.assertEquals((double)1.0, (double)sum.getDerivative(-1), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)sum.getDerivative(3), (double)1.0E-15);
    }

    @Test
    public void testSubtraction() {
        double v1 = 1.0;
        double v2 = 2.0;
        int id1 = -1;
        int id2 = 3;
        SparseGradient var1 = SparseGradient.createVariable((int)-1, (double)1.0);
        SparseGradient var2 = SparseGradient.createVariable((int)3, (double)2.0);
        SparseGradient sum = var1.subtract(var2);
        Assert.assertEquals((double)-1.0, (double)sum.getValue(), (double)1.0E-15);
        Assert.assertEquals((long)2L, (long)sum.numVars());
        Assert.assertEquals((double)1.0, (double)sum.getDerivative(-1), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)sum.getDerivative(3), (double)1.0E-15);
    }

    @Test
    public void testDivision() {
        double v1 = 1.0;
        double v2 = 2.0;
        int id1 = -1;
        int id2 = 3;
        SparseGradient var1 = SparseGradient.createVariable((int)-1, (double)1.0);
        SparseGradient var2 = SparseGradient.createVariable((int)3, (double)2.0);
        SparseGradient out = var1.divide(var2);
        Assert.assertEquals((double)0.5, (double)out.getValue(), (double)1.0E-15);
        Assert.assertEquals((long)2L, (long)out.numVars());
        Assert.assertEquals((double)0.5, (double)out.getDerivative(-1), (double)1.0E-15);
        Assert.assertEquals((double)-0.25, (double)out.getDerivative(3), (double)1.0E-15);
    }

    @Test
    public void testMult() {
        double v1 = 1.0;
        double c1 = 0.5;
        double v2 = 2.0;
        int id1 = -1;
        int id2 = 3;
        SparseGradient var1 = SparseGradient.createVariable((int)-1, (double)1.0);
        SparseGradient unit1 = var1.multiply(0.5);
        SparseGradient unit2 = SparseGradient.createVariable((int)3, (double)2.0).multiply(var1);
        SparseGradient sum = unit1.add(unit2);
        Assert.assertEquals((double)2.5, (double)sum.getValue(), (double)1.0E-15);
        Assert.assertEquals((long)2L, (long)sum.numVars());
        Assert.assertEquals((double)2.5, (double)sum.getDerivative(-1), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)sum.getDerivative(3), (double)1.0E-15);
    }

    @Test
    public void testVarMultInPlace() {
        double v1 = 1.0;
        double c1 = 0.5;
        double v2 = 2.0;
        int id1 = -1;
        int id2 = 3;
        SparseGradient var1 = SparseGradient.createVariable((int)-1, (double)1.0);
        SparseGradient sum = var1.multiply(0.5);
        SparseGradient mult = SparseGradient.createVariable((int)3, (double)2.0);
        mult.multiplyInPlace(var1);
        sum.addInPlace(mult);
        Assert.assertEquals((double)2.5, (double)sum.getValue(), (double)1.0E-15);
        Assert.assertEquals((long)2L, (long)sum.numVars());
        Assert.assertEquals((double)2.5, (double)sum.getDerivative(-1), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)sum.getDerivative(3), (double)1.0E-15);
    }

    @Test
    public void testPrimitiveAdd() {
        this.checkF0F1(SparseGradient.createVariable((int)0, (double)1.0).add(5.0), 6.0, 1.0, 0.0, 0.0);
        this.checkF0F1(SparseGradient.createVariable((int)1, (double)2.0).add(5.0), 7.0, 0.0, 1.0, 0.0);
        this.checkF0F1(SparseGradient.createVariable((int)2, (double)3.0).add(5.0), 8.0, 0.0, 0.0, 1.0);
    }

    @Test
    public void testAdd() {
        SparseGradient x = SparseGradient.createVariable((int)0, (double)1.0);
        SparseGradient y = SparseGradient.createVariable((int)1, (double)2.0);
        SparseGradient z = SparseGradient.createVariable((int)2, (double)3.0);
        SparseGradient xyz = x.add(y.add(z));
        this.checkF0F1(xyz, x.getValue() + y.getValue() + z.getValue(), 1.0, 1.0, 1.0);
    }

    @Test
    public void testPrimitiveSubtract() {
        this.checkF0F1(SparseGradient.createVariable((int)0, (double)1.0).subtract(5.0), -4.0, 1.0, 0.0, 0.0);
        this.checkF0F1(SparseGradient.createVariable((int)1, (double)2.0).subtract(5.0), -3.0, 0.0, 1.0, 0.0);
        this.checkF0F1(SparseGradient.createVariable((int)2, (double)3.0).subtract(5.0), -2.0, 0.0, 0.0, 1.0);
    }

    @Test
    public void testSubtract() {
        SparseGradient x = SparseGradient.createVariable((int)0, (double)1.0);
        SparseGradient y = SparseGradient.createVariable((int)1, (double)2.0);
        SparseGradient z = SparseGradient.createVariable((int)2, (double)3.0);
        SparseGradient xyz = x.subtract(y.subtract(z));
        this.checkF0F1(xyz, x.getValue() - (y.getValue() - z.getValue()), 1.0, -1.0, 1.0);
    }

    @Test
    public void testPrimitiveMultiply() {
        this.checkF0F1(SparseGradient.createVariable((int)0, (double)1.0).multiply(5), 5.0, 5.0, 0.0, 0.0);
        this.checkF0F1(SparseGradient.createVariable((int)1, (double)2.0).multiply(5), 10.0, 0.0, 5.0, 0.0);
        this.checkF0F1(SparseGradient.createVariable((int)2, (double)3.0).multiply(5), 15.0, 0.0, 0.0, 5.0);
    }

    @Test
    public void testMultiply() {
        SparseGradient x = SparseGradient.createVariable((int)0, (double)1.0);
        SparseGradient y = SparseGradient.createVariable((int)1, (double)2.0);
        SparseGradient z = SparseGradient.createVariable((int)2, (double)3.0);
        SparseGradient xyz = x.multiply(y.multiply(z));
        this.checkF0F1(xyz, 6.0, 6.0, 3.0, 2.0);
    }

    @Test
    public void testNegate() {
        this.checkF0F1(SparseGradient.createVariable((int)0, (double)1.0).negate(), -1.0, -1.0, 0.0, 0.0);
        this.checkF0F1(SparseGradient.createVariable((int)1, (double)2.0).negate(), -2.0, 0.0, -1.0, 0.0);
        this.checkF0F1(SparseGradient.createVariable((int)2, (double)3.0).negate(), -3.0, 0.0, 0.0, -1.0);
    }

    @Test
    public void testReciprocal() {
        for (double x = 0.1; x < 1.2; x += 0.1) {
            SparseGradient r = SparseGradient.createVariable((int)0, (double)x).reciprocal();
            Assert.assertEquals((double)(1.0 / x), (double)r.getValue(), (double)1.0E-15);
            double expected = -1.0 / (x * x);
            Assert.assertEquals((double)expected, (double)r.getDerivative(0), (double)(1.0E-15 * FastMath.abs((double)expected)));
        }
    }

    @Test
    public void testPow() {
        for (int n = 0; n < 10; ++n) {
            SparseGradient x = SparseGradient.createVariable((int)0, (double)1.0);
            SparseGradient y = SparseGradient.createVariable((int)1, (double)2.0);
            SparseGradient z = SparseGradient.createVariable((int)2, (double)3.0);
            List<SparseGradient> list = Arrays.asList(x, y, z, x.add(y).add(z), x.multiply(y).multiply(z));
            if (n == 0) {
                for (SparseGradient sg : list) {
                    Assert.assertEquals((Object)sg.getField().getOne(), (Object)sg.pow(n));
                }
                continue;
            }
            if (n == 1) {
                for (SparseGradient sg : list) {
                    Assert.assertEquals((Object)sg, (Object)sg.pow(n));
                }
                continue;
            }
            for (SparseGradient sg : list) {
                SparseGradient p = (SparseGradient)sg.getField().getOne();
                for (int i = 0; i < n; ++i) {
                    p = p.multiply(sg);
                }
                Assert.assertEquals((Object)p, (Object)sg.pow(n));
            }
        }
    }

    @Test
    public void testPowDoubleDS() {
        for (int maxOrder = 1; maxOrder < 5; ++maxOrder) {
            SparseGradient x = SparseGradient.createVariable((int)0, (double)0.1);
            SparseGradient y = SparseGradient.createVariable((int)1, (double)0.2);
            SparseGradient z = SparseGradient.createVariable((int)2, (double)0.3);
            List<SparseGradient> list = Arrays.asList(x, y, z, x.add(y).add(z), x.multiply(y).multiply(z));
            for (SparseGradient sg : list) {
                for (double a : new double[]{0.0, 0.1, 1.0, 2.0, 5.0}) {
                    SparseGradient reference = a == 0.0 ? (SparseGradient)x.getField().getZero() : SparseGradient.createConstant((double)a).pow(sg);
                    SparseGradient result = SparseGradient.pow((double)a, (SparseGradient)sg);
                    Assert.assertEquals((Object)reference, (Object)result);
                }
            }
            SparseGradient negEvenInteger = SparseGradient.pow((double)-2.0, (SparseGradient)SparseGradient.createVariable((int)0, (double)2.0));
            Assert.assertEquals((double)4.0, (double)negEvenInteger.getValue(), (double)1.0E-15);
            Assert.assertTrue((boolean)Double.isNaN(negEvenInteger.getDerivative(0)));
            SparseGradient negOddInteger = SparseGradient.pow((double)-2.0, (SparseGradient)SparseGradient.createVariable((int)0, (double)3.0));
            Assert.assertEquals((double)-8.0, (double)negOddInteger.getValue(), (double)1.0E-15);
            Assert.assertTrue((boolean)Double.isNaN(negOddInteger.getDerivative(0)));
            SparseGradient negNonInteger = SparseGradient.pow((double)-2.0, (SparseGradient)SparseGradient.createVariable((int)0, (double)2.001));
            Assert.assertTrue((boolean)Double.isNaN(negNonInteger.getValue()));
            Assert.assertTrue((boolean)Double.isNaN(negNonInteger.getDerivative(0)));
            SparseGradient zeroNeg = SparseGradient.pow((double)0.0, (SparseGradient)SparseGradient.createVariable((int)0, (double)-1.0));
            Assert.assertTrue((boolean)Double.isNaN(zeroNeg.getValue()));
            Assert.assertTrue((boolean)Double.isNaN(zeroNeg.getDerivative(0)));
            SparseGradient posNeg = SparseGradient.pow((double)2.0, (SparseGradient)SparseGradient.createVariable((int)0, (double)-2.0));
            Assert.assertEquals((double)0.25, (double)posNeg.getValue(), (double)1.0E-15);
            Assert.assertEquals((double)(FastMath.log((double)2.0) / 4.0), (double)posNeg.getDerivative(0), (double)1.0E-15);
            SparseGradient zeroZero = SparseGradient.pow((double)0.0, (SparseGradient)SparseGradient.createVariable((int)0, (double)0.0));
            Assert.assertEquals((double)1.0, (double)zeroZero.getValue(), (double)1.0E-15);
            Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)zeroZero.getDerivative(0), (double)1.0E-15);
            Assert.assertEquals((double)0.0, (double)zeroZero.getDerivative(1), (double)1.0E-15);
            Assert.assertEquals((double)0.0, (double)zeroZero.getDerivative(2), (double)1.0E-15);
        }
    }

    @Test
    public void testExpression() {
        double epsilon = 2.5E-13;
        for (double x = 0.0; x < 2.0; x += 0.2) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            for (double y = 0.0; y < 2.0; y += 0.2) {
                SparseGradient sgY = SparseGradient.createVariable((int)1, (double)y);
                for (double z = 0.0; z > -2.0; z -= 0.2) {
                    SparseGradient sgZ = SparseGradient.createVariable((int)2, (double)z);
                    SparseGradient sg = sgZ.linearCombination(1.0, sgX, 5.0, sgX.multiply(sgY), -2.0, sgZ, 1.0, sgZ.linearCombination(8.0, sgZ.multiply(sgX), -1.0, sgY).pow(3));
                    double f = x + 5.0 * x * y - 2.0 * z + FastMath.pow((double)(8.0 * z * x - y), (int)3);
                    Assert.assertEquals((double)f, (double)sg.getValue(), (double)FastMath.abs((double)(epsilon * f)));
                    double dfdx = 1.0 + 5.0 * y + 24.0 * z * FastMath.pow((double)(8.0 * z * x - y), (int)2);
                    Assert.assertEquals((double)dfdx, (double)sg.getDerivative(0), (double)FastMath.abs((double)(epsilon * dfdx)));
                }
            }
        }
    }

    @Test
    public void testCompositionOneVariableX() {
        double epsilon = 1.0E-13;
        for (double x = 0.1; x < 1.2; x += 0.1) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            for (double y = 0.1; y < 1.2; y += 0.1) {
                SparseGradient sgY = SparseGradient.createConstant((double)y);
                SparseGradient f = sgX.divide(sgY).sqrt();
                double f0 = FastMath.sqrt((double)(x / y));
                Assert.assertEquals((double)f0, (double)f.getValue(), (double)FastMath.abs((double)(epsilon * f0)));
                double f1 = 1.0 / (2.0 * FastMath.sqrt((double)(x * y)));
                Assert.assertEquals((double)f1, (double)f.getDerivative(0), (double)FastMath.abs((double)(epsilon * f1)));
            }
        }
    }

    @Test
    public void testTrigo() {
        double epsilon = 2.0E-12;
        for (double x = 0.1; x < 1.2; x += 0.1) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            for (double y = 0.1; y < 1.2; y += 0.1) {
                SparseGradient sgY = SparseGradient.createVariable((int)1, (double)y);
                for (double z = 0.1; z < 1.2; z += 0.1) {
                    SparseGradient sgZ = SparseGradient.createVariable((int)2, (double)z);
                    SparseGradient f = sgX.divide(sgY.cos().add(sgZ.tan())).sin();
                    double a = FastMath.cos((double)y) + FastMath.tan((double)z);
                    double f0 = FastMath.sin((double)(x / a));
                    Assert.assertEquals((double)f0, (double)f.getValue(), (double)FastMath.abs((double)(epsilon * f0)));
                    double dfdx = FastMath.cos((double)(x / a)) / a;
                    Assert.assertEquals((double)dfdx, (double)f.getDerivative(0), (double)FastMath.abs((double)(epsilon * dfdx)));
                    double dfdy = x * FastMath.sin((double)y) * dfdx / a;
                    Assert.assertEquals((double)dfdy, (double)f.getDerivative(1), (double)FastMath.abs((double)(epsilon * dfdy)));
                    double cz = FastMath.cos((double)z);
                    double cz2 = cz * cz;
                    double dfdz = -x * dfdx / (a * cz2);
                    Assert.assertEquals((double)dfdz, (double)f.getDerivative(2), (double)FastMath.abs((double)(epsilon * dfdz)));
                }
            }
        }
    }

    @Test
    public void testSqrtDefinition() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient sqrt1 = sgX.pow(0.5);
            SparseGradient sqrt2 = sgX.sqrt();
            SparseGradient zero = sqrt1.subtract(sqrt2);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testRootNSingularity() {
        for (int n = 2; n < 10; ++n) {
            SparseGradient sgZero = SparseGradient.createVariable((int)0, (double)0.0);
            SparseGradient rootN = sgZero.rootN(n);
            Assert.assertEquals((double)0.0, (double)rootN.getValue(), (double)1.0E-5);
            Assert.assertTrue((boolean)Double.isInfinite(rootN.getDerivative(0)));
            Assert.assertTrue((rootN.getDerivative(0) > 0.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSqrtPow2() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient rebuiltX = sgX.multiply(sgX).sqrt();
            SparseGradient zero = rebuiltX.subtract(sgX);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testCbrtDefinition() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient cbrt1 = sgX.pow(0.3333333333333333);
            SparseGradient cbrt2 = sgX.cbrt();
            SparseGradient zero = cbrt1.subtract(cbrt2);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testCbrtPow3() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient rebuiltX = sgX.multiply(sgX.multiply(sgX)).cbrt();
            SparseGradient zero = rebuiltX.subtract(sgX);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testPowReciprocalPow() {
        for (double x = 0.1; x < 1.2; x += 0.01) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            for (double y = 0.1; y < 1.2; y += 0.01) {
                SparseGradient sgY = SparseGradient.createVariable((int)1, (double)y);
                SparseGradient rebuiltX = sgX.pow(sgY).pow(sgY.reciprocal());
                SparseGradient zero = rebuiltX.subtract(sgX);
                this.checkF0F1(zero, 0.0, 0.0, 0.0);
            }
        }
    }

    @Test
    public void testHypotDefinition() {
        for (double x = -1.7; x < 2.0; x += 0.2) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            for (double y = -1.7; y < 2.0; y += 0.2) {
                SparseGradient sgY = SparseGradient.createVariable((int)1, (double)y);
                SparseGradient hypot = SparseGradient.hypot((SparseGradient)sgY, (SparseGradient)sgX);
                SparseGradient ref = sgX.multiply(sgX).add(sgY.multiply(sgY)).sqrt();
                SparseGradient zero = hypot.subtract(ref);
                this.checkF0F1(zero, 0.0, 0.0, 0.0);
            }
        }
    }

    @Test
    public void testHypotNoOverflow() {
        SparseGradient sgX = SparseGradient.createVariable((int)0, (double)3.0E250);
        SparseGradient sgY = SparseGradient.createVariable((int)1, (double)-4.0E250);
        SparseGradient hypot = SparseGradient.hypot((SparseGradient)sgX, (SparseGradient)sgY);
        Assert.assertEquals((double)5.0E250, (double)hypot.getValue(), (double)1.0E235);
        Assert.assertEquals((double)(sgX.getValue() / hypot.getValue()), (double)hypot.getDerivative(0), (double)1.0E-10);
        Assert.assertEquals((double)(sgY.getValue() / hypot.getValue()), (double)hypot.getDerivative(1), (double)1.0E-10);
        SparseGradient sqrt = sgX.multiply(sgX).add(sgY.multiply(sgY)).sqrt();
        Assert.assertTrue((boolean)Double.isInfinite(sqrt.getValue()));
    }

    @Test
    public void testHypotNeglectible() {
        SparseGradient sgSmall = SparseGradient.createVariable((int)0, (double)3.0E-10);
        SparseGradient sgLarge = SparseGradient.createVariable((int)1, (double)-4.0E25);
        Assert.assertEquals((double)sgLarge.abs().getValue(), (double)SparseGradient.hypot((SparseGradient)sgSmall, (SparseGradient)sgLarge).getValue(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)SparseGradient.hypot((SparseGradient)sgSmall, (SparseGradient)sgLarge).getDerivative(0), (double)1.0E-10);
        Assert.assertEquals((double)-1.0, (double)SparseGradient.hypot((SparseGradient)sgSmall, (SparseGradient)sgLarge).getDerivative(1), (double)1.0E-10);
        Assert.assertEquals((double)sgLarge.abs().getValue(), (double)SparseGradient.hypot((SparseGradient)sgLarge, (SparseGradient)sgSmall).getValue(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)SparseGradient.hypot((SparseGradient)sgLarge, (SparseGradient)sgSmall).getDerivative(0), (double)1.0E-10);
        Assert.assertEquals((double)-1.0, (double)SparseGradient.hypot((SparseGradient)sgLarge, (SparseGradient)sgSmall).getDerivative(1), (double)1.0E-10);
    }

    @Test
    public void testHypotSpecial() {
        Assert.assertTrue((boolean)Double.isNaN(SparseGradient.hypot((SparseGradient)SparseGradient.createVariable((int)0, (double)Double.NaN), (SparseGradient)SparseGradient.createVariable((int)0, (double)3.0E250)).getValue()));
        Assert.assertTrue((boolean)Double.isNaN(SparseGradient.hypot((SparseGradient)SparseGradient.createVariable((int)0, (double)3.0E250), (SparseGradient)SparseGradient.createVariable((int)0, (double)Double.NaN)).getValue()));
        Assert.assertTrue((boolean)Double.isInfinite(SparseGradient.hypot((SparseGradient)SparseGradient.createVariable((int)0, (double)Double.POSITIVE_INFINITY), (SparseGradient)SparseGradient.createVariable((int)0, (double)3.0E250)).getValue()));
        Assert.assertTrue((boolean)Double.isInfinite(SparseGradient.hypot((SparseGradient)SparseGradient.createVariable((int)0, (double)3.0E250), (SparseGradient)SparseGradient.createVariable((int)0, (double)Double.POSITIVE_INFINITY)).getValue()));
    }

    @Test
    public void testPrimitiveRemainder() {
        for (double x = -1.7; x < 2.0; x += 0.2) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            for (double y = -1.7; y < 2.0; y += 0.2) {
                SparseGradient remainder = sgX.remainder(y);
                SparseGradient ref = sgX.subtract(x - FastMath.IEEEremainder((double)x, (double)y));
                SparseGradient zero = remainder.subtract(ref);
                this.checkF0F1(zero, 0.0, 0.0, 0.0);
            }
        }
    }

    @Test
    public void testRemainder() {
        for (double x = -1.7; x < 2.0; x += 0.2) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            for (double y = -1.7; y < 2.0; y += 0.2) {
                SparseGradient sgY = SparseGradient.createVariable((int)1, (double)y);
                SparseGradient remainder = sgX.remainder(sgY);
                SparseGradient ref = sgX.subtract(sgY.multiply((x - FastMath.IEEEremainder((double)x, (double)y)) / y));
                SparseGradient zero = remainder.subtract(ref);
                this.checkF0F1(zero, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    @Test
    public void testExp() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            double refExp = FastMath.exp((double)x);
            this.checkF0F1(SparseGradient.createVariable((int)0, (double)x).exp(), refExp, refExp);
        }
    }

    @Test
    public void testExpm1Definition() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient expm11 = sgX.expm1();
            SparseGradient expm12 = sgX.exp().subtract((SparseGradient)sgX.getField().getOne());
            SparseGradient zero = expm11.subtract(expm12);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Override
    @Test
    public void testLog() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            this.checkF0F1(SparseGradient.createVariable((int)0, (double)x).log(), FastMath.log((double)x), 1.0 / x);
        }
    }

    @Test
    public void testLog1pDefinition() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient log1p1 = sgX.log1p();
            SparseGradient log1p2 = sgX.add((SparseGradient)sgX.getField().getOne()).log();
            SparseGradient zero = log1p1.subtract(log1p2);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testLog10Definition() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient log101 = sgX.log10();
            SparseGradient log102 = sgX.log().divide(FastMath.log((double)10.0));
            SparseGradient zero = log101.subtract(log102);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testLogExp() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient rebuiltX = sgX.exp().log();
            SparseGradient zero = rebuiltX.subtract(sgX);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testLog1pExpm1() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient rebuiltX = sgX.expm1().log1p();
            SparseGradient zero = rebuiltX.subtract(sgX);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testLog10Power() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient rebuiltX = SparseGradient.pow((double)10.0, (SparseGradient)sgX).log10();
            SparseGradient zero = rebuiltX.subtract(sgX);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testSinCos() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient sin = sgX.sin();
            SparseGradient cos = sgX.cos();
            double s = FastMath.sin((double)x);
            double c = FastMath.cos((double)x);
            this.checkF0F1(sin, s, c);
            this.checkF0F1(cos, c, -s);
        }
    }

    @Test
    public void testSinAsin() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient rebuiltX = sgX.sin().asin();
            SparseGradient zero = rebuiltX.subtract(sgX);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testCosAcos() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient rebuiltX = sgX.cos().acos();
            SparseGradient zero = rebuiltX.subtract(sgX);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testTanAtan() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient rebuiltX = sgX.tan().atan();
            SparseGradient zero = rebuiltX.subtract(sgX);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testTangentDefinition() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient tan1 = sgX.sin().divide(sgX.cos());
            SparseGradient tan2 = sgX.tan();
            SparseGradient zero = tan1.subtract(tan2);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Override
    @Test
    public void testAtan2() {
        for (double x = -1.7; x < 2.0; x += 0.2) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            for (double y = -1.7; y < 2.0; y += 0.2) {
                SparseGradient sgY = SparseGradient.createVariable((int)1, (double)y);
                SparseGradient atan2 = SparseGradient.atan2((SparseGradient)sgY, (SparseGradient)sgX);
                SparseGradient ref = sgY.divide(sgX).atan();
                if (x < 0.0) {
                    ref = y < 0.0 ? ref.subtract(Math.PI) : ref.add(Math.PI);
                }
                SparseGradient zero = atan2.subtract(ref);
                this.checkF0F1(zero, 0.0, 0.0);
            }
        }
    }

    @Test
    public void testAtan2SpecialCases() {
        SparseGradient pp = SparseGradient.atan2((SparseGradient)SparseGradient.createVariable((int)1, (double)0.0), (SparseGradient)SparseGradient.createVariable((int)1, (double)0.0));
        Assert.assertEquals((double)0.0, (double)pp.getValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)FastMath.copySign((double)1.0, (double)pp.getValue()), (double)1.0E-15);
        SparseGradient pn = SparseGradient.atan2((SparseGradient)SparseGradient.createVariable((int)1, (double)0.0), (SparseGradient)SparseGradient.createVariable((int)1, (double)-0.0));
        Assert.assertEquals((double)Math.PI, (double)pn.getValue(), (double)1.0E-15);
        SparseGradient np = SparseGradient.atan2((SparseGradient)SparseGradient.createVariable((int)1, (double)-0.0), (SparseGradient)SparseGradient.createVariable((int)1, (double)0.0));
        Assert.assertEquals((double)0.0, (double)np.getValue(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)FastMath.copySign((double)1.0, (double)np.getValue()), (double)1.0E-15);
        SparseGradient nn = SparseGradient.atan2((SparseGradient)SparseGradient.createVariable((int)1, (double)-0.0), (SparseGradient)SparseGradient.createVariable((int)1, (double)-0.0));
        Assert.assertEquals((double)(-Math.PI), (double)nn.getValue(), (double)1.0E-15);
    }

    @Test
    public void testSinhDefinition() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient sinh1 = sgX.exp().subtract(sgX.exp().reciprocal()).multiply(0.5);
            SparseGradient sinh2 = sgX.sinh();
            SparseGradient zero = sinh1.subtract(sinh2);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testCoshDefinition() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient cosh1 = sgX.exp().add(sgX.exp().reciprocal()).multiply(0.5);
            SparseGradient cosh2 = sgX.cosh();
            SparseGradient zero = cosh1.subtract(cosh2);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testTanhDefinition() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient tanh1 = sgX.exp().subtract(sgX.exp().reciprocal()).divide(sgX.exp().add(sgX.exp().reciprocal()));
            SparseGradient tanh2 = sgX.tanh();
            SparseGradient zero = tanh1.subtract(tanh2);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testSinhAsinh() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient rebuiltX = sgX.sinh().asinh();
            SparseGradient zero = rebuiltX.subtract(sgX);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testCoshAcosh() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient rebuiltX = sgX.cosh().acosh();
            SparseGradient zero = rebuiltX.subtract(sgX);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testTanhAtanh() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient rebuiltX = sgX.tanh().atanh();
            SparseGradient zero = rebuiltX.subtract(sgX);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testCompositionOneVariableY() {
        for (double x = 0.1; x < 1.2; x += 0.1) {
            SparseGradient sgX = SparseGradient.createConstant((double)x);
            for (double y = 0.1; y < 1.2; y += 0.1) {
                SparseGradient sgY = SparseGradient.createVariable((int)0, (double)y);
                SparseGradient f = sgX.divide(sgY).sqrt();
                double f0 = FastMath.sqrt((double)(x / y));
                double f1 = -x / (2.0 * y * y * f0);
                this.checkF0F1(f, f0, f1);
            }
        }
    }

    @Test
    public void testTaylorPolynomial() {
        for (double x = 0.0; x < 1.2; x += 0.1) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            for (double y = 0.0; y < 1.2; y += 0.2) {
                SparseGradient sgY = SparseGradient.createVariable((int)1, (double)y);
                for (double z = 0.0; z < 1.2; z += 0.2) {
                    SparseGradient sgZ = SparseGradient.createVariable((int)2, (double)z);
                    SparseGradient f = sgX.multiply(3).add(sgZ.multiply(-2)).add(sgY.multiply(5));
                    for (double dx = -0.2; dx < 0.2; dx += 0.2) {
                        for (double dy = -0.2; dy < 0.2; dy += 0.1) {
                            for (double dz = -0.2; dz < 0.2; dz += 0.1) {
                                double ref = 3.0 * (x + dx) + 5.0 * (y + dy) - 2.0 * (z + dz);
                                Assert.assertEquals((double)ref, (double)f.taylor(new double[]{dx, dy, dz}), (double)3.0E-15);
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testTaylorAtan2() {
        double x0 = 0.1;
        double y0 = -0.3;
        SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x0);
        SparseGradient sgY = SparseGradient.createVariable((int)1, (double)y0);
        SparseGradient atan2 = SparseGradient.atan2((SparseGradient)sgY, (SparseGradient)sgX);
        double maxError = 0.0;
        for (double dx = -0.05; dx < 0.05; dx += 0.001) {
            for (double dy = -0.05; dy < 0.05; dy += 0.001) {
                double ref = FastMath.atan2((double)(y0 + dy), (double)(x0 + dx));
                maxError = FastMath.max((double)maxError, (double)FastMath.abs((double)(ref - atan2.taylor(new double[]{dx, dy}))));
            }
        }
        double expectedError = 0.0241;
        Assert.assertEquals((double)expectedError, (double)maxError, (double)(0.01 * expectedError));
    }

    @Override
    @Test
    public void testAbs() {
        SparseGradient minusOne = SparseGradient.createVariable((int)0, (double)-1.0);
        Assert.assertEquals((double)1.0, (double)minusOne.abs().getValue(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)minusOne.abs().getDerivative(0), (double)1.0E-15);
        SparseGradient plusOne = SparseGradient.createVariable((int)0, (double)1.0);
        Assert.assertEquals((double)1.0, (double)plusOne.abs().getValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)plusOne.abs().getDerivative(0), (double)1.0E-15);
        SparseGradient minusZero = SparseGradient.createVariable((int)0, (double)-0.0);
        Assert.assertEquals((double)0.0, (double)minusZero.abs().getValue(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)minusZero.abs().getDerivative(0), (double)1.0E-15);
        SparseGradient plusZero = SparseGradient.createVariable((int)0, (double)0.0);
        Assert.assertEquals((double)0.0, (double)plusZero.abs().getValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)plusZero.abs().getDerivative(0), (double)1.0E-15);
    }

    @Override
    @Test
    public void testSignum() {
        SparseGradient minusOne = SparseGradient.createVariable((int)0, (double)-1.0);
        Assert.assertEquals((double)-1.0, (double)minusOne.signum().getValue(), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)minusOne.signum().getDerivative(0), (double)1.0E-15);
        SparseGradient plusOne = SparseGradient.createVariable((int)0, (double)1.0);
        Assert.assertEquals((double)1.0, (double)plusOne.signum().getValue(), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)plusOne.signum().getDerivative(0), (double)1.0E-15);
        SparseGradient minusZero = SparseGradient.createVariable((int)0, (double)-0.0);
        Assert.assertEquals((double)-0.0, (double)minusZero.signum().getValue(), (double)1.0E-15);
        Assert.assertTrue((Double.doubleToLongBits(minusZero.signum().getValue()) < 0L ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)minusZero.signum().getDerivative(0), (double)1.0E-15);
        SparseGradient plusZero = SparseGradient.createVariable((int)0, (double)0.0);
        Assert.assertEquals((double)0.0, (double)plusZero.signum().getValue(), (double)1.0E-15);
        Assert.assertTrue((Double.doubleToLongBits(plusZero.signum().getValue()) == 0L ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)plusZero.signum().getDerivative(0), (double)1.0E-15);
    }

    @Test
    public void testCeilFloorRintLong() {
        SparseGradient x = SparseGradient.createVariable((int)0, (double)-1.5);
        Assert.assertEquals((double)-1.5, (double)x.getValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)x.getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)x.ceil().getValue(), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)x.ceil().getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)-2.0, (double)x.floor().getValue(), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)x.floor().getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)-2.0, (double)x.rint().getValue(), (double)1.0E-15);
        Assert.assertEquals((double)0.0, (double)x.rint().getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)-2.0, (double)x.subtract((SparseGradient)x.getField().getOne()).rint().getValue(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)x.round(), (double)1.0E-15);
    }

    @Test
    public void testCopySign() {
        SparseGradient minusOne = SparseGradient.createVariable((int)0, (double)-1.0);
        Assert.assertEquals((double)1.0, (double)minusOne.copySign(1.0).getValue(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)minusOne.copySign(1.0).getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)minusOne.copySign(-1.0).getValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)minusOne.copySign(-1.0).getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)minusOne.copySign(0.0).getValue(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)minusOne.copySign(0.0).getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)minusOne.copySign(-0.0).getValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)minusOne.copySign(-0.0).getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)minusOne.copySign(Double.NaN).getValue(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)minusOne.copySign(Double.NaN).getDerivative(0), (double)1.0E-15);
        SparseGradient plusOne = SparseGradient.createVariable((int)0, (double)1.0);
        Assert.assertEquals((double)1.0, (double)plusOne.copySign(1.0).getValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)plusOne.copySign(1.0).getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)plusOne.copySign(-1.0).getValue(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)plusOne.copySign(-1.0).getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)plusOne.copySign(0.0).getValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)plusOne.copySign(0.0).getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)plusOne.copySign(-0.0).getValue(), (double)1.0E-15);
        Assert.assertEquals((double)-1.0, (double)plusOne.copySign(-0.0).getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)plusOne.copySign(Double.NaN).getValue(), (double)1.0E-15);
        Assert.assertEquals((double)1.0, (double)plusOne.copySign(Double.NaN).getDerivative(0), (double)1.0E-15);
    }

    @Test
    public void testToDegreesDefinition() {
        double epsilon = 3.0E-16;
        for (int maxOrder = 0; maxOrder < 6; ++maxOrder) {
            for (double x = 0.1; x < 1.2; x += 0.001) {
                SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
                Assert.assertEquals((double)FastMath.toDegrees((double)x), (double)sgX.toDegrees().getValue(), (double)epsilon);
                Assert.assertEquals((double)57.29577951308232, (double)sgX.toDegrees().getDerivative(0), (double)epsilon);
            }
        }
    }

    @Test
    public void testToRadiansDefinition() {
        double epsilon = 3.0E-16;
        for (int maxOrder = 0; maxOrder < 6; ++maxOrder) {
            for (double x = 0.1; x < 1.2; x += 0.001) {
                SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
                Assert.assertEquals((double)FastMath.toRadians((double)x), (double)sgX.toRadians().getValue(), (double)epsilon);
                Assert.assertEquals((double)(Math.PI / 180), (double)sgX.toRadians().getDerivative(0), (double)epsilon);
            }
        }
    }

    @Test
    public void testDegRad() {
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient rebuiltX = sgX.toDegrees().toRadians();
            SparseGradient zero = rebuiltX.subtract(sgX);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testCompose() {
        PolynomialFunction poly = new PolynomialFunction(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0});
        for (double x = 0.1; x < 1.2; x += 0.001) {
            SparseGradient sgX = SparseGradient.createVariable((int)0, (double)x);
            SparseGradient sgY1 = (SparseGradient)sgX.getField().getZero();
            for (int i = poly.degree(); i >= 0; --i) {
                sgY1 = sgY1.multiply(sgX).add(poly.getCoefficients()[i]);
            }
            SparseGradient sgY2 = sgX.compose(poly.value(x), poly.derivative().value(x));
            SparseGradient zero = sgY1.subtract(sgY2);
            this.checkF0F1(zero, 0.0, 0.0);
        }
    }

    @Test
    public void testField() {
        SparseGradient x = SparseGradient.createVariable((int)0, (double)1.0);
        this.checkF0F1((SparseGradient)x.getField().getZero(), 0.0, 0.0, 0.0, 0.0);
        this.checkF0F1((SparseGradient)x.getField().getOne(), 1.0, 0.0, 0.0, 0.0);
        Assert.assertEquals(SparseGradient.class, (Object)x.getField().getRuntimeClass());
    }

    @Test
    public void testLinearCombination1DSDS() {
        SparseGradient[] a = new SparseGradient[]{SparseGradient.createVariable((int)0, (double)-4921140.837095533), SparseGradient.createVariable((int)1, (double)-2.1512094250440013E7), SparseGradient.createVariable((int)2, (double)-890093.2794263769)};
        SparseGradient[] b = new SparseGradient[]{SparseGradient.createVariable((int)3, (double)-2.7238580938724895E9), SparseGradient.createVariable((int)4, (double)-2.1696649213418756E9), SparseGradient.createVariable((int)5, (double)6.7496887088853004E10)};
        SparseGradient abSumInline = a[0].linearCombination(a[0], b[0], a[1], b[1], a[2], b[2]);
        SparseGradient abSumArray = a[0].linearCombination(a, b);
        Assert.assertEquals((double)abSumInline.getValue(), (double)abSumArray.getValue(), (double)1.0E-15);
        Assert.assertEquals((double)-1.8551294182586249, (double)abSumInline.getValue(), (double)1.0E-15);
        Assert.assertEquals((double)b[0].getValue(), (double)abSumInline.getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)b[1].getValue(), (double)abSumInline.getDerivative(1), (double)1.0E-15);
        Assert.assertEquals((double)b[2].getValue(), (double)abSumInline.getDerivative(2), (double)1.0E-15);
        Assert.assertEquals((double)a[0].getValue(), (double)abSumInline.getDerivative(3), (double)1.0E-15);
        Assert.assertEquals((double)a[1].getValue(), (double)abSumInline.getDerivative(4), (double)1.0E-15);
        Assert.assertEquals((double)a[2].getValue(), (double)abSumInline.getDerivative(5), (double)1.0E-15);
    }

    @Test
    public void testLinearCombination1DoubleDS() {
        double[] a = new double[]{-4921140.837095533, -2.1512094250440013E7, -890093.2794263769};
        SparseGradient[] b = new SparseGradient[]{SparseGradient.createVariable((int)0, (double)-2.7238580938724895E9), SparseGradient.createVariable((int)1, (double)-2.1696649213418756E9), SparseGradient.createVariable((int)2, (double)6.7496887088853004E10)};
        SparseGradient abSumInline = b[0].linearCombination(a[0], b[0], a[1], b[1], a[2], b[2]);
        SparseGradient abSumArray = b[0].linearCombination(a, b);
        Assert.assertEquals((double)abSumInline.getValue(), (double)abSumArray.getValue(), (double)1.0E-15);
        Assert.assertEquals((double)-1.8551294182586249, (double)abSumInline.getValue(), (double)1.0E-15);
        Assert.assertEquals((double)a[0], (double)abSumInline.getDerivative(0), (double)1.0E-15);
        Assert.assertEquals((double)a[1], (double)abSumInline.getDerivative(1), (double)1.0E-15);
        Assert.assertEquals((double)a[2], (double)abSumInline.getDerivative(2), (double)1.0E-15);
    }

    @Test
    public void testLinearCombination2DSDS() {
        Well1024a random = new Well1024a(-4129932346759143663L);
        for (int i = 0; i < 10000; ++i) {
            SparseGradient[] u = new SparseGradient[4];
            SparseGradient[] v = new SparseGradient[4];
            for (int j = 0; j < u.length; ++j) {
                u[j] = SparseGradient.createVariable((int)j, (double)(1.0E17 * random.nextDouble()));
                v[j] = SparseGradient.createConstant((double)(1.0E17 * random.nextDouble()));
            }
            SparseGradient lin = u[0].linearCombination(u[0], v[0], u[1], v[1]);
            double ref = u[0].getValue() * v[0].getValue() + u[1].getValue() * v[1].getValue();
            Assert.assertEquals((double)ref, (double)lin.getValue(), (double)(1.0E-15 * FastMath.abs((double)ref)));
            Assert.assertEquals((double)v[0].getValue(), (double)lin.getDerivative(0), (double)(1.0E-15 * FastMath.abs((double)v[0].getValue())));
            Assert.assertEquals((double)v[1].getValue(), (double)lin.getDerivative(1), (double)(1.0E-15 * FastMath.abs((double)v[1].getValue())));
            lin = u[0].linearCombination(u[0], v[0], u[1], v[1], u[2], v[2]);
            ref = u[0].getValue() * v[0].getValue() + u[1].getValue() * v[1].getValue() + u[2].getValue() * v[2].getValue();
            Assert.assertEquals((double)ref, (double)lin.getValue(), (double)(1.0E-15 * FastMath.abs((double)ref)));
            Assert.assertEquals((double)v[0].getValue(), (double)lin.getDerivative(0), (double)(1.0E-15 * FastMath.abs((double)v[0].getValue())));
            Assert.assertEquals((double)v[1].getValue(), (double)lin.getDerivative(1), (double)(1.0E-15 * FastMath.abs((double)v[1].getValue())));
            Assert.assertEquals((double)v[2].getValue(), (double)lin.getDerivative(2), (double)(1.0E-15 * FastMath.abs((double)v[2].getValue())));
            lin = u[0].linearCombination(u[0], v[0], u[1], v[1], u[2], v[2], u[3], v[3]);
            ref = u[0].getValue() * v[0].getValue() + u[1].getValue() * v[1].getValue() + u[2].getValue() * v[2].getValue() + u[3].getValue() * v[3].getValue();
            Assert.assertEquals((double)ref, (double)lin.getValue(), (double)(1.0E-15 * FastMath.abs((double)ref)));
            Assert.assertEquals((double)v[0].getValue(), (double)lin.getDerivative(0), (double)(1.0E-15 * FastMath.abs((double)v[0].getValue())));
            Assert.assertEquals((double)v[1].getValue(), (double)lin.getDerivative(1), (double)(1.0E-15 * FastMath.abs((double)v[1].getValue())));
            Assert.assertEquals((double)v[2].getValue(), (double)lin.getDerivative(2), (double)(1.0E-15 * FastMath.abs((double)v[2].getValue())));
            Assert.assertEquals((double)v[3].getValue(), (double)lin.getDerivative(3), (double)(1.0E-15 * FastMath.abs((double)v[3].getValue())));
        }
    }

    @Test
    public void testLinearCombination2DoubleDS() {
        Well1024a random = new Well1024a(-4129932346759143663L);
        for (int i = 0; i < 10000; ++i) {
            double[] u = new double[4];
            SparseGradient[] v = new SparseGradient[4];
            for (int j = 0; j < u.length; ++j) {
                u[j] = 1.0E17 * random.nextDouble();
                v[j] = SparseGradient.createVariable((int)j, (double)(1.0E17 * random.nextDouble()));
            }
            SparseGradient lin = v[0].linearCombination(u[0], v[0], u[1], v[1]);
            double ref = u[0] * v[0].getValue() + u[1] * v[1].getValue();
            Assert.assertEquals((double)ref, (double)lin.getValue(), (double)(1.0E-15 * FastMath.abs((double)ref)));
            Assert.assertEquals((double)u[0], (double)lin.getDerivative(0), (double)(1.0E-15 * FastMath.abs((double)v[0].getValue())));
            Assert.assertEquals((double)u[1], (double)lin.getDerivative(1), (double)(1.0E-15 * FastMath.abs((double)v[1].getValue())));
            lin = v[0].linearCombination(u[0], v[0], u[1], v[1], u[2], v[2]);
            ref = u[0] * v[0].getValue() + u[1] * v[1].getValue() + u[2] * v[2].getValue();
            Assert.assertEquals((double)ref, (double)lin.getValue(), (double)(1.0E-15 * FastMath.abs((double)ref)));
            Assert.assertEquals((double)u[0], (double)lin.getDerivative(0), (double)(1.0E-15 * FastMath.abs((double)v[0].getValue())));
            Assert.assertEquals((double)u[1], (double)lin.getDerivative(1), (double)(1.0E-15 * FastMath.abs((double)v[1].getValue())));
            Assert.assertEquals((double)u[2], (double)lin.getDerivative(2), (double)(1.0E-15 * FastMath.abs((double)v[2].getValue())));
            lin = v[0].linearCombination(u[0], v[0], u[1], v[1], u[2], v[2], u[3], v[3]);
            ref = u[0] * v[0].getValue() + u[1] * v[1].getValue() + u[2] * v[2].getValue() + u[3] * v[3].getValue();
            Assert.assertEquals((double)ref, (double)lin.getValue(), (double)(1.0E-15 * FastMath.abs((double)ref)));
            Assert.assertEquals((double)u[0], (double)lin.getDerivative(0), (double)(1.0E-15 * FastMath.abs((double)v[0].getValue())));
            Assert.assertEquals((double)u[1], (double)lin.getDerivative(1), (double)(1.0E-15 * FastMath.abs((double)v[1].getValue())));
            Assert.assertEquals((double)u[2], (double)lin.getDerivative(2), (double)(1.0E-15 * FastMath.abs((double)v[2].getValue())));
            Assert.assertEquals((double)u[3], (double)lin.getDerivative(3), (double)(1.0E-15 * FastMath.abs((double)v[3].getValue())));
        }
    }

    @Test
    public void testSerialization() {
        SparseGradient a = SparseGradient.createVariable((int)0, (double)1.3);
        SparseGradient b = (SparseGradient)TestUtils.serializeAndRecover(a);
        Assert.assertEquals((Object)a, (Object)b);
    }

    private void checkF0F1(SparseGradient sg, double value, double ... derivatives) {
        Assert.assertEquals((double)value, (double)sg.getValue(), (double)1.0E-13);
        for (int i = 0; i < derivatives.length; ++i) {
            Assert.assertEquals((double)derivatives[i], (double)sg.getDerivative(i), (double)1.0E-13);
        }
    }
}

