/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration.gauss;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Constant;
import org.apache.commons.math3.analysis.integration.gauss.GaussIntegrator;
import org.apache.commons.math3.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class GaussIntegratorTest {
    @Test
    public void testGetWeights() {
        double[] points = new double[]{0.0, 1.2, 3.4};
        double[] weights = new double[]{9.8, 7.6, 5.4};
        GaussIntegrator integrator = new GaussIntegrator(new Pair((Object)points, (Object)weights));
        Assert.assertEquals((long)weights.length, (long)integrator.getNumberOfPoints());
        for (int i = 0; i < integrator.getNumberOfPoints(); ++i) {
            Assert.assertEquals((double)weights[i], (double)integrator.getWeight(i), (double)0.0);
        }
    }

    @Test
    public void testGetPoints() {
        double[] points = new double[]{0.0, 1.2, 3.4};
        double[] weights = new double[]{9.8, 7.6, 5.4};
        GaussIntegrator integrator = new GaussIntegrator(new Pair((Object)points, (Object)weights));
        Assert.assertEquals((long)points.length, (long)integrator.getNumberOfPoints());
        for (int i = 0; i < integrator.getNumberOfPoints(); ++i) {
            Assert.assertEquals((double)points[i], (double)integrator.getPoint(i), (double)0.0);
        }
    }

    @Test
    public void testIntegrate() {
        double[] points = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        double[] weights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        GaussIntegrator integrator = new GaussIntegrator(new Pair((Object)points, (Object)weights));
        double val = 123.456;
        Constant c = new Constant(123.456);
        double s = integrator.integrate((UnivariateFunction)c);
        Assert.assertEquals((double)((double)points.length * 123.456), (double)s, (double)0.0);
    }
}

