/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicInterpolatingFunction;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public final class BicubicInterpolatingFunctionTest {
    @Test
    public void testPreconditions() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.5};
        double[][] zval = new double[xval.length][yval.length];
        BicubicInterpolatingFunction bcf = new BicubicInterpolatingFunction(xval, yval, zval, zval, zval, zval);
        double[] wxval = new double[]{3.0, 2.0, 5.0, 6.5};
        try {
            bcf = new BicubicInterpolatingFunction(wxval, yval, zval, zval, zval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[] wyval = new double[]{-4.0, -1.0, -1.0, 2.5};
        try {
            bcf = new BicubicInterpolatingFunction(xval, wyval, zval, zval, zval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[][] wzval = new double[xval.length][yval.length - 1];
        try {
            bcf = new BicubicInterpolatingFunction(xval, yval, wzval, zval, zval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            bcf = new BicubicInterpolatingFunction(xval, yval, zval, wzval, zval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            bcf = new BicubicInterpolatingFunction(xval, yval, zval, zval, wzval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            bcf = new BicubicInterpolatingFunction(xval, yval, zval, zval, zval, wzval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        wzval = new double[xval.length - 1][yval.length];
        try {
            bcf = new BicubicInterpolatingFunction(xval, yval, wzval, zval, zval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            bcf = new BicubicInterpolatingFunction(xval, yval, zval, wzval, zval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            bcf = new BicubicInterpolatingFunction(xval, yval, zval, zval, wzval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            bcf = new BicubicInterpolatingFunction(xval, yval, zval, zval, zval, wzval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testIsValidPoint() {
        double[][] f;
        double xMin = -12.0;
        double xMax = 34.0;
        double yMin = 5.0;
        double yMax = 67.0;
        double[] xval = new double[]{-12.0, 34.0};
        double[] yval = new double[]{5.0, 67.0};
        double[][] dFdX = f = new double[][]{{1.0, 2.0}, {3.0, 4.0}};
        double[][] dFdY = f;
        double[][] dFdXdY = f;
        BicubicInterpolatingFunction bcf = new BicubicInterpolatingFunction(xval, yval, (double[][])f, (double[][])dFdX, (double[][])dFdY, (double[][])dFdXdY);
        double x = -12.0;
        double y = 5.0;
        Assert.assertTrue((boolean)bcf.isValidPoint(x, y));
        bcf.value(x, y);
        x = 34.0;
        y = 67.0;
        Assert.assertTrue((boolean)bcf.isValidPoint(x, y));
        bcf.value(x, y);
        double xRange = 46.0;
        double yRange = 62.0;
        x = 1.5294117647058822;
        y = 56.66666666666667;
        Assert.assertTrue((boolean)bcf.isValidPoint(x, y));
        bcf.value(x, y);
        double small = 1.0E-8;
        x = -12.00000001;
        y = 67.0;
        Assert.assertFalse((boolean)bcf.isValidPoint(x, y));
        try {
            bcf.value(x, y);
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        x = -12.0;
        y = 67.00000001;
        Assert.assertFalse((boolean)bcf.isValidPoint(x, y));
        try {
            bcf.value(x, y);
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testPlane() {
        int numberOfElements = 10;
        double minimumX = -10.0;
        double maximumX = 10.0;
        double minimumY = -10.0;
        double maximumY = 10.0;
        int numberOfSamples = 1000;
        double interpolationTolerance = 1.0E-15;
        double maxTolerance = 1.0E-14;
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x - 3.0 * y + 5.0;
            }
        };
        BivariateFunction dfdx = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0;
            }
        };
        BivariateFunction dfdy = new BivariateFunction(){

            public double value(double x, double y) {
                return -3.0;
            }
        };
        BivariateFunction d2fdxdy = new BivariateFunction(){

            public double value(double x, double y) {
                return 0.0;
            }
        };
        this.testInterpolation(-10.0, 10.0, -10.0, 10.0, 10, 1000, f, dfdx, dfdy, d2fdxdy, 1.0E-15, 1.0E-14, false);
    }

    @Test
    public void testParaboloid() {
        int numberOfElements = 10;
        double minimumX = -10.0;
        double maximumX = 10.0;
        double minimumY = -10.0;
        double maximumY = 10.0;
        int numberOfSamples = 1000;
        double interpolationTolerance = 2.0E-14;
        double maxTolerance = 1.0E-12;
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x * x - 3.0 * y * y + 4.0 * x * y - 5.0;
            }
        };
        BivariateFunction dfdx = new BivariateFunction(){

            public double value(double x, double y) {
                return 4.0 * (x + y);
            }
        };
        BivariateFunction dfdy = new BivariateFunction(){

            public double value(double x, double y) {
                return 4.0 * x - 6.0 * y;
            }
        };
        BivariateFunction d2fdxdy = new BivariateFunction(){

            public double value(double x, double y) {
                return 4.0;
            }
        };
        this.testInterpolation(-10.0, 10.0, -10.0, 10.0, 10, 1000, f, dfdx, dfdy, d2fdxdy, 2.0E-14, 1.0E-12, false);
    }

    private void testInterpolation(double minimumX, double maximumX, double minimumY, double maximumY, int numberOfElements, int numberOfSamples, BivariateFunction f, BivariateFunction dfdx, BivariateFunction dfdy, BivariateFunction d2fdxdy, double meanTolerance, double maxTolerance, boolean print) {
        double actual;
        double expected;
        double currentY;
        double currentX;
        double deltaX = (maximumX - minimumX) / (double)numberOfElements;
        double deltaY = (maximumY - minimumY) / (double)numberOfElements;
        double[] xValues = new double[numberOfElements];
        double[] yValues = new double[numberOfElements];
        double[][] zValues = new double[numberOfElements][numberOfElements];
        double[][] dzdx = new double[numberOfElements][numberOfElements];
        double[][] dzdy = new double[numberOfElements][numberOfElements];
        double[][] d2zdxdy = new double[numberOfElements][numberOfElements];
        for (int i = 0; i < numberOfElements; ++i) {
            xValues[i] = minimumX + deltaX * (double)i;
            double x = xValues[i];
            for (int j = 0; j < numberOfElements; ++j) {
                yValues[j] = minimumY + deltaY * (double)j;
                double y = yValues[j];
                zValues[i][j] = f.value(x, y);
                dzdx[i][j] = dfdx.value(x, y);
                dzdy[i][j] = dfdy.value(x, y);
                d2zdxdy[i][j] = d2fdxdy.value(x, y);
            }
        }
        BicubicInterpolatingFunction interpolation = new BicubicInterpolatingFunction(xValues, yValues, zValues, dzdx, dzdy, d2zdxdy);
        for (int i = 0; i < numberOfElements; ++i) {
            currentX = xValues[i];
            for (int j = 0; j < numberOfElements; ++j) {
                currentY = yValues[j];
                expected = f.value(currentX, currentY);
                actual = interpolation.value(currentX, currentY);
                Assert.assertTrue((String)("On data point: " + expected + " != " + actual), (boolean)Precision.equals((double)expected, (double)actual));
            }
        }
        Well19937c rng = new Well19937c(1234567L);
        UniformRealDistribution distX = new UniformRealDistribution((RandomGenerator)rng, xValues[0], xValues[xValues.length - 1]);
        UniformRealDistribution distY = new UniformRealDistribution((RandomGenerator)rng, yValues[0], yValues[yValues.length - 1]);
        double sumError = 0.0;
        for (int i = 0; i < numberOfSamples; ++i) {
            currentX = distX.sample();
            currentY = distY.sample();
            expected = f.value(currentX, currentY);
            if (print) {
                System.out.println(currentX + " " + currentY + " -> ");
            }
            actual = interpolation.value(currentX, currentY);
            sumError += FastMath.abs((double)(actual - expected));
            if (print) {
                System.out.println(actual + " (diff=" + (expected - actual) + ")");
            }
            Assert.assertEquals((double)expected, (double)actual, (double)maxTolerance);
        }
        double meanError = sumError / (double)numberOfSamples;
        Assert.assertEquals((double)0.0, (double)meanError, (double)meanTolerance);
    }
}

