/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.polynomials;

import java.util.Arrays;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.junit.Assert;
import org.junit.Test;

public class PolynomialSplineFunctionTest {
    protected double tolerance = 1.0E-12;
    protected PolynomialFunction[] polynomials = new PolynomialFunction[]{new PolynomialFunction(new double[]{0.0, 1.0, 1.0}), new PolynomialFunction(new double[]{2.0, 1.0, 1.0}), new PolynomialFunction(new double[]{4.0, 1.0, 1.0})};
    protected double[] knots = new double[]{-1.0, 0.0, 1.0, 2.0};
    protected PolynomialFunction dp = new PolynomialFunction(new double[]{1.0, 2.0});

    @Test
    public void testConstructor() {
        PolynomialSplineFunction spline = new PolynomialSplineFunction(this.knots, this.polynomials);
        Assert.assertTrue((boolean)Arrays.equals(this.knots, spline.getKnots()));
        Assert.assertEquals((double)1.0, (double)spline.getPolynomials()[0].getCoefficients()[2], (double)0.0);
        Assert.assertEquals((long)3L, (long)spline.getN());
        try {
            new PolynomialSplineFunction(new double[]{0.0}, this.polynomials);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            new PolynomialSplineFunction(new double[]{0.0, 1.0, 2.0, 3.0, 4.0}, this.polynomials);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            new PolynomialSplineFunction(new double[]{0.0, 1.0, 3.0, 2.0}, this.polynomials);
            Assert.fail((String)"Expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testValues() {
        int i;
        PolynomialSplineFunction spline = new PolynomialSplineFunction(this.knots, this.polynomials);
        UnivariateFunction dSpline = spline.derivative();
        double x = -1.0;
        int index = 0;
        for (i = 0; i < 10; ++i) {
            index = this.findKnot(this.knots, x += 0.25);
            Assert.assertEquals((String)("spline function evaluation failed for x=" + x), (double)this.polynomials[index].value(x - this.knots[index]), (double)spline.value(x), (double)this.tolerance);
            Assert.assertEquals((String)("spline derivative evaluation failed for x=" + x), (double)this.dp.value(x - this.knots[index]), (double)dSpline.value(x), (double)this.tolerance);
        }
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((String)("spline function evaluation failed for knot=" + this.knots[i]), (double)this.polynomials[i].value(0.0), (double)spline.value(this.knots[i]), (double)this.tolerance);
            Assert.assertEquals((String)("spline function evaluation failed for knot=" + this.knots[i]), (double)this.dp.value(0.0), (double)dSpline.value(this.knots[i]), (double)this.tolerance);
        }
        try {
            x = spline.value(-1.5);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            x = spline.value(2.5);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testIsValidPoint() {
        PolynomialSplineFunction spline = new PolynomialSplineFunction(this.knots, this.polynomials);
        double xMin = this.knots[0];
        double xMax = this.knots[this.knots.length - 1];
        double x = xMin;
        Assert.assertTrue((boolean)spline.isValidPoint(x));
        spline.value(x);
        x = xMax;
        Assert.assertTrue((boolean)spline.isValidPoint(x));
        spline.value(x);
        double xRange = xMax - xMin;
        x = xMin + xRange / 3.4;
        Assert.assertTrue((boolean)spline.isValidPoint(x));
        spline.value(x);
        double small = 1.0E-8;
        x = xMin - 1.0E-8;
        Assert.assertFalse((boolean)spline.isValidPoint(x));
        try {
            spline.value(x);
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    protected int findKnot(double[] knots, double x) {
        if (x < knots[0] || x >= knots[knots.length - 1]) {
            throw new OutOfRangeException((Number)x, (Number)knots[0], (Number)knots[knots.length - 1]);
        }
        for (int i = 0; i < knots.length; ++i) {
            if (!(knots[i] > x)) continue;
            return i - 1;
        }
        throw new MathIllegalStateException();
    }
}

