/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.QuinticFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.analysis.solvers.AllowedSolution;
import org.apache.commons.math3.analysis.solvers.BaseSecantSolverAbstractTest;
import org.apache.commons.math3.analysis.solvers.BracketingNthOrderBrentSolver;
import org.apache.commons.math3.analysis.solvers.NewtonRaphsonSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.junit.Assert;
import org.junit.Test;

public final class BracketingNthOrderBrentSolverTest
extends BaseSecantSolverAbstractTest {
    protected UnivariateSolver getSolver() {
        return new BracketingNthOrderBrentSolver();
    }

    protected int[] getQuinticEvalCounts() {
        return new int[]{1, 3, 8, 1, 9, 4, 8, 1, 12, 1, 16};
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testInsufficientOrder1() {
        new BracketingNthOrderBrentSolver(1.0E-10, 1);
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testInsufficientOrder2() {
        new BracketingNthOrderBrentSolver(1.0E-10, 1.0E-10, 1);
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testInsufficientOrder3() {
        new BracketingNthOrderBrentSolver(1.0E-10, 1.0E-10, 1.0E-10, 1);
    }

    @Test
    public void testConstructorsOK() {
        Assert.assertEquals((long)2L, (long)new BracketingNthOrderBrentSolver(1.0E-10, 2).getMaximalOrder());
        Assert.assertEquals((long)2L, (long)new BracketingNthOrderBrentSolver(1.0E-10, 1.0E-10, 2).getMaximalOrder());
        Assert.assertEquals((long)2L, (long)new BracketingNthOrderBrentSolver(1.0E-10, 1.0E-10, 1.0E-10, 2).getMaximalOrder());
    }

    @Test
    public void testConvergenceOnFunctionAccuracy() {
        BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(1.0E-12, 1.0E-10, 0.001, 3);
        QuinticFunction f = new QuinticFunction();
        double result = solver.solve(20, (UnivariateFunction)f, 0.2, 0.9, 0.4, AllowedSolution.BELOW_SIDE);
        Assert.assertEquals((double)0.0, (double)f.value(result), (double)solver.getFunctionValueAccuracy());
        Assert.assertTrue((f.value(result) <= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((result - 0.5 > solver.getAbsoluteAccuracy() ? 1 : 0) != 0);
        result = solver.solve(20, (UnivariateFunction)f, -0.9, -0.2, -0.4, AllowedSolution.ABOVE_SIDE);
        Assert.assertEquals((double)0.0, (double)f.value(result), (double)solver.getFunctionValueAccuracy());
        Assert.assertTrue((f.value(result) >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((result + 0.5 < -solver.getAbsoluteAccuracy() ? 1 : 0) != 0);
    }

    @Test
    public void testIssue716() {
        BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(1.0E-12, 1.0E-10, 1.0E-22, 5);
        UnivariateFunction sharpTurn = new UnivariateFunction(){

            public double value(double x) {
                return (2.0 * x + 1.0) / (1.0E9 * (x + 1.0));
            }
        };
        double result = solver.solve(100, sharpTurn, -0.9999999, 30.0, 15.0, AllowedSolution.RIGHT_SIDE);
        Assert.assertEquals((double)0.0, (double)sharpTurn.value(result), (double)solver.getFunctionValueAccuracy());
        Assert.assertTrue((sharpTurn.value(result) >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)-0.5, (double)result, (double)1.0E-10);
    }

    @Test
    public void testFasterThanNewton() {
        this.compare(new TestFunction(0.0, -2.0, 2.0){

            public DerivativeStructure value(DerivativeStructure x) {
                return x.sin().subtract(x.multiply(0.5));
            }
        });
        this.compare(new TestFunction(6.308777129972689, -5.0, 10.0){

            public DerivativeStructure value(DerivativeStructure x) {
                return x.pow(5).add(x).subtract(10000.0);
            }
        });
        this.compare(new TestFunction(9.633595562832696, 0.001, 10.0){

            public DerivativeStructure value(DerivativeStructure x) {
                return x.sqrt().subtract(x.reciprocal()).subtract(3.0);
            }
        });
        this.compare(new TestFunction(2.842438953784447, -5.0, 5.0){

            public DerivativeStructure value(DerivativeStructure x) {
                return x.exp().add(x).subtract(20.0);
            }
        });
        this.compare(new TestFunction(8.309432694231571, 0.001, 10.0){

            public DerivativeStructure value(DerivativeStructure x) {
                return x.log().add(x.sqrt()).subtract(5.0);
            }
        });
        this.compare(new TestFunction(1.465571231876768, -0.5, 1.5){

            public DerivativeStructure value(DerivativeStructure x) {
                return x.subtract(1.0).multiply(x).multiply(x).subtract(1.0);
            }
        });
    }

    private void compare(TestFunction f) {
        this.compare(f, f.getRoot(), f.getMin(), f.getMax());
    }

    private void compare(UnivariateDifferentiableFunction f, double root, double min, double max) {
        double resultB;
        double resultN;
        NewtonRaphsonSolver newton = new NewtonRaphsonSolver(1.0E-12);
        BracketingNthOrderBrentSolver bracketing = new BracketingNthOrderBrentSolver(1.0E-12, 1.0E-12, 1.0E-18, 5);
        try {
            resultN = newton.solve(100, f, min, max);
        }
        catch (TooManyEvaluationsException tmee) {
            resultN = Double.NaN;
        }
        try {
            resultB = bracketing.solve(100, (UnivariateFunction)f, min, max);
        }
        catch (TooManyEvaluationsException tmee) {
            resultB = Double.NaN;
        }
        Assert.assertEquals((double)root, (double)resultN, (double)newton.getAbsoluteAccuracy());
        Assert.assertEquals((double)root, (double)resultB, (double)bracketing.getAbsoluteAccuracy());
        int weightedBracketingEvaluations = bracketing.getEvaluations();
        int weightedNewtonEvaluations = 2 * newton.getEvaluations();
        Assert.assertTrue((weightedBracketingEvaluations < weightedNewtonEvaluations ? 1 : 0) != 0);
    }

    private static abstract class TestFunction
    implements UnivariateDifferentiableFunction {
        private final double root;
        private final double min;
        private final double max;

        protected TestFunction(double root, double min, double max) {
            this.root = root;
            this.min = min;
            this.max = max;
        }

        public double getRoot() {
            return this.root;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double value(double x) {
            return this.value(new DerivativeStructure(0, 0, x)).getValue();
        }

        public abstract DerivativeStructure value(DerivativeStructure var1);
    }
}

