/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.LevyDistribution;
import org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937a;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class LevyDistributionTest
extends RealDistributionAbstractTest {
    @Test
    public void testParameters() {
        LevyDistribution d = this.makeDistribution();
        Assert.assertEquals((double)1.2, (double)d.getLocation(), (double)Precision.EPSILON);
        Assert.assertEquals((double)0.4, (double)d.getScale(), (double)Precision.EPSILON);
    }

    @Test
    public void testSupport() {
        LevyDistribution d = this.makeDistribution();
        Assert.assertEquals((double)d.getLocation(), (double)d.getSupportLowerBound(), (double)Precision.EPSILON);
        Assert.assertTrue((boolean)Double.isInfinite(d.getSupportUpperBound()));
        Assert.assertTrue((boolean)d.isSupportConnected());
    }

    public LevyDistribution makeDistribution() {
        return new LevyDistribution((RandomGenerator)new Well19937a(-4204866253449861766L), 1.2, 0.4);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{1.2001, 1.21, 1.225, 1.25, 1.3, 1.9, 3.4, 5.6};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.0, 2.53962850749E-10, 6.33424836662E-5, 0.00467773498105, 0.0455002638964, 0.449691797969, 0.669815357599, 0.763024600553};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0, 5.20056373765E-7, 0.0214128361224, 0.413339707082, 1.07981933026, 0.323749319161, 0.0706032550094, 0.026122839884};
    }

    public double[] makeLogDensityTestValues() {
        return new double[]{-1987.561573341398, -14.46932862016, -3.843764717971, -0.883485488811, 0.076793740349, -1.127785768948, -2.650679030597, -3.644945255983};
    }
}

