/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.junit.Assert;
import org.junit.Test;

public class TDistributionTest
extends RealDistributionAbstractTest {
    public TDistribution makeDistribution() {
        return new TDistribution(5.0);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{-5.89342953136, -3.36492999891, -2.57058183564, -2.01504837333, -1.47588404882, 5.89342953136, 3.36492999891, 2.57058183564, 2.01504837333, 1.47588404882};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.001, 0.01, 0.025, 0.05, 0.1, 0.999, 0.99, 0.975, 0.95, 0.9};
    }

    public double[] makeDensityTestValues() {
        return new double[]{7.56494565517E-4, 0.0109109752919, 0.0303377878006, 0.0637967988952, 0.128289492005, 7.56494565517E-4, 0.0109109752919, 0.0303377878006, 0.0637967988952, 0.128289492005};
    }

    public void setUp() {
        super.setUp();
        this.setTolerance(1.0E-9);
    }

    @Test
    public void testCumulativeProbabilityAgainstStackOverflow() {
        TDistribution td = new TDistribution(5.0);
        td.cumulativeProbability(0.1);
        td.cumulativeProbability(0.01);
    }

    @Test
    public void testSmallDf() {
        this.setDistribution((RealDistribution)new TDistribution(1.0));
        this.setCumulativeTestPoints(new double[]{-318.308838986, -31.8205159538, -12.7062047362, -6.31375151468, -3.07768353718, 318.308838986, 31.8205159538, 12.7062047362, 6.31375151468, 3.07768353718});
        this.setDensityTestValues(new double[]{3.14158231817E-6, 3.14055924703E-4, 0.00195946145194, 0.00778959736375, 0.0303958893917, 3.14158231817E-6, 3.14055924703E-4, 0.00195946145194, 0.00778959736375, 0.0303958893917});
        this.setInverseCumulativeTestValues(this.getCumulativeTestPoints());
        this.verifyCumulativeProbabilities();
        this.verifyInverseCumulativeProbabilities();
        this.verifyDensities();
    }

    @Test
    public void testInverseCumulativeProbabilityExtremes() {
        this.setInverseCumulativeTestPoints(new double[]{0.0, 1.0});
        this.setInverseCumulativeTestValues(new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY});
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testCumulativeProbablilityExtremes() {
        for (int i = 1; i < 11; ++i) {
            TDistribution dist = new TDistribution((double)(i * 5));
            Assert.assertEquals((double)1.0, (double)dist.cumulativeProbability(Double.POSITIVE_INFINITY), (double)Double.MIN_VALUE);
            Assert.assertEquals((double)0.0, (double)dist.cumulativeProbability(Double.NEGATIVE_INFINITY), (double)Double.MIN_VALUE);
        }
    }

    @Test
    public void testDfAccessors() {
        TDistribution dist = (TDistribution)this.getDistribution();
        Assert.assertEquals((double)5.0, (double)dist.getDegreesOfFreedom(), (double)Double.MIN_VALUE);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPreconditions() {
        new TDistribution(0.0);
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        TDistribution dist = new TDistribution(1.0);
        Assert.assertTrue((boolean)Double.isNaN(dist.getNumericalMean()));
        Assert.assertTrue((boolean)Double.isNaN(dist.getNumericalVariance()));
        dist = new TDistribution(1.5);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)0.0, (double)1.0E-9);
        Assert.assertTrue((boolean)Double.isInfinite(dist.getNumericalVariance()));
        dist = new TDistribution(5.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)0.0, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)1.6666666666666667, (double)1.0E-9);
    }

    @Test
    public void nistData() {
        double[] prob = new double[]{0.1, 0.05, 0.025, 0.01, 0.005, 0.001};
        double[] args2 = new double[]{1.886, 2.92, 4.303, 6.965, 9.925, 22.327};
        double[] args10 = new double[]{1.372, 1.812, 2.228, 2.764, 3.169, 4.143};
        double[] args30 = new double[]{1.31, 1.697, 2.042, 2.457, 2.75, 3.385};
        double[] args100 = new double[]{1.29, 1.66, 1.984, 2.364, 2.626, 3.174};
        TestUtils.assertEquals(prob, this.makeNistResults(args2, 2), 1.0E-4);
        TestUtils.assertEquals(prob, this.makeNistResults(args10, 10), 1.0E-4);
        TestUtils.assertEquals(prob, this.makeNistResults(args30, 30), 1.0E-4);
        TestUtils.assertEquals(prob, this.makeNistResults(args100, 100), 1.0E-4);
    }

    private double[] makeNistResults(double[] args, int df) {
        TDistribution td = new TDistribution((double)df);
        double[] res = new double[args.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = 1.0 - td.cumulativeProbability(args[i]);
        }
        return res;
    }
}

