/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.IntegerDistributionAbstractTest;
import org.apache.commons.math3.distribution.ZipfDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.random.AbstractRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well1024a;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ZipfDistributionTest
extends IntegerDistributionAbstractTest {
    public ZipfDistributionTest() {
        this.setTolerance(1.0E-12);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPreconditions1() {
        new ZipfDistribution(0, 1.0);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPreconditions2() {
        new ZipfDistribution(1, 0.0);
    }

    public IntegerDistribution makeDistribution() {
        return new ZipfDistribution(10, 1.0);
    }

    public int[] makeDensityTestPoints() {
        return new int[]{-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0, 0.0, 0.341417152147, 0.170708576074, 0.113805717382, 0.0853542880369, 0.0682834304295, 0.0569028586912, 0.0487738788782, 0.0426771440184, 0.0379352391275, 0.0341417152147, 0.0};
    }

    public double[] makeLogDensityTestValues() {
        return new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -1.07465022926458, -1.76779740982453, -2.17326251793269, -2.46094459038447, -2.68408814169868, -2.86640969849264, -3.0205603783199, -3.15409177094442, -3.2718748066008, -3.37723532225863, Double.NEGATIVE_INFINITY};
    }

    public int[] makeCumulativeTestPoints() {
        return this.makeDensityTestPoints();
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.0, 0.0, 0.341417152147, 0.512125728221, 0.625931445604, 0.71128573364, 0.77956916407, 0.836472022761, 0.885245901639, 0.927923045658, 0.965858284785, 1.0, 1.0};
    }

    public double[] makeInverseCumulativeTestPoints() {
        return new double[]{0.0, 0.001, 0.01, 0.025, 0.05, 0.3413, 0.3415, 0.999, 0.99, 0.975, 0.95, 0.9, 1.0};
    }

    public int[] makeInverseCumulativeTestValues() {
        return new int[]{1, 1, 1, 1, 1, 1, 2, 10, 10, 10, 9, 8, 10};
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        ZipfDistribution dist = new ZipfDistribution(2, 0.5);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)FastMath.sqrt((double)2.0), (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)0.24264068711928521, (double)1.0E-9);
    }

    @Test
    public void testSamplingExtended() {
        int sampleSize = 1000;
        int[] numPointsValues = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 25, 30, 35, 40, 45, 50, 60, 70, 80, 90, 100};
        double[] exponentValues = new double[]{1.0E-10, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 0.2, 0.5, 0.999999999, 1.0, 1.000000001, 1.1, 1.2, 1.3, 1.5, 1.6, 1.7, 1.8, 2.0, 2.5, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 20.0, 30.0, 100.0, 150.0};
        for (int numPoints : numPointsValues) {
            for (double exponent : exponentValues) {
                int[] sample;
                double weightSum = 0.0;
                double[] weights = new double[numPoints];
                for (int i = numPoints; i >= 1; --i) {
                    weights[i - 1] = Math.pow(i, -exponent);
                    weightSum += weights[i - 1];
                }
                ZipfDistribution distribution = new ZipfDistribution(numPoints, exponent);
                distribution.reseedRandomGenerator(6L);
                double[] expectedCounts = new double[numPoints];
                long[] observedCounts = new long[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    expectedCounts[i] = (double)sampleSize * (weights[i] / weightSum);
                }
                for (int s : sample = distribution.sample(sampleSize)) {
                    int n = s - 1;
                    observedCounts[n] = observedCounts[n] + 1L;
                }
                TestUtils.assertChiSquareAccept(expectedCounts, observedCounts, 0.001);
            }
        }
    }

    @Test
    public void testSamplerHelper1() {
        double[] testValues;
        double tol = 1.0E-12;
        for (double testValue : testValues = new double[]{FastMath.nextUp((double)-1.0), -0.1, -0.01, -0.001, -1.0E-4, -1.0E-5, -1.0E-6, -1.0E-7, -1.0E-8, -1.0E-9, -1.0E-10, -1.0E-11, 0.0, 1.0E-11, 1.0E-10, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0}) {
            double expected = FastMath.log1p((double)testValue);
            TestUtils.assertRelativelyEquals(expected, ZipfDistribution.ZipfRejectionInversionSampler.helper1((double)testValue) * testValue, 1.0E-12);
        }
    }

    @Test
    public void testSamplerHelper1Minus1() {
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)ZipfDistribution.ZipfRejectionInversionSampler.helper1((double)-1.0), (double)0.0);
    }

    @Test
    public void testSamplerHelper2() {
        double[] testValues;
        double tol = 1.0E-12;
        for (double testValue : testValues = new double[]{-1.0, -0.1, -0.01, -0.001, -1.0E-4, -1.0E-5, -1.0E-6, -1.0E-7, -1.0E-8, -1.0E-9, -1.0E-10, -1.0E-11, 0.0, 1.0E-11, 1.0E-10, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0}) {
            double expected = FastMath.expm1((double)testValue);
            TestUtils.assertRelativelyEquals(expected, ZipfDistribution.ZipfRejectionInversionSampler.helper2((double)testValue) * testValue, 1.0E-12);
        }
    }

    @Ignore
    @Test
    public void testSamplerPerformance() {
        int[] numPointsValues = new int[]{1, 2, 5, 10, 100, 1000, 10000};
        double[] exponentValues = new double[]{0.001, 0.01, 0.1, 1.0, 2.0, 5.0, 10.0};
        int numGeneratedSamples = 1000000;
        long sum = 0L;
        for (int numPoints : numPointsValues) {
            for (double exponent : exponentValues) {
                long start = System.currentTimeMillis();
                final int[] randomNumberCounter = new int[1];
                AbstractRandomGenerator randomGenerator = new AbstractRandomGenerator(){
                    private final RandomGenerator r = new Well1024a(0L);

                    public void setSeed(long seed) {
                    }

                    public double nextDouble() {
                        randomNumberCounter[0] = randomNumberCounter[0] + 1;
                        return this.r.nextDouble();
                    }
                };
                ZipfDistribution distribution = new ZipfDistribution((RandomGenerator)randomGenerator, numPoints, exponent);
                for (int i = 0; i < numGeneratedSamples; ++i) {
                    sum += (long)distribution.sample();
                }
                long end = System.currentTimeMillis();
                System.out.println("n = " + numPoints + ", exponent = " + exponent + ", avg number consumed random values = " + (double)randomNumberCounter[0] / (double)numGeneratedSamples + ", measured time = " + (double)(end - start) / 1000.0 + "s");
            }
        }
        System.out.println(sum);
    }
}

