/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting;

import java.util.List;
import org.apache.commons.math3.fitting.WeightedObservedPoint;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class WeightedObservedPointsTest {
    @Test
    public void testAdd1() {
        WeightedObservedPoints store = new WeightedObservedPoints();
        double x = 1.2;
        double y = 34.56;
        double w = 0.789;
        store.add(0.789, 1.2, 34.56);
        Assert.assertTrue((boolean)this.lastElementIsSame(store, new WeightedObservedPoint(0.789, 1.2, 34.56)));
    }

    @Test
    public void testAdd2() {
        WeightedObservedPoints store = new WeightedObservedPoints();
        double x = 1.2;
        double y = 34.56;
        double w = 0.789;
        store.add(new WeightedObservedPoint(0.789, 1.2, 34.56));
        Assert.assertTrue((boolean)this.lastElementIsSame(store, new WeightedObservedPoint(0.789, 1.2, 34.56)));
    }

    @Test
    public void testAdd3() {
        WeightedObservedPoints store = new WeightedObservedPoints();
        double x = 1.2;
        double y = 34.56;
        store.add(1.2, 34.56);
        Assert.assertTrue((boolean)this.lastElementIsSame(store, new WeightedObservedPoint(1.0, 1.2, 34.56)));
    }

    @Test
    public void testClear() {
        WeightedObservedPoints store = new WeightedObservedPoints();
        store.add(new WeightedObservedPoint(1.0, 2.0, 3.0));
        store.add(new WeightedObservedPoint(2.0, -1.0, -2.0));
        Assert.assertTrue((store.toList().size() == 2 ? 1 : 0) != 0);
        store.clear();
        Assert.assertTrue((store.toList().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToListCopy() {
        WeightedObservedPoints store = new WeightedObservedPoints();
        store.add(new WeightedObservedPoint(1.0, 2.0, 3.0));
        store.add(new WeightedObservedPoint(2.0, -3.0, -4.0));
        List list = store.toList();
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        list.add(new WeightedObservedPoint(1.2, 3.4, 5.6));
        Assert.assertFalse((list.size() == store.toList().size() ? 1 : 0) != 0);
        store.clear();
        Assert.assertFalse((list.size() == 0 ? 1 : 0) != 0);
    }

    private boolean lastElementIsSame(WeightedObservedPoints store, WeightedObservedPoint point) {
        List list = store.toList();
        WeightedObservedPoint lastPoint = (WeightedObservedPoint)list.get(list.size() - 1);
        if (!Precision.equals((double)lastPoint.getX(), (double)point.getX())) {
            return false;
        }
        if (!Precision.equals((double)lastPoint.getY(), (double)point.getY())) {
            return false;
        }
        return Precision.equals((double)lastPoint.getWeight(), (double)point.getWeight());
    }
}

