/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.genetics.AbstractListChromosome;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.CrossoverPolicy;
import org.apache.commons.math3.genetics.ElitisticListPopulation;
import org.apache.commons.math3.genetics.FixedGenerationCount;
import org.apache.commons.math3.genetics.GeneticAlgorithm;
import org.apache.commons.math3.genetics.MutationPolicy;
import org.apache.commons.math3.genetics.OnePointCrossover;
import org.apache.commons.math3.genetics.Population;
import org.apache.commons.math3.genetics.RandomKey;
import org.apache.commons.math3.genetics.RandomKeyMutation;
import org.apache.commons.math3.genetics.SelectionPolicy;
import org.apache.commons.math3.genetics.StoppingCondition;
import org.apache.commons.math3.genetics.TournamentSelection;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class GeneticAlgorithmTestPermutations {
    private static final int DIMENSION = 20;
    private static final int POPULATION_SIZE = 80;
    private static final int NUM_GENERATIONS = 200;
    private static final double ELITISM_RATE = 0.2;
    private static final double CROSSOVER_RATE = 1.0;
    private static final double MUTATION_RATE = 0.08;
    private static final int TOURNAMENT_ARITY = 2;
    private static final List<Integer> sequence = new ArrayList<Integer>();

    @Test
    public void test() {
        GeneticAlgorithm ga = new GeneticAlgorithm((CrossoverPolicy)new OnePointCrossover(), 1.0, (MutationPolicy)new RandomKeyMutation(), 0.08, (SelectionPolicy)new TournamentSelection(2));
        ElitisticListPopulation initial = GeneticAlgorithmTestPermutations.randomPopulation();
        FixedGenerationCount stopCond = new FixedGenerationCount(200);
        Chromosome bestInitial = initial.getFittestChromosome();
        Population finalPopulation = ga.evolve((Population)initial, (StoppingCondition)stopCond);
        Chromosome bestFinal = finalPopulation.getFittestChromosome();
        Assert.assertTrue((bestFinal.compareTo(bestInitial) > 0 ? 1 : 0) != 0);
    }

    private static ElitisticListPopulation randomPopulation() {
        ArrayList<MinPermutations> popList = new ArrayList<MinPermutations>();
        for (int i = 0; i < 80; ++i) {
            MinPermutations randChrom = new MinPermutations(RandomKey.randomPermutation((int)20));
            popList.add(randChrom);
        }
        return new ElitisticListPopulation(popList, popList.size(), 0.2);
    }

    static {
        for (int i = 0; i < 20; ++i) {
            sequence.add(i);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinPermutations
    extends RandomKey<Integer> {
        public MinPermutations(List<Double> representation) {
            super(representation);
        }

        public double fitness() {
            int res = 0;
            List decoded = this.decode(sequence);
            for (int i = 0; i < decoded.size(); ++i) {
                int value = (Integer)decoded.get(i);
                if (value == i) continue;
                res += FastMath.abs((int)(value - i));
            }
            return -res;
        }

        public AbstractListChromosome<Double> newFixedLengthChromosome(List<Double> chromosomeRepresentation) {
            return new MinPermutations(chromosomeRepresentation);
        }
    }
}

