/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.genetics.BinaryChromosome;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.ChromosomePair;
import org.apache.commons.math3.genetics.DummyBinaryChromosome;
import org.apache.commons.math3.genetics.NPointCrossover;
import org.junit.Assert;
import org.junit.Test;

public class NPointCrossoverTest {
    @Test(expected=DimensionMismatchException.class)
    public void testCrossoverDimensionMismatchException() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        Integer[] p2 = new Integer[]{0, 1, 1, 0, 1};
        DummyBinaryChromosome p1c = new DummyBinaryChromosome(p1);
        DummyBinaryChromosome p2c = new DummyBinaryChromosome(p2);
        NPointCrossover cp = new NPointCrossover(1);
        cp.crossover((Chromosome)p1c, (Chromosome)p2c);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testNumberIsTooLargeException() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        Integer[] p2 = new Integer[]{0, 1, 1, 0, 1, 0, 1, 1, 1};
        DummyBinaryChromosome p1c = new DummyBinaryChromosome(p1);
        DummyBinaryChromosome p2c = new DummyBinaryChromosome(p2);
        NPointCrossover cp = new NPointCrossover(15);
        cp.crossover((Chromosome)p1c, (Chromosome)p2c);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testCrossoverInvalidFixedLengthChromosomeFirst() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        DummyBinaryChromosome p1c = new DummyBinaryChromosome(p1);
        Chromosome p2c = new Chromosome(){

            public double fitness() {
                return 0.0;
            }
        };
        NPointCrossover cp = new NPointCrossover(1);
        cp.crossover((Chromosome)p1c, p2c);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testCrossoverInvalidFixedLengthChromosomeSecond() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 0, 1, 0, 1, 1};
        DummyBinaryChromosome p2c = new DummyBinaryChromosome(p1);
        Chromosome p1c = new Chromosome(){

            public double fitness() {
                return 0.0;
            }
        };
        NPointCrossover cp = new NPointCrossover(1);
        cp.crossover(p1c, (Chromosome)p2c);
    }

    @Test
    public void testCrossover() {
        Integer[] p1 = new Integer[]{1, 0, 1, 0, 1, 0, 1, 0, 1};
        Integer[] p2 = new Integer[]{0, 1, 0, 1, 0, 1, 0, 1, 0};
        DummyBinaryChromosome p1c = new DummyBinaryChromosome(p1);
        DummyBinaryChromosome p2c = new DummyBinaryChromosome(p2);
        int order = 3;
        NPointCrossover npc = new NPointCrossover(3);
        for (int i = 0; i < 20; ++i) {
            ChromosomePair pair = npc.crossover((Chromosome)p1c, (Chromosome)p2c);
            Integer[] c1 = new Integer[p1.length];
            Integer[] c2 = new Integer[p2.length];
            c1 = ((BinaryChromosome)pair.getFirst()).getRepresentation().toArray(c1);
            c2 = ((BinaryChromosome)pair.getSecond()).getRepresentation().toArray(c2);
            Assert.assertEquals((long)3L, (long)this.detectCrossoverPoints(p1c, p2c, (BinaryChromosome)pair.getFirst()));
            Assert.assertEquals((long)3L, (long)this.detectCrossoverPoints(p2c, p1c, (BinaryChromosome)pair.getSecond()));
        }
    }

    private int detectCrossoverPoints(BinaryChromosome p1, BinaryChromosome p2, BinaryChromosome c) {
        int crossovers = 0;
        int length = p1.getLength();
        List p1Rep = p1.getRepresentation();
        List p2Rep = p2.getRepresentation();
        List cRep = c.getRepresentation();
        List rep = p1Rep;
        for (int i = 0; i < length; ++i) {
            if (rep.get(i) == cRep.get(i)) continue;
            ++crossovers;
            rep = rep == p1Rep ? p2Rep : p1Rep;
        }
        return crossovers;
    }
}

