/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.vector;

import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointVectorValuePair;
import org.apache.commons.math3.optim.SimpleBounds;
import org.apache.commons.math3.optim.SimpleVectorValueChecker;
import org.apache.commons.math3.optim.nonlinear.vector.ModelFunction;
import org.apache.commons.math3.optim.nonlinear.vector.ModelFunctionJacobian;
import org.apache.commons.math3.optim.nonlinear.vector.MultiStartMultivariateVectorOptimizer;
import org.apache.commons.math3.optim.nonlinear.vector.MultivariateVectorOptimizer;
import org.apache.commons.math3.optim.nonlinear.vector.Target;
import org.apache.commons.math3.optim.nonlinear.vector.Weight;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.GaussNewtonOptimizer;
import org.apache.commons.math3.random.GaussianRandomGenerator;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.NormalizedRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.RandomVectorGenerator;
import org.apache.commons.math3.random.UncorrelatedRandomVectorGenerator;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class MultiStartMultivariateVectorOptimizerTest {
    @Test(expected=NullPointerException.class)
    public void testGetOptimaBeforeOptimize() {
        GaussNewtonOptimizer underlyingOptimizer = new GaussNewtonOptimizer(true, (ConvergenceChecker)new SimpleVectorValueChecker(1.0E-6, 1.0E-6));
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(16069223052L);
        UncorrelatedRandomVectorGenerator generator = new UncorrelatedRandomVectorGenerator(1, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)g));
        MultiStartMultivariateVectorOptimizer optimizer = new MultiStartMultivariateVectorOptimizer((MultivariateVectorOptimizer)underlyingOptimizer, 10, (RandomVectorGenerator)generator);
        optimizer.getOptima();
    }

    @Test
    public void testTrivial() {
        LinearProblem problem = new LinearProblem(new double[][]{{2.0}}, new double[]{3.0});
        GaussNewtonOptimizer underlyingOptimizer = new GaussNewtonOptimizer(true, (ConvergenceChecker)new SimpleVectorValueChecker(1.0E-6, 1.0E-6));
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(16069223052L);
        UncorrelatedRandomVectorGenerator generator = new UncorrelatedRandomVectorGenerator(1, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)g));
        MultiStartMultivariateVectorOptimizer optimizer = new MultiStartMultivariateVectorOptimizer((MultivariateVectorOptimizer)underlyingOptimizer, 10, (RandomVectorGenerator)generator);
        PointVectorValuePair optimum = (PointVectorValuePair)optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getModelFunction(), problem.getModelFunctionJacobian(), problem.getTarget(), new Weight(new double[]{1.0}), new InitialGuess(new double[]{0.0})});
        Assert.assertEquals((double)1.5, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)optimum.getValue()[0], (double)1.0E-10);
        PointVectorValuePair[] optima = optimizer.getOptima();
        Assert.assertEquals((long)10L, (long)optima.length);
        for (int i = 0; i < optima.length; ++i) {
            Assert.assertEquals((double)1.5, (double)optima[i].getPoint()[0], (double)1.0E-10);
            Assert.assertEquals((double)3.0, (double)optima[i].getValue()[0], (double)1.0E-10);
        }
        Assert.assertTrue((optimizer.getEvaluations() > 20 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getEvaluations() < 50 ? 1 : 0) != 0);
        Assert.assertEquals((long)100L, (long)optimizer.getMaxEvaluations());
    }

    @Test
    public void testIssue914() {
        LinearProblem problem = new LinearProblem(new double[][]{{2.0}}, new double[]{3.0});
        GaussNewtonOptimizer underlyingOptimizer = new GaussNewtonOptimizer(true, (ConvergenceChecker)new SimpleVectorValueChecker(1.0E-6, 1.0E-6)){

            public PointVectorValuePair optimize(OptimizationData ... optData) {
                OptimizationData[] filtered = (OptimizationData[])optData.clone();
                for (int i = 0; i < filtered.length; ++i) {
                    if (!(filtered[i] instanceof SimpleBounds)) continue;
                    filtered[i] = null;
                }
                return super.optimize(filtered);
            }
        };
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(16069223052L);
        UncorrelatedRandomVectorGenerator generator = new UncorrelatedRandomVectorGenerator(1, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)g));
        MultiStartMultivariateVectorOptimizer optimizer = new MultiStartMultivariateVectorOptimizer((MultivariateVectorOptimizer)underlyingOptimizer, 10, (RandomVectorGenerator)generator);
        optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getModelFunction(), problem.getModelFunctionJacobian(), problem.getTarget(), new Weight(new double[]{1.0}), new InitialGuess(new double[]{0.0}), new SimpleBounds(new double[]{-1.0E-10}, new double[]{1.0E-10})});
        PointVectorValuePair[] optima = optimizer.getOptima();
        Assert.assertEquals((long)1L, (long)optima.length);
    }

    @Test(expected=TestException.class)
    public void testNoOptimum() {
        GaussNewtonOptimizer underlyingOptimizer = new GaussNewtonOptimizer(true, (ConvergenceChecker)new SimpleVectorValueChecker(1.0E-6, 1.0E-6));
        JDKRandomGenerator g = new JDKRandomGenerator();
        g.setSeed(12373523445L);
        UncorrelatedRandomVectorGenerator generator = new UncorrelatedRandomVectorGenerator(1, (NormalizedRandomGenerator)new GaussianRandomGenerator((RandomGenerator)g));
        MultiStartMultivariateVectorOptimizer optimizer = new MultiStartMultivariateVectorOptimizer((MultivariateVectorOptimizer)underlyingOptimizer, 10, (RandomVectorGenerator)generator);
        optimizer.optimize(new OptimizationData[]{new MaxEval(100), new Target(new double[]{0.0}), new Weight(new double[]{1.0}), new InitialGuess(new double[]{0.0}), new ModelFunction(new MultivariateVectorFunction(){

            public double[] value(double[] point) {
                throw new TestException();
            }
        })});
    }

    private static class LinearProblem {
        private final RealMatrix factors;
        private final double[] target;

        public LinearProblem(double[][] factors, double[] target) {
            this.factors = new BlockRealMatrix(factors);
            this.target = target;
        }

        public Target getTarget() {
            return new Target(this.target);
        }

        public ModelFunction getModelFunction() {
            return new ModelFunction(new MultivariateVectorFunction(){

                public double[] value(double[] variables) {
                    return LinearProblem.this.factors.operate(variables);
                }
            });
        }

        public ModelFunctionJacobian getModelFunctionJacobian() {
            return new ModelFunctionJacobian(new MultivariateMatrixFunction(){

                public double[][] value(double[] point) {
                    return LinearProblem.this.factors.getData();
                }
            });
        }
    }

    private static class TestException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private TestException() {
        }
    }
}

