/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import org.apache.commons.math3.random.ISAACRandom;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.RandomGeneratorAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public final class ISAACTest
extends RandomGeneratorAbstractTest {
    private static final int[] SEED_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] SEED_2 = new int[]{1639000212, 1245960853, 65329349, -651290801, -392589967, 248162953, -1415010787, -808167428, -1088032601, -530898775, -596359917, -1707167341, 459887659, -307197683, -898948291, -55839913, 696161776, 443303279, 238500016, 470095858, -808385091, 997997035, 337118441, -1978425135, 1045942108, 893850118, 1138422, 874834979, 711615399, 1290580968, -323693759, 1674730177, -1956058371, 248145332, -667597208, -1283776520, -2098721565, 1277243292, 1490562399, 1207133000, 1540917639, -142948754, 1979683822, -277466029, -1761216330, 1692681801, -2064633032, -1876877079, 1397760302, 888432376, -1745261298, 2132654320, 361207859, -269609804, -635088374, -2118066820, -1576290519, 802646084, 458368328, -208382371, -1409327333, 954921703, 910847183, -1898585751, -412439016, 239864674, 1748330386, -1950045565, 827616873, -1496300479, 717156831, -1542842802, -1970470726, 850628026, 1868998598, 1228606596, -664254736, 1356136824, 648537724, -1753210541, -211858733, 1263842638, 901558001, -1007875626, -1054360491, -1293726044, -1922612941, -310185923, -1471923416, 817843161, 1732788636, 358527763, -1317239334, -854753260, -236366016, 1584832210, -117811175, 1003542842, -1536250049, -1862947284, -1859475395, 1721326909, -2091273559, 1683180435, 530808980, -1979849460, -275620107, 1323246215, -957863125, -1719587790, 1408695809, -251386305, -1134720114, 1864626434, -1228138675, -1266998239, -620216538, -696639707, 1330318416, -2030261980, 1142961850, 226343432, -153576418, 1707729550, -695600388, 1207414427, 1018717812, 2039334094, 1654837813, 1938891808, 661584308, 1356773001, 1085716292, -2066245546, -2031750970, -2091231957, -344719467, -467082350, 492879637, -1697604043, 2017353902, -1271927967, 42599235, -1862353668, -537198136, 277326622, -2066175751, -448579741, -1988802356, -1274585394, -794450137, 176478745, 255039051, 1446289559, -1211388809, -452771605, -1812935069, 208944852, -151588843, 821513418, -1157429593, 1023637827, 586323870, 898740931, -1703465436, 1549275898, -1636615030, -1428043453, -793257692, 1455015011, -85084841, 328956581, -512495325, 755402402, 63769583, 1330102302, 1291451267, -1164098754, -1784274731, 1656124457, -399112579, 1617675767, 917471714, -1374975184, 956294650, -1253563765, -1029547061, 1268857326, -1423881513, 1726959440, 1602717690, -883326287, -608923656, 350923028, -528006808, 1045922374, 1217141777, -1742718558, -569808075, -1541342399, 427432807, 384482393, 241735045, 618361527, -124225341, 77981780, 860281346, -1262786044, 663358932, 2075583012, -1830676029, 1499433523, -304579866, -1558983521, 945560890, 176889269, -1315817571, 973857003, -1195759973, 520905381, 1446015810, -1882608492, -326000078, -1481059365, -67880352, -1485617602, 1926603985, -1914759339, 668613051, -1462475126, -755778564, -1584867665, -2098370930, -1268842446, -839037792, 350595085, 1164285116, 1760546261, 2109677469, 1952028313, -58312216, 1094313873, -1677290982, -988668618, -782527451, 108059815, -1134509229, -1437997945, -1479845804, -798106661, -884219694, -2087605352, -951003201, 911425713, 642152391, -1218415196};
    private static final int[] EXPECTED_SEQUENCE_1 = new int[]{405143795, 806046349, 807101986, -1333080799, 695195257, -1722677527, -1275090763, 264870948, 1594302383, 1378164207, -1991294526, -867394821, -1765589132, 880588573, -921727043, -1504119430, -977101288, 1649015337, -1159630854, 633893309, -188260828, 1521740473, -1404761201, 371838884, 1501295, -226734835, 1734642455, 96489422, 1154744185, -961752561, 1194318228, -2078199356, -355161856, -1071719923, -1637856133, -74838375, 48331631, -390793689, -956031314, 1121033431, -1554453612, 432677208, 1810288257, 1267770590, 653293389, 1317245706, 613602422, -1182795074, 1734133934, 1291702868, 1564213482, 2075811501, 1866864656, -1091158294, 1928033915, -311519685, -1339686547, 399212223, -1478726058, -194986511, 536743428, -1876216707, 46192811, -1731510389, 1865783865, -1792966049, -1876502146, -567007978, -1995803636, 254372324, 780052973, 961251919, 467607504, 366306740, -1158659987, 1303126235, 53844018, -481819947, -866124030, 154512750, 2085865906, -1324655319, 1337693374, -672889530, -1211129284, 2131238042, -526796047, -1669479645, -1204703980, 1532375297, -95080037, 101576020, -985562844, 1985940922, 450091477, 1057483849, -581040442, -1036983636, -960882319, -1665041460, 280111650, 2113703039, -1288633549, 542453998, -604796273, 3801845, 8296099, 912622081, 148887119, 1651879155, 1026123419, 1798260024, -1328794773, 489702379, 449959780, 1281710980, 2054314930, -1275306906, -2135639787, -1295263260, 697491398, -544479928, -1290743698, 1130595782, 1154934931, 1153750941, -474275740, -467753883, 1073007728, -1658737598, 1730950949, -1539695358, -41635429, 1534046514, 1257506966, -514850650, 2091586294, -1953598148, -81447852, 899335014, 1736584005, 688525632, -1377377240, 1620438987, -1713841690, -1514825699, 858559958, -1352860501, 371154086, 407162594, -4674724, -2097362197, 1240267130, 2053175997, -111650246, 1320598834, 993292290, -191689286, 1562498334, 1692984308, 1384128424, 1909362812, -2027453532, 123853952, 1548785736, 1102719708, 2117031200, -2050625854, 915225856, 1606927859, -1203120251, -648075853, 2038439893, -1088142378, 906838477, 1696272832, -2145744438, -1952552044, -35486780, -866227852, 724519945, -1960746840, -604668159, 1990859854, 300974874, 1416707351, -912644551, 1278688890, 166126975, 1911962375, 2078535726, 747666142, -436958730, 185390810, -1251548852, 261445993, -1595576053, -2133277986, -1720589162, -940590033, -1750823341, 763649037, -518436082, -1389648768, -718981806, -896988367, 1611008763, -1982142169, 1449009705, 1135329820, 64820389, -1146236540, -1634232574, 795187331, -216814100, 1645991882, -1236858828, 1278804422, 839027640, -1645379004, 1720743508, 168211058, 1250870832, 1107809135, 1048218441, 327621607, -1082461042, 1038147385, 243680578, -1945564637, -1349458786, -1754915746, 911910508, 7594818, -1668627385, 1868031950, -708935686, -1989862012, 1408732842, -2123113468, -687137264, 1136764283, 281585067, -311771806, 797183555, 1215551774, 1240732668, 1569300929, -744257284, -1765434124, 1164910301, 1037172771, -1570445005, -752265499, -652564680, -412232903, 2053665039, 1700047834, -1866397865, 190727007, -1350754376, 26296275, 1779797264, -1191772854, -1028019658, -1764088235, -31571243, 1457966369, -709699760, 1915349633, 1575516859, -1229334682, 504783180, 997232537, 1559766221, -1530262287, 1658001681, 2094884399, -878832285, 2041465872, 135035372, 403180686, 1242179644, 1037999929, 163803024, -1386842557, 136922982, -1270784131, 1436019727, 2030019944, -1951603154, 1099481037, -931364858, -1347868051, 1358725524, -890708294, 871815089, 1394891641, 1628543578, 2117163755, -413449783, -760661167, -330911562, 517209934, 1560428133, -1376338909, -134901893, -453795222, 207035005, -315234834, -354500948, 817678180, 1727127723, -2106721655, 228359806, -404593279, -711389701, 46774596, 1091754348, 1072817444, -1017232000, -33622483, -1203792518, -1077413940, -1257189874, -848031321, 81481235, 1989167981, 140541700, 924374423, 1187030773, -2079936201, 815528824, -137104481, -1943073451, -971771561, 310236208, 1925780349, 1755550552, 130190545, -2070982134, -584203819, -1819758277, 686279544, 66816244, -1330098565, 348651675, -2008192987, 566325740, 134866068, 1779463561, 307845657, 196290111, 1301261954, 714609178, -1341562694, 1728619196, 899753141, -1127567635, 692926437, -737812776, -1623596327, 562256973, -392488389, 1935971403, -1121038300, 1779580759, 873486988, 1523635120, -872203037, -719386307, 1453326819, 27901296, -2003717157, 330160418, 1031264674, 243142247, -683707692, -1854153022, -1551932417, 601313102, 980214665, 101109663, -569250508, 1892455598, -888213942, 334348491, -30841316, -613564778, -1282877076, 867975261, -1496243967, 792132230, 2112698479, -432782255, -849885193, 453889473, -850793509, -1635102246, 312498507, 1624561144, -1849108187, -465760325, 1563055151, 1159626440, 724979804, 935390469, 593797546, -2125741492, -475634983, -222966779, -1196372740, -1336362245, 988429804, 218269316, 1689194479, 554645797, -1233206982, -1760137964, -136196656, 1524326631, -718709060, 679687458, 1626187994, 2076665873, -1398806883, 816550892, 57239060, 367240633, -322577263, 490442391, 1920328311, 1401823054, 1823565787, -1482492926, 766729726, -1464024531, -658142614, 1783798539, 265566563, -1346274665, -1807991692, -1793882263, 1867384690, -1320962424, 991487826, 1775428782, -2130195969, -843291934, 1468088655, -1954069634, -1492250367, -1847935899, 1310928080, 580340149, -684169210, -1279004085, 1625051655, 198941744, 443607017, -209948203, 1152949000, -1261241994, -1274140740, -2127232, -1673455062, -789073027, -279720252, -324741750, 194130432, -819797916, -1900043517, -137395892, 850274859, -1243529810, -912721409, 882460592, 701461198, 400789381, -206413527, -732074623, 162778776, -2046478664, -445043173, 313353241, -168354711, -876038206, -1889200551, -1597213453, -678643298, 1371573635, 703943753, 3069715, 950543603, 1461067254, 1951589145, 629739054, -951835597, 1247765333, 1787027936, -2109936202, -237746965, -2009591657, 1575187518, 1187663770, -667483001, -303295158, 1128209147, -168110769, -1730465868, -464983699, -162470712, 1270198057, -1652203895, -984819365, 1188650149, -277611536, -112986510, -2034609537, -1651697400, -214889326, 87297557, 131070681, 568480894, -1944588304, -752099232, -1967505413, -1798045403, -978815160, -2108940279, 1942021986, -838942033, 241979827, -1469085858, -1134464313, -135031311, 1064663475, 2057377005, 375066645, -718203366, -479267397, -602587553, 487372827, -822099641, 1618601166, -1022087793, -1508401021, -1253053073, -1010319828, 39930559, 1874185814, -769754772, 755598814, -369606301, -1046012356, 679991663, 1472514341, 99607188, -2011860653, -1708079896, -2007719775, 38813565, 215412609, 497349210, -386254752, 853774963, 1283871446, -1699503057, -1632796816, -2089975805, 1824422197, 1913979613, 1514698076, 122256558, -565825715, -1829405017, 534932704, 667427458, -689164501, -2134449150, -830013956, 1382325612, -946278329, 1169876486, -1994724279, 1724478272, -1666949604, 1116103068, -168178629, 1317157587, -1059728342, -1360949098, 1028035331, -28527744, -909279092, 933854710, 814707999, 661516468, -436487737, -1748361104, -2008995999, 753259477, -676054338, -1559946835, 641814515, -977409784, 660516154, 651079683, -1088694639, 57959616, -499047232, -2116760481, 1212491236, 473580836, -1635889404, -517497857, 1842451514, 1077784072, -2105252570, -714590120, 691154189, -1454784862, 1946774247, -2053030011, 1747147677, -1896563482, 338325125, -623791574, -1219205503, -1784798386, -41529128, 1047728040, 1458920049, -771039485, 2094823586, 419724409, 624631162, 1133094986, 183206245, -1676289221, -1426131545, -1098185038, -1241610304, -492507279, -640216583, -318967285, -2131049278, -1145525308, 597572362, -2055132762, -646130872, -1976536182, -977856201, -699816920, 415362970, 1975552566, -920520370, -543491543, 68120692, 1928697647, -2064711206, 750237567, -2039470121, -1663034979, 1904630860, 2050404243, 1816714712, 431263696, 1978984930, 8703973, 1673516248, -1752969746, 1693606700, -239989073, -863241683, 970846810, 1947074662, -1646573697, 313708470, -798491419, 441150035, 1891221, 314599688, 1394263743, 1362892644, -146314888, 468162871, -1970406749, 1889625614, -76317926, 1059647075, -1046146187, -2067960362, -458941151, -352399053, 581830018, 1298632486, -128666334, 831552866, 1263918489, 80962954, 432137884, -971952163, -966354435, -1595228565, 925160668, 220790354, 1182899758, -1762196564, 555232419, 779813423, 830869267, 425112037, -516808152, 134625925, 496387465, -1797716863, 1405122803, 1526416302, 506738679, -2021738572, 1567036220, -1551512788, -1204869373, -284824058, -1826760734, 282202282, -502056500, 1201420834, 1631283122, 868561436, -1510700348, -1168797496, -349943515, -789627703, -658234373, 365939804, 535506511, 921439907, -605061729, -705926156, 1027473290, 503621623, -2023310508, -1709344955, -946202807, -1194178451, 1479421972, -1474025483, 1709155367, -1135192895, -1123520730, 72438125, -11731915, -2114812339, 830869253, -798781926, -1336334819, 1025413456, 568501532, -2099954414, 269529717, 2020288776, 1295842266, -1801256204, -1782030678, -673069122, -2102638513, -766661990, 1879396868, -1087901939, 1947122484, 1201798959, 58613397, 862116051, -1332961704, 1882634661, 861149562, 845979410, -1416030610, 1818048651, -1306351768, 468787653, 787964032, -1335525087, -2093892141, 1689636149, -1010304028, 1466858846, 482197938, 1549055605, -1073907997, 718779711, -443097559, -1025936677, -238473420, 1794367190, -332300954, 1779941077, 661982878, -1919611725, -1334409012, 396811736, 1542537440, -309914656, 92867754, -160543373, 1587557503, -181013771, 604795123, 1586635154, -1906706108, 830863271, -2060594366, 1489560891, 1979740613, -1380487304, 408598540, -1652236504, 1293965018, 1774107852, -1443056136, -1177310079, -868791636, -1068622103, 1919108660, -1279527803, 515448293, 1586357762, 555537761, -1338768154, 85932627, -1302112612, -1765030577, -1632675610, 854192370, 923737305, 364872717, 498949382, -1337122483, 1830197230, -994640671, 462813229, 1184341158, 55889864, -711652035, 282812509, 414135666, -1727084632, 705685631, 2033703864, -298357626, -861958032, -917255512, -708328723, -296782546, -2064448777, 503882894, 1151719989, 262898658, -1149453857, 630239201, -17815894, -2082744765, -1097765615, 670563241, -2112660157, 1818206884, -505334002, 1364411777, 1289346803, -649377392, 1953964921, 1495681565, -1042489970, -313593367, -224554982, 1760350381, -1698488430, -2087049122, 1178890530, -1058706322, -1332065405, -1454371952, -628898587, 1098232568, -347219126, 594308910, -290096590, 640083720, -1445768603, 1790175659, -248525793, 473005123, 1724075955, -511813472, 43373729, 1087193337, 1919945648, -711858658, 1050063515, -1257415245, -1552851508, 872791220, 235097445, 554322475, 2083532588, 619233014, -1525460665, 101183360, 33057935, 746138762, 1790390579, 1866686470, 163521190, 534660642, -1740522212, -1304790313, -623543900, 1125263849, -94516435, 2107963280, -1447900908, -853992211, 2047206570, 1940854921, 421947315, 1401767232, -1394881919, 1805491856, -1069143110, -51009607, 2069637380, 1101544579, 2120843919, 847920043, -590286462, 487668685, 532006940, 760393632, 755786001, 704826900, 1070410773, 1423275257, -564664827, -2049198787, -58933245, 1989965017, 1870875215, 2041821310, -472397741, -1472326478, 991936941, -1210308216, -1240541614, -633455334, 1596942348, -1267857190, 1486583770, -822704843, 470144934, 609693089, -1818557787, -858747629, -543020688, -537438181, 761245158, 1560097673, -836318287, 929923024, 42016302, -864014165, -1482372644, -2116350809, 362921199, 541443765, 1388508515, 1820497719, -1259128753, -1320341717, -519905270, -1170892429, 1615191435, -794434255, -696700913, -1430337986, 1382734080, -1792913613, 1916628292, -2091365676, -1588668311, 1920708666, -572297179, -1298307705, -1007446243, 1918448578, 1760816548, -146890788, -1807024892, -1530535841, 1199534254, -1311600, -1038286992, -2067362254, -399884949, -1172031385, 1360794671, 543340716, 659165599, 1999305634, -2002544819, 542961886, -463644118, 390399339, 746666229, -1742128985, -81372423, 1879846111, -1813689932, -1196698797, -683641880, 681357098, 1676149481, -1023824457};
    private static final int[] EXPECTED_SEQUENCE_2 = new int[]{1739491895, -1484578070, -1187428045, 1643570117, -1096452367, -1147826408, 315516025, -980167202, -554532448, -2076853406, -234142501, -1969731686, -1087665306, 276833886, -252120785, 35629043, -2116883111, -1306221064, 203420486, -1845461336, -1882075581, -319985163, 1696587930, 1171205182, 1151019806, 1326672869, -2109682537, -896034054, 867608663, 1929442547, 2037734769, -820912798, -1855226364, 34040846, -1689371032, 75722453, -239824186, -2004944628, 152791286, -1350628037, -1982339647, 724107255, -433582513, 1719773189, -886633541, -1912376221, 832644599, 195281205, 2083425086, 1847713902, -927779142, 148273091, 1184878684, 1901233737, 539280898, 937881, -1338796623, 169007456, 1756451444, 2084658183, 75264923, 1181059333, 1162947132, 2135741183, 1028476662, -687772243, 1618263024, -1096133141, -988163290, 986925565, 804013641, 351944878, -1766517951, 737185521, -774671132, 1142328084, -1340346725, 188695346, -946226726, 1996258749, -1942582697, -456315731, -290442870, -1038800632, 728791566, 1933931620, -1064398176, -52442533, 320924995, 859535289, 779129994, -1484942089, -1138771462, -1465051743, 1011331316, -2038674801, -1202223904, -1970975104, 1164740352, -1030800895, 1096656554, 320194264, 1889847920, -34958322, 1752153545, -630939974, 1712428791, 2036030759, -519276294, 802725107, 1642615002, 12883812, -296626111, 12681253, -559848525, -1961156480, 1790826115, -446642383, -966675488, 597950216, -1487431399, -96191302, 1208734240, 168915979, -1263327289, -2095445952, -1211822093, 1114038257, -2091055515, 1381576760, 957873038, -2000440320, 100370467, -907368289, 1767374103, -1917011714, -557773764, -1853005864, 1794662810, -1891163563, -1023977545, -1654462460, 1172365942, 1210423251, 102302228, 388728065, -383943796, 1323927036, 1053553786, -1146200680, 520863211, 221782158, 1833743331, -1493151548, -254066546, -575213145, 1271184481, -1864252965, 540504284, 966103623, -488622230, -150305503, -2117641806, 618238299, 164376259, 265338873, 1485264438, -294091906, 39485166, 1109820831, -2048780282, -1676465987, 86179232, 1481916842, 913284768, -344943793, 238636097, -92269543, 728583230, -1332251138, 1057064110, 986592536, -133433197, -1756072645, 2026138515, 673061144, 234669550, -1069541887, -122610455, -1619422458, -1235467726, 317607795, -1377359294, 216354161, -1502081431, -415508231, -1035656561, 1604513050, 291667229, 639101487, -683651658, 579844215, -986213067, -33554291, -974042850, 440130318, -1701786472, -1599347723, -1401287400, -2017774280, -1574651145, -230069084, 1784388566, -1703040808, 1916900983, -1553273779, 705211405, -62031071, 636660432, 1332823764, -1264188483, 424581010, -1889480932, -309665737, -1535143759, 1592546723, 845951956, 1870206607, -1124325382, -639144700, 2034437683, -792479961, -725940561, -2012936597, -1427173072, 76910575, 775057652, -173473816, 705207410, -12510212, -689072814, 1649669615, 209939503, -1215008336, 310187900, -117321990, -9053114, -562434993, -370019966, -1658267443, -53900652, 578187458, 1186448524, -1881702965, 1622961510, -411749843, 233775697, -203615029, 1816081512, -2023136700, 281845950, 494905110, -1789159877, -449093516, 2007998148, -58367744, -1851757113, -1923750927, -121109085, -207500422, -1126884243, 807394527, -607400876, -1954152873, -1804767106, 948580052, -994493861, -729402926, -1372893400, 1534268306, -546414050, -1000797136, -1549648683, -1076979559, 1176555513, -1771271105, 2049975638, 1071991290, 1733508727, -2145058046, -846618649, 1766750186, 142168669, -1419348508, 1983875893, 1988421281, -1885122448, -369308943, 762418615, -2051780218, -1418095849, 746896684, -130724855, 47802485, -1881357424, -156280084, 710428473, -1977899031, -364447310, -1733504433, -58050012, -1533612039, 1650209002, -957741771, 1054062038, -3315875, 186063350, 454839931, 839296626, 1660688465, -1499150463, 2025577406, 113363150, 1464320832, -545892, -340814992, -139360856, -131031164, -99221026, -100890752, 1505949885, -414200485, -250219137, -572902606, 786785640, -1574685095, -1653778545, -1152354956, -1781248498, -606131261, 230799184, -962444735, 545091861, -1019752412, 941092762, -370070321, 1298660477, 1034254891, 919973, -415644254, 2071860755, 601192190, 1765909008, 1464996240, -599565888, -655437064, 2019725391, -65562047, -287149714, 908916586, 168325234, 1047408553, -1356198149, 572346687, -262875050, -1020693657, 470390984, -1503389905, -496796530, -1048918060, 235151171, 228330212, -1824073009, 2142412821, -383617342, 558337022, 295578892, 1601613487, -1105089812, 1662471519, 330798787, 262204321, -487118982, 1062558530, 34981860, -1775866118, 693347537, -1375987942, 962737319, 1443627641, -274279738, -192046246, 1093781425, -1641009296, 1669111587, 576942896, 160595574, 144232918, 460943988, -1697345118, -1562429913, 19676880, -1046738473, -1560432810, 1536293117, 998001097, 627658025, -676057444, -1480720301, -1457580191, -660698326, 1736728727, 1992114182, -1192556782, -2053375881, -901589236, 619186793, -651442792, 1430883358, -2032223605, -138198857, -1553159662, 103931372, -1072402456, 798334707, -130019572, 1492547232, 1256521235, -1672810410, -1636886058, 313125737, 451859790, 885592340, -1760395195, -1844633767, -1573974, 766813809, 1852831658, -737327427, 360249657, 365284294, -13275184, -707696628, 1527894349, -413843008, 266527418, 987058952, -1895601559, -1447050291, -2023206088, 1358992052, 526803498, -1721550926, -986609377, -1741219181, -647823104, 1363145011, -813465126, -317527831, -473006981, -1888281931, 1360766914, -1653256569, 608568236, -40270367, -1051191451, -2065364462, -1599406028, 1676566722, -547704248, 162800130, -897058666, -898963984, -1519790039, -1753419109, -714462673, -2052254414, -97905894, 7880833, -2114919322, -338476845, -1015361308, -794137222, 919754015, -687897528, -944204731, -1540087379, 1005016064, 1434083823, 257006356, 1448097145, 479008333, 231666523, 1033838378, 1456494322, 1569707244, -1535007920, 2091768256, 1882676450, -2094645974, 1478945339, -95273753, 1355367307, 1962715485, 1654030069, 301818921, -877075828, 1744543361, -593620665, -1567198473, 485691639, -1310598938, 1065758707, 1792934695, -1456523642, -310775451, 899552800, 918980918, -462428895, 207500976, 1839045851, -1063915827, 1450038021, 1838599478, 1561418368, 714377640, -586779512, 1940715569, 1938997488, 812677176, -1836949438, 1740981576, -131054771, -337217452, -1359177151, -893423553, 1380108159, 523790249, 1209485113, -2041068642, -1592637470, -1259969971, -939530358, 504473665, 1720722507, -1915972974, 1558502596, -338976723, 787894333, 1337491644, -1186355367, 2075232798, 1500762856, 1467668646, -1445684946, 438602252, -867938067, 2114025683, -376795329, 547337008, -138460932, 1663185331, 1884683695, 1998186069, -120286189, -1040143868, -1975445446, -543025215, -854845859, 150914588, -278888376, -509628884, -305728534, -2053477895, 1603716973, 1461382249, -1661042780, 1764470640, -1156301644, -392788360, -55086063, 47392397, -842802525, 1364097257, -1573804928, -1967062016, -509989727, -92729375, -2138051428, -462026400, 1659490385, 1548419179, 585864963, 1114331399, -98774216, -1548451558, -1386117695, 882834368, -287142590, 39002053, -786748339, 1530656869, -192792953, 1335015095, -77325216, 206729129, 1111723496, -708053088, 1420627231, -1259978999, 1717732843, -403963275, 1474765402, -1343835933, 390274263, 867996164, -1969439266, -1797718403, -918293652, 323535814, 1137679244, 1518644768, 1832332778, -620020590, -252532947, 1194991591, 103028447, 169002524, 914407682, -1929279013, 136589919, -4620627, 227358015, 1246654146, 1982086071, -624967954, -846982953, -1559291965, 727305967, -634914880, 2031976763, -1068406975, -1285298945, 836616119, 1239094672, -666676932, -1926137227, -1304197153, 1677541478, -1594039144, 2067979927, 820894732, 119198242, 982537412, 1558401688, 928769611, 279917256, -1449546271, -90223311, -69055958, 1284665675, -857537174, -1474469526, 1001689619, 1929194254, 457625982, -1844077625, 1952637298, 1339833861, -217464733, -1858907348, -433220799, 1746552945, -1319533275, 1233953672, -1767380351, 2031913605, 708026850, 510311559, -1306900360, 1710933307, 1494624993, 579177008, 1089791337, -439680989, 1651298976, -26374200, -1149315133, -1705675885, -788570528, 706801051, 1319828314, -1097587267, 1667370209, 837428461, 137249386, 2146654835, -1501578583, -756824647, 445704554, 1911656836, -1204373365, -450911865, 1113023544, 1490192246, 1203606179, 159475810, 693188847, 598420401, -674921248, 395511343, -867702702, -1024747773, -427741805, -1532342994, 2137217913, -1488946391, -1759199097, 1080953038, 1811011767, -1628063723, -221843308, -2044289886, 402500175, -1687921823, 1880865771, -1914192713, -731371926, 1222591662, 1460340938, 2052826171, -57511150, 878814173, 268327235, -2029649035, -1920270633, -2083388537, 2011872081, -127073189, 1906603319, -1538761048, -47486269, -1262870577, 836562562, -1958621706, -355605461, 48127931, -1238295896, 362212957, 895271837, -1105557567, 31579911, -29278906, 1583223723, 807616470, -1723559278, 882204108, 523752340, -734643779, 1707708142, 1740133779, 375435937, -41490016, 867921498, -581397765, -1501355887, -797453802, 893124250, -1264515290, -904244370, -309659967, 1104242641, 1599424833, -1812724950, -2082981147, -930715131, -1016259041, -1784642875, -664900435, 808174468, 1107003159, 1629625544, -828750643, 679799841, -1760422611, 1100892473, 842431303, 596567090, -763425906, -1544884956, 519033001, -209050624, 1925239986, -1948524863, 1446652761, 223352699, -1340770577, 2111435582, 2030420256, 1175917270, 2015780499, 1420369675, -1198605888, -1651927121, -887287146, -99992969, 1538420185, -153454369, 1404626956, -983770378, -2028324495, 198759202, -90305892, -1785422322, -380694821, 367029029, -1958857524, -1744674391, 982508608, -953995094, -1074411338, 1214908646, 1799292520, 1405683553, 499267403, -1167967306, 1913495551, -2074805542, 703632739, 1695691534, -2076770238, -631914165, -432440537, -620512057, -689800826, 1211815154, -522009702, 1168009106, 62988524, 333412423, -1007781919, -1125221164, -617138964, 236579762, 352407930, -2125360905, -365905364, -312978884, -1647948792, 1490580799, 531067333, 1998715657, -968024224, -200811496, 1876631091, -1985229640, 799770389, -655477458, 1103079268, -637376530, 1702445184, -485925531, 149034123, 389088181, 1432828280, -1921601005, 1859399243, -1101491307, -817082998, -751717833, 183694539, 539748346, 780647463, 336238047, -1596854402, 271702576, 1661943462, 238750097, -1166277534, -896919252, 1719932898, 745443013, 1059996530, 822683625, -1468309682, 568586885, 1722463422, -1769975949, 159135291, 1984190481, -1349321865, 1711280311, 1073064891, -626719280, 400307336, 1171965546, -1472932117, -1393531873, 89612660, 683612248, 142778002, -742009552, 1791819954, -211024315, 1132841703, -1817108600, 1040063911, 761133528, -719500913, 487730052, 749167007, 1729083962, -1516294119, -765796863, 1139748744, 97479412, 1875097056, 811217054, -1212357253, 1237669523, -711207216, -552392884, -1520170729, -1192721120, -132138907, 609839055, 1682047250, -1754132528, 251204600, -1613818636, -1717015968, 353034357, 457958686, 318665576, 595075051, 911716547, -1862774894, 137323117, -262680847, -263208255, -2023230703, 604682296, 369452224, -1762376179, 746478723, -1269928543, 1140353761, -475013373, 873935970, 427655216, -1339200793, 216794988, 263835742, 531058073, 66675566, 61842509, 2043589740, -1952566952, -1383606202, -1351006702, -587157967, -561159202, 580673126, 770993684, 1018901969, -1741511333, -1342980068, -1353923906, 84499499, -294919089, 2073809784, 161870111, -35900406, 17670394, 1619480163, -1627151477, -570549243, -1917989866, 1845063956, -529032484, -1914164857, -2083740004, 951164540, -339538681, -1284553012, -296938413, 1965212432, 977523574, -1421865195, 1340996249, 48706110, 1280833152, -468120859, 1784396361, -742251560, 461876118, -1359709857, -195572435, 732857993, -1574321009, 1102929524, 634076584, -45620016, 170139644, 381737895, 1863608829, -2129914150, 1722266428, -422977535, -1664156186, -766543140, 466389376, 923288146, -1216752179, 1390696144, 825992414, -5203645, 245190175, 1513902508, 1862622980, -1297311194, -1208302001, 667683981, 875281091};

    protected RandomGenerator makeGenerator() {
        return new ISAACRandom(500L);
    }

    @Test
    public void testReference() {
        ISAACRandom isaacRandom = new ISAACRandom(SEED_1);
        int[] actualSequence = this.getActualSequence(isaacRandom);
        Assert.assertArrayEquals((int[])EXPECTED_SEQUENCE_1, (int[])actualSequence);
        isaacRandom.setSeed(SEED_2);
        actualSequence = this.getActualSequence(isaacRandom);
        Assert.assertArrayEquals((int[])EXPECTED_SEQUENCE_2, (int[])actualSequence);
    }

    private int[] getActualSequence(ISAACRandom isaacRandom) {
        int[] actualSequence = new int[1024];
        for (int i = 0; i < actualSequence.length; ++i) {
            actualSequence[i] = isaacRandom.nextInt();
        }
        return actualSequence;
    }
}

