/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.interval;

import org.apache.commons.math3.stat.interval.AgrestiCoullInterval;
import org.apache.commons.math3.stat.interval.ClopperPearsonInterval;
import org.apache.commons.math3.stat.interval.ConfidenceInterval;
import org.apache.commons.math3.stat.interval.IntervalUtils;
import org.apache.commons.math3.stat.interval.NormalApproximationInterval;
import org.apache.commons.math3.stat.interval.WilsonScoreInterval;
import org.junit.Assert;
import org.junit.Test;

public class IntervalUtilsTest {
    private final int successes = 50;
    private final int trials = 500;
    private final double confidenceLevel = 0.9;
    private final double eps = 0.0;

    @Test
    public void testAgrestiCoull() {
        this.checkConfidenceIntervals(new AgrestiCoullInterval().createInterval(500, 50, 0.9), IntervalUtils.getAgrestiCoullInterval((int)500, (int)50, (double)0.9));
    }

    @Test
    public void testClopperPearson() {
        this.checkConfidenceIntervals(new ClopperPearsonInterval().createInterval(500, 50, 0.9), IntervalUtils.getClopperPearsonInterval((int)500, (int)50, (double)0.9));
    }

    @Test
    public void testNormalApproximation() {
        this.checkConfidenceIntervals(new NormalApproximationInterval().createInterval(500, 50, 0.9), IntervalUtils.getNormalApproximationInterval((int)500, (int)50, (double)0.9));
    }

    @Test
    public void testWilsonScore() {
        this.checkConfidenceIntervals(new WilsonScoreInterval().createInterval(500, 50, 0.9), IntervalUtils.getWilsonScoreInterval((int)500, (int)50, (double)0.9));
    }

    private void checkConfidenceIntervals(ConfidenceInterval expected, ConfidenceInterval actual) {
        Assert.assertEquals((double)expected.getLowerBound(), (double)actual.getLowerBound(), (double)0.0);
        Assert.assertEquals((double)expected.getUpperBound(), (double)actual.getUpperBound(), (double)0.0);
        Assert.assertEquals((double)expected.getConfidenceLevel(), (double)actual.getConfidenceLevel(), (double)0.0);
    }
}

