/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.transform;

import org.apache.commons.math3.transform.FastHadamardTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public final class FastHadamardTransformerTest {
    @Test
    public void test8Points() {
        this.checkAllTransforms(new int[]{1, 4, -2, 3, 0, 1, 4, -1}, new int[]{10, -4, 2, -4, 2, -12, 6, 8});
    }

    @Test
    public void test4Points() {
        this.checkAllTransforms(new int[]{1, 2, 3, 4}, new int[]{10, -2, -4, 0});
    }

    @Test
    public void testNoIntInverse() {
        FastHadamardTransformer transformer = new FastHadamardTransformer();
        double[] x = transformer.transform(new double[]{0.0, 1.0, 0.0, 1.0}, TransformType.INVERSE);
        Assert.assertEquals((double)0.5, (double)x[0], (double)0.0);
        Assert.assertEquals((double)-0.5, (double)x[1], (double)0.0);
        Assert.assertEquals((double)0.0, (double)x[2], (double)0.0);
        Assert.assertEquals((double)0.0, (double)x[3], (double)0.0);
    }

    @Test
    public void test3Points() {
        try {
            new FastHadamardTransformer().transform(new double[3], TransformType.FORWARD);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkAllTransforms(int[] x, int[] y) {
        this.checkDoubleTransform(x, y);
        this.checkInverseDoubleTransform(x, y);
        this.checkIntTransform(x, y);
    }

    private void checkDoubleTransform(int[] x, int[] y) {
        FastHadamardTransformer transformer = new FastHadamardTransformer();
        double[] dX = new double[x.length];
        for (int i = 0; i < dX.length; ++i) {
            dX[i] = x[i];
        }
        double[] dResult = transformer.transform(dX, TransformType.FORWARD);
        for (int i = 0; i < dResult.length; ++i) {
            Assert.assertTrue((boolean)Precision.equals((double)y[i], (double)dResult[i], (int)1));
        }
    }

    private void checkIntTransform(int[] x, int[] y) {
        FastHadamardTransformer transformer = new FastHadamardTransformer();
        int[] iResult = transformer.transform(x);
        for (int i = 0; i < iResult.length; ++i) {
            Assert.assertEquals((long)y[i], (long)iResult[i]);
        }
    }

    private void checkInverseDoubleTransform(int[] x, int[] y) {
        FastHadamardTransformer transformer = new FastHadamardTransformer();
        double[] dY = new double[y.length];
        for (int i = 0; i < dY.length; ++i) {
            dY[i] = y[i];
        }
        double[] dResult = transformer.transform(dY, TransformType.INVERSE);
        for (int i = 0; i < dResult.length; ++i) {
            Assert.assertTrue((boolean)Precision.equals((double)x[i], (double)dResult[i], (int)1));
        }
    }
}

