/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import org.apache.commons.validator.routines.checkdigit.AbstractCheckDigitTest;
import org.apache.commons.validator.routines.checkdigit.ModulusTenCheckDigit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ModulusTenCUSIPCheckDigitTest
extends AbstractCheckDigitTest {
    private static final String[] INVALID_CHECK_DIGITS = new String[]{"DUS0421CW", "DUS0421CN", "DUS0421CE"};
    private static final String[] VALID_CHECK_DIGITS = new String[]{"DUS0421C5"};

    ModulusTenCUSIPCheckDigitTest() {
    }

    @BeforeEach
    protected void setUp() {
        this.routine = new ModulusTenCheckDigit(new int[]{1, 2}, true, true);
        this.valid = new String[]{"037833100", "931142103", "837649128", "392690QT3", "594918104", "86770G101", "Y8295N109", "G8572F100"};
        this.invalid = new String[]{"0378#3100"};
    }

    @Test
    void testValidator336InvalidCheckDigits() {
        for (String invalidCheckDigit : INVALID_CHECK_DIGITS) {
            Assertions.assertFalse((boolean)this.routine.isValid(invalidCheckDigit), (String)("Should fail: " + invalidCheckDigit));
        }
    }

    @Test
    void testValidator336ValidCheckDigits() {
        for (String validCheckDigit : VALID_CHECK_DIGITS) {
            Assertions.assertTrue((boolean)this.routine.isValid(validCheckDigit), (String)("Should fail: " + validCheckDigit));
        }
    }
}

